/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.basic;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import zeus.actors.AgentContext;
import zeus.concepts.Address;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.gui.EditableMultipleSelectionDialog;
import zeus.gui.help.HelpWindow;
import zeus.util.Core;
import zeus.util.Misc;
import zeus.visualiser.MessageInfo;
import zeus.visualiser.VisualiserModel;
import zeus.visualiser.basic.MsgFilter;
import zeus.visualiser.basic.MsgFilterEditor;

public abstract class BasicTool
extends JFrame {
    protected AgentContext context = null;
    protected VisualiserModel model = null;
    protected MsgFilter filter = null;
    private EditableMultipleSelectionDialog connect_dialog = null;
    private MsgFilterEditor editor = null;

    public BasicTool(AgentContext agentContext, VisualiserModel visualiserModel) {
        this.context = agentContext;
        this.model = visualiserModel;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BasicTool.this.Exit();
            }
        });
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public VisualiserModel getModel() {
        return this.model;
    }

    public void Exit() {
        this.setVisible(false);
        this.removeSubscriptions();
        this.dispose();
    }

    public void Connect(boolean bl) {
        Object[] objectArray;
        if (!this.hubOK()) {
            return;
        }
        Object[] objectArray2 = this.model.getNameservers();
        if (this.connect_dialog == null) {
            this.connect_dialog = new EditableMultipleSelectionDialog((Frame)this, "Select Servers", objectArray2);
            this.connect_dialog.setLocationRelativeTo(this);
        } else {
            objectArray = this.connect_dialog.getPriorSelection();
            this.connect_dialog.setListData(objectArray2);
            this.connect_dialog.setSelection(objectArray);
        }
        objectArray = this.connect_dialog.getSelection();
        this.model.addNameservers(Misc.stringArray(this.connect_dialog.getListData()));
        if (objectArray != null && objectArray.length > 0) {
            this.subscribe(bl, this.model.keys[0], Misc.stringArray(objectArray), "log_address");
        }
    }

    public void quickConnect() {
        String[] stringArray = this.model.getNameservers();
        if (stringArray != null && stringArray.length > 0) {
            this.subscribe(true, this.model.keys[0], stringArray, "log_address");
        }
    }

    protected void subscribe(boolean bl, String string, String string2, String string3) {
        String string4 = null;
        String string5 = this.model.getSubscriptionContent(string);
        if (bl) {
            string4 = this.model.getMessageRule(string, string2, this, string3);
            if (string4 == null) {
                string4 = this.context.newId("Rule");
                String[] stringArray = new String[]{"type", "inform", "in-reply-to", string, "sender", string2};
                this.context.MsgHandler().addRule(new MessageRuleImpl(string4, stringArray, this, string3));
                this.model.addMessageRule(string, string2, this, string3, string4);
            }
            if (!this.model.isAlreadySubscribed(string, string2, string4)) {
                Performative performative = new Performative("subscribe");
                performative.setReceiver(string2);
                performative.setReplyWith(string);
                performative.setContent(string5);
                this.context.MailBox().sendMsg(performative);
                this.model.subscribe(string, string2, string4);
            }
        } else {
            string4 = this.model.removeMessageRule(string, string2, this, string3);
            this.context.MsgHandler().removeRule(string4);
            switch (this.model.unsubscribe(string, string2, string4)) {
                case 0: {
                    Performative performative = new Performative("cancel");
                    performative.setReceiver(string2);
                    performative.setReplyWith(string);
                    performative.setContent(string5);
                    this.context.MailBox().sendMsg(performative);
                    break;
                }
            }
        }
    }

    protected void subscribe(boolean bl, String string, String[] stringArray, String string2) {
        int n = 0;
        while (n < stringArray.length) {
            this.subscribe(bl, string, stringArray[n], string2);
            ++n;
        }
    }

    protected void query(String string, String string2, String string3) {
        String string4 = this.context.newId("Rule");
        String[] stringArray = new String[]{"in-reply-to", string4, "sender", string2};
        this.context.MsgHandler().addRule(new MessageRuleImpl(string4, stringArray, 0, this, string3));
        Performative performative = new Performative("query-ref");
        performative.setReceiver(string2);
        performative.setReplyWith(string4);
        performative.setContent(string);
        this.context.MailBox().sendMsg(performative);
    }

    protected void query(String string, String[] stringArray, String string2) {
        int n = 0;
        while (n < stringArray.length) {
            this.query(string, stringArray[n], string2);
            ++n;
        }
    }

    protected void request(String string, String string2, String string3) {
        String string4 = this.context.newId("Rule");
        String[] stringArray = new String[]{"in-reply-to", string4, "sender", string2};
        this.context.MsgHandler().addRule(new MessageRuleImpl(string4, stringArray, 0, this, string3));
        Performative performative = new Performative("request");
        performative.setReceiver(string2);
        performative.setReplyWith(string4);
        performative.setContent(string);
        this.context.MailBox().sendMsg(performative);
    }

    protected void request(String string, String[] stringArray, String string2) {
        int n = 0;
        while (n < stringArray.length) {
            this.request(string, stringArray[n], string2);
            ++n;
        }
    }

    protected boolean hubOK() {
        if (this.context == null || this.context.MailBox() == null || this.context.MsgHandler() == null || this.model == null) {
            JOptionPane.showMessageDialog(this, "Error", "Not connected to a visualiser hub", 0);
            return false;
        }
        return true;
    }

    public void log_address(Performative performative) {
        Vector vector = ZeusParser.addressList(performative.getContent());
        this.context.MailBox().add(vector);
        int n = 0;
        while (n < vector.size()) {
            Address address = (Address)vector.elementAt(n);
            String string = address.getName();
            String string2 = address.getType();
            this.model.addAgent(string, string2);
            this.registerAgent(string, string2);
            ++n;
        }
    }

    public void Filter() {
        block7: {
            if (!this.hubOK()) {
                return;
            }
            String[] stringArray = this.model.getAgents();
            if (this.editor == null) {
                this.editor = new MsgFilterEditor(this, "Edit Message Filter");
                this.editor.setLocationRelativeTo(this);
            }
            this.editor.setListData(stringArray);
            this.editor.setFilter(this.filter);
            this.filter = this.editor.getFilter();
            if (this.filter == null) break block7;
            if (this.filter.from != null) {
                this.model.addAgents(this.filter.from);
            }
            if (this.filter.to != null) {
                this.model.addAgents(this.filter.to);
            }
            if (this.filter.about != null) {
                try {
                    this.filter.regexp = new RE((Object)this.filter.about, 4);
                }
                catch (REException rEException) {
                    Core.USER_ERROR("Illegal 'about' filter: " + this.filter.about);
                    this.filter.about = null;
                    this.filter.regexp = null;
                }
            }
        }
    }

    public void About() {
        Point point = this.getLocation();
        HelpWindow helpWindow = new HelpWindow(this, point, "visualiser", "About");
        helpWindow.setSize(new Dimension(440, 440));
        helpWindow.setTitle("About ZEUS ...");
        helpWindow.validate();
    }

    protected boolean filterMsg(Performative performative) {
        if (this.filter == null) {
            return true;
        }
        String string = performative.getSender();
        String string2 = performative.getReceiver();
        if (this.filter.from != null && !Misc.member(string, this.filter.from)) {
            return false;
        }
        if (this.filter.to != null && !Misc.member(string2, this.filter.to)) {
            return false;
        }
        return this.filter.regexp == null || this.filter.regexp.isMatch((Object)performative.getContent());
    }

    protected void removeSubscriptions() {
        Hashtable hashtable = this.model.removeAllMessageRulesTo(this);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            MessageInfo messageInfo = (MessageInfo)enumeration.nextElement();
            String string = (String)hashtable.get(messageInfo);
            this.context.MsgHandler().removeRule(string);
            switch (this.model.unsubscribe(messageInfo.key, messageInfo.agent, string)) {
                case 0: {
                    Performative performative = new Performative("cancel");
                    performative.setReceiver(messageInfo.agent);
                    performative.setReplyWith(messageInfo.key);
                    performative.setContent(this.model.getSubscriptionContent(messageInfo.key));
                    this.context.MailBox().sendMsg(performative);
                    break;
                }
            }
        }
    }

    protected abstract void registerAgent(String var1, String var2);
}

