/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Misc;
import zeus.util.SystemProps;
import zeus.visualiser.MessageInfo;
import zeus.visualiser.SubscriptionInfo;

public class VisualiserModel {
    public static final int ADDRESS_KEY = 0;
    public static final int MESSAGE_KEY = 1;
    public static final int REPORT_KEY = 2;
    public static final int CANCEL_SUBSCRIPTION = 0;
    public static final int DO_NOTHING = 1;
    protected Hashtable sessionList = new Hashtable();
    protected Hashtable agentList = new Hashtable();
    protected Hashtable messageRuleDb = new Hashtable();
    protected Hashtable subscriptionDb = new Hashtable();
    protected Hashtable subscriptionContent = new Hashtable();
    protected AgentContext context = null;
    public String[] keys = new String[3];

    public VisualiserModel(AgentContext agentContext) {
        this.context = agentContext;
        int n = 0;
        while (n < this.keys.length) {
            this.keys[n] = agentContext.newId("VisualiserModel");
            ++n;
        }
        this.subscriptionContent.put(this.keys[0], "log_address");
        this.subscriptionContent.put(this.keys[1], "log_message");
        this.subscriptionContent.put(this.keys[2], "log_report");
    }

    public String getSubscriptionContent(String string) {
        return (String)this.subscriptionContent.get(string);
    }

    public void addAgent(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this.agentList.put(string, string2);
    }

    public void addAgents(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        String string = SystemProps.getProperty("agent.names.agent");
        int n = 0;
        while (n < stringArray.length) {
            if (!this.agentList.containsKey(stringArray[n])) {
                this.agentList.put(stringArray[n], string);
            }
            ++n;
        }
    }

    public String[] getAgents() {
        Enumeration enumeration = this.agentList.keys();
        String[] stringArray = new String[this.agentList.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String[] getAgents(String string) {
        Enumeration enumeration = this.agentList.keys();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.agentList.get(string2);
            if (!string3.equals(string)) continue;
            vector.addElement(string2);
        }
        return Misc.stringArray(vector);
    }

    public void addNameservers(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        String string = SystemProps.getProperty("agent.names.nameserver");
        int n = 0;
        while (n < stringArray.length) {
            this.agentList.put(stringArray[n], string);
            ++n;
        }
    }

    public void addNameserver(String string) {
        if (string == null) {
            return;
        }
        String string2 = SystemProps.getProperty("agent.names.nameserver");
        this.agentList.put(string, string2);
    }

    public String[] getNameservers() {
        return this.getAgents(SystemProps.getProperty("agent.names.nameserver"));
    }

    public void addDbProxy(String string) {
        if (string == null) {
            return;
        }
        String string2 = SystemProps.getProperty("agent.names.dbProxy");
        this.agentList.put(string, string2);
    }

    public void addDbProxys(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        String string = SystemProps.getProperty("agent.names.dbProxy");
        int n = 0;
        while (n < stringArray.length) {
            this.agentList.put(stringArray[n], string);
            ++n;
        }
    }

    public String[] getDbProxys() {
        return this.getAgents(SystemProps.getProperty("agent.names.dbProxy"));
    }

    public void addDbSession(String string, String string2, String string3) {
        HSet hSet;
        Hashtable<String, HSet> hashtable = (Hashtable<String, HSet>)this.sessionList.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, HSet>();
            this.sessionList.put(string, hashtable);
        }
        if ((hSet = (HSet)hashtable.get(string2)) == null) {
            hSet = new HSet();
            hashtable.put(string2, hSet);
        }
        hSet.add(string3);
    }

    public void addDbSessions(String string, Hashtable hashtable) {
        Hashtable<String, HSet> hashtable2 = (Hashtable<String, HSet>)this.sessionList.get(string);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable<String, HSet>();
            this.sessionList.put(string, hashtable2);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            HSet hSet = (HSet)hashtable.get(string2);
            HSet hSet2 = (HSet)hashtable2.get(string2);
            if (hSet2 == null) {
                hSet2 = new HSet();
                hashtable2.put(string2, hSet2);
            }
            hSet2.add(hSet);
        }
    }

    public Hashtable getDbSessions(String string) {
        Hashtable<String, HSet> hashtable = (Hashtable<String, HSet>)this.sessionList.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, HSet>();
            this.sessionList.put(string, hashtable);
        }
        String[] stringArray = this.getDbProxys();
        int n = 0;
        while (n < stringArray.length) {
            if (!hashtable.containsKey(stringArray[n])) {
                hashtable.put(stringArray[n], new HSet());
            }
            ++n;
        }
        return hashtable;
    }

    public String getMessageRule(String string, String string2, Object object, String string3) {
        MessageInfo messageInfo = new MessageInfo(string, string2, object, string3);
        return (String)this.messageRuleDb.get(messageInfo);
    }

    public String removeMessageRule(String string, String string2, Object object, String string3) {
        MessageInfo messageInfo = new MessageInfo(string, string2, object, string3);
        return (String)this.messageRuleDb.remove(messageInfo);
    }

    public void addMessageRule(String string, String string2, Object object, String string3, String string4) {
        MessageInfo messageInfo = new MessageInfo(string, string2, object, string3);
        Core.ERROR(this.messageRuleDb.put(messageInfo, string4) == null, 1, (Object)this);
    }

    public Hashtable removeAllMessageRulesTo(Object object) {
        Hashtable<MessageInfo, String> hashtable = new Hashtable<MessageInfo, String>();
        Enumeration enumeration = this.messageRuleDb.keys();
        while (enumeration.hasMoreElements()) {
            MessageInfo messageInfo = (MessageInfo)enumeration.nextElement();
            if (messageInfo.target != object) continue;
            String string = (String)this.messageRuleDb.remove(messageInfo);
            hashtable.put(messageInfo, string);
        }
        return hashtable;
    }

    public boolean isAlreadySubscribed(String string, String string2, String string3) {
        SubscriptionInfo subscriptionInfo = new SubscriptionInfo(string, string2);
        Vector vector = (Vector)this.subscriptionDb.get(subscriptionInfo);
        return vector != null && vector.contains(string3);
    }

    public void subscribe(String string, String string2, String string3) {
        SubscriptionInfo subscriptionInfo = new SubscriptionInfo(string, string2);
        Vector<String> vector = (Vector<String>)this.subscriptionDb.get(subscriptionInfo);
        if (vector == null) {
            vector = new Vector<String>();
            this.subscriptionDb.put(subscriptionInfo, vector);
        }
        Core.ERROR(!vector.contains(string3), 2, (Object)this);
        vector.addElement(string3);
    }

    public int unsubscribe(String string, String string2, String string3) {
        SubscriptionInfo subscriptionInfo = new SubscriptionInfo(string, string2);
        Vector vector = (Vector)this.subscriptionDb.get(subscriptionInfo);
        Core.ERROR(vector, 3, (Object)this);
        Core.ERROR(vector.removeElement(string3), 4, (Object)this);
        if (vector.isEmpty()) {
            this.subscriptionDb.remove(subscriptionInfo);
            return 0;
        }
        return 1;
    }
}

