/*
 * Decompiled with CFR 0.152.
 */
package zeus.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import zeus.util.Assert;

public class TreeNode {
    protected static final int NODES = 0;
    protected static final int VALUES = 1;
    protected Object data = null;
    protected Vector children = new Vector();
    protected TreeNode parent = null;

    public TreeNode(TreeNode treeNode, Object object) {
        this.setParent(treeNode);
        this.setValue(object);
    }

    public TreeNode(Object object) {
        this.setValue(object);
    }

    public Enumeration values() {
        return new PreorderEnumerator(this, 1);
    }

    public Enumeration nodes() {
        return new PreorderEnumerator(this, 0);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isTerminal() {
        return this.children.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public Object getValue() {
        return this.data;
    }

    public void setValue(Object object) {
        Assert.notNull(object);
        this.data = object;
    }

    public Vector getChildren() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.children.size()) {
            vector.addElement(this.children.elementAt(n));
            ++n;
        }
        return vector;
    }

    public boolean hasChild(TreeNode treeNode) {
        return this.children.contains(treeNode);
    }

    public void setParent(TreeNode treeNode) {
        this.parent = treeNode;
    }

    public boolean containsValue(Object object) {
        if (this.data.equals(object)) {
            return true;
        }
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.children.size()) {
            TreeNode treeNode = (TreeNode)this.children.elementAt(n);
            bl |= treeNode.containsValue(object);
            ++n;
        }
        return bl;
    }

    public TreeNode addChild(TreeNode treeNode) {
        treeNode.setParent(this);
        this.children.addElement(treeNode);
        return treeNode;
    }

    public TreeNode addChild(Object object) {
        TreeNode treeNode = new TreeNode(this, object);
        this.children.addElement(treeNode);
        return treeNode;
    }

    public TreeNode addChild(TreeNode treeNode, int n) {
        Assert.notFalse(n >= 0 && n <= this.children.size());
        treeNode.setParent(this);
        this.children.insertElementAt(treeNode, n);
        return treeNode;
    }

    public TreeNode addChild(Object object, int n) {
        Assert.notFalse(n >= 0 && n <= this.children.size());
        TreeNode treeNode = new TreeNode(this, object);
        this.children.insertElementAt(treeNode, n);
        return treeNode;
    }

    public void removeChild(TreeNode treeNode) {
        this.children.removeElement(treeNode);
    }

    public void removeChild(int n) {
        Assert.notFalse(n >= 0 && n < this.children.size());
        this.children.removeElementAt(n);
    }

    public TreeNode addBefore(Object object) {
        Assert.notNull(this.parent);
        TreeNode treeNode = new TreeNode(this.parent, object);
        this.parent.addBefore(treeNode, this);
        return treeNode;
    }

    public TreeNode addBefore(TreeNode treeNode) {
        Assert.notNull(this.parent);
        treeNode.setParent(this.parent);
        this.parent.addBefore(treeNode, this);
        return treeNode;
    }

    public TreeNode addAfter(Object object) {
        Assert.notNull(this.parent);
        TreeNode treeNode = new TreeNode(this.parent, object);
        this.parent.addAfter(treeNode, this);
        return treeNode;
    }

    public TreeNode addAfter(TreeNode treeNode) {
        Assert.notNull(this.parent);
        treeNode.setParent(this.parent);
        this.parent.addAfter(treeNode, this);
        return treeNode;
    }

    protected void addBefore(TreeNode treeNode, TreeNode treeNode2) {
        int n = 0;
        while (n < this.children.size()) {
            if (this.children.elementAt(n).equals(treeNode2)) {
                this.children.insertElementAt(treeNode, n);
                return;
            }
            ++n;
        }
        Assert.notNull(null);
    }

    protected void addAfter(TreeNode treeNode, TreeNode treeNode2) {
        int n = 0;
        while (n < this.children.size()) {
            if (this.children.elementAt(n).equals(treeNode2)) {
                this.children.insertElementAt(treeNode, n + 1);
                return;
            }
            ++n;
        }
        Assert.notNull(null);
    }

    public TreeNode nextSibling() {
        return this.parent != null ? this.parent.nextSibling(this) : null;
    }

    public TreeNode previousSibling() {
        return this.parent != null ? this.parent.previousSibling(this) : null;
    }

    protected TreeNode nextSibling(TreeNode treeNode) {
        int n = 0;
        while (n < this.children.size()) {
            if (this.children.elementAt(n).equals(treeNode)) {
                if (n + 1 < this.children.size()) {
                    return (TreeNode)this.children.elementAt(n + 1);
                }
                return null;
            }
            ++n;
        }
        Assert.notNull(null);
        return null;
    }

    protected TreeNode previousSibling(TreeNode treeNode) {
        int n = 0;
        while (n < this.children.size()) {
            if (this.children.elementAt(n).equals(treeNode)) {
                if (n - 1 >= 0) {
                    return (TreeNode)this.children.elementAt(n - 1);
                }
                return null;
            }
            ++n;
        }
        Assert.notNull(null);
        return null;
    }

    public TreeNode firstChild() {
        return this.children.isEmpty() ? null : (TreeNode)this.children.elementAt(0);
    }

    public String toString() {
        return this.data.toString();
    }

    class PreorderEnumerator
    implements Enumeration {
        TreeNode current = null;
        TreeNode root = null;
        int type;

        public PreorderEnumerator(TreeNode treeNode2, int n) {
            this.root = this.current = treeNode2;
            this.type = n;
        }

        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            TreeNode treeNode = this.current;
            this.current = treeNode.firstChild();
            if (this.current == null && treeNode != this.root) {
                this.current = treeNode.nextSibling();
            }
            if (this.current == null) {
                TreeNode treeNode2 = treeNode == this.root ? null : treeNode.getParent();
                while (treeNode2 != null && treeNode2 != this.root && (this.current = treeNode2.nextSibling()) == null) {
                    TreeNode treeNode3 = treeNode2 = treeNode2 == this.root ? null : treeNode2.getParent();
                }
            }
            if (this.type == 0) {
                return treeNode;
            }
            if (treeNode != null) {
                return treeNode.getValue();
            }
            return null;
        }
    }
}

