/*
 * Decompiled with CFR 0.152.
 */
package zeus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import zeus.concepts.TransportConfig;
import zeus.util.StringHashtable;

public class SystemProps {
    protected static Properties props;
    protected static final String[] defaults;
    public static boolean FIPA_IMPLEMENTED_TIGHTLY;
    private static StringHashtable transports;

    public static String getProperty(String string) {
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        return props.getProperty(string, string2);
    }

    public static boolean getState(String string) {
        String string2 = props.getProperty(string);
        return string2 != null ? Boolean.valueOf(string2) : false;
    }

    public static boolean getState(String string, boolean bl) {
        String string2 = props.getProperty(string);
        return string2 != null ? Boolean.valueOf(string2) : bl;
    }

    public static double getDouble(String string) {
        String string2 = props.getProperty(string);
        try {
            return string2 != null ? Double.valueOf(string2) : 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Illegal format for " + string + " entry in " + "properties database -- number format expected");
            return 0.0;
        }
    }

    public static double getDouble(String string, double d) {
        String string2 = props.getProperty(string);
        try {
            return string2 != null ? Double.valueOf(string2) : d;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Illegal format for " + string + " entry in " + "properties database -- number format expected");
            return d;
        }
    }

    public static int getInt(String string) {
        String string2 = props.getProperty(string);
        try {
            return string2 != null ? Integer.valueOf(string2) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Illegal format for " + string + " entry in " + "properties database -- number format expected");
            return 0;
        }
    }

    public static int getInt(String string, int n) {
        String string2 = props.getProperty(string);
        try {
            return string2 != null ? Integer.valueOf(string2) : n;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Illegal format for " + string + " entry in " + "properties database -- number format expected");
            return n;
        }
    }

    public static long getLong(String string) {
        String string2 = props.getProperty(string);
        try {
            return string2 != null ? (long)Long.valueOf(string2).intValue() : 0L;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Illegal format for " + string + " entry in " + "properties database -- number format expected");
            return 0L;
        }
    }

    public static long getLong(String string, long l) {
        String string2 = props.getProperty(string);
        try {
            return string2 != null ? Long.valueOf(string2) : l;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Illegal format for " + string + " entry in " + "properties database -- number format expected");
            return l;
        }
    }

    public static void list(PrintStream printStream) {
        props.list(printStream);
    }

    public static void list(PrintWriter printWriter) {
        props.list(printWriter);
    }

    public static synchronized void load(InputStream inputStream) throws IOException {
        props.load(inputStream);
    }

    public static Enumeration propertyNames() {
        return props.propertyNames();
    }

    public static synchronized void save(OutputStream outputStream, String string) {
        props.save(outputStream, string);
    }

    public static void main(String[] stringArray) {
        System.out.println(SystemProps.getProperty("application.gif"));
    }

    public static TransportConfig getTransport(String string) {
        System.out.println("trying to get transport " + string);
        TransportConfig transportConfig = (TransportConfig)transports.getForString(string);
        System.out.println(transportConfig);
        return transportConfig;
    }

    public static void setTransport(String string, TransportConfig transportConfig) {
        transports.put(string, transportConfig);
    }

    public static void setTransports(StringHashtable stringHashtable) {
        transports = stringHashtable;
    }

    static {
        String string;
        props = new Properties();
        defaults = new String[]{"agent.language", "java", "install.dir", System.getProperty("user.home"), "version.demo", "false", "version.id", "1.2.2", "application.gif", "gif_files.txt", "file.separator", ":", "debug.on", "false", "debug.level", "10", "HAP.address", "adastralcity.agentcities.net", "container.name", "defaultContainerCode", "system.protocols.respondent", "zeus.actors.graphs.ContractNetRespondent", "system.protocols.initiator", "zeus.actors.graphs.ContractNetInitiator", "friendly.name.zeus.actors.graphs.ContractNetRespondent", "Fipa-Contract-Net-Contractor", "friendly.name.zeus.actors.graphs.ContractNetInitiator", "Fipa-Contract-Net-Manager", "system.strategy.initiator", "zeus.actors.graphs.LinearInitiatorEvaluator", "system.strategy.respondent", "zeus.actors.graphs.LinearRespondentEvaluator", "system.strategy.initiator.default", "zeus.actors.graphs.DefaultInitiatorEvaluator", "system.strategy.respondent.default", "zeus.actors.graphs.DefaultRespondentEvaluator", "friendly.name.zeus.actors.graphs.DefaultInitiatorEvaluator", "Default-No-Negotiation", "friendly.name.zeus.actors.graphs.DefaultRespondentEvaluator", "Default-Fixed-Margin", "friendly.name.zeus.actors.graphs.LinearInitiatorEvaluator", "Linear-Growth", "friendly.name.zeus.actors.graphs.LinearRespondentEvaluator", "Linear-Decay", "share.plan", "true", "execute.earliest", "true", "registration.timeout", "3.0", "facilitator.timeout", "0.5", "address.timeout", "0.5", "accept.timeout", "1.5", "addressbook.refresh", "5.0", "facilitator.refresh", "5.0", "replan.period", "2.0", "facilitator.period.default", "5.0", "nameserver.period.default", "0.5", "nameserver.dns.default", "dns.db", "agent.names.nameserver", "Nameserver", "agent.names.facilitator", "Facilitator", "agent.names.visualiser", "Visualiser", "agent.names.dbProxy", "DbProxy", "agent.names.agent", "Agent", "planner.processors.min", "1", "planner.processors.max", "10", "planner.length.min", "10", "planner.length.max", "1000", "planner.doublebooking.min", "0", "planner.doublebooking.max", "100", "agent.default.name", "DefaultAgentName", "agent.default.class", "ZeusAgent", "agent.default.planner.processors", "1", "agent.default.planner.length", "20", "agent.default.planner.doublebooking", "0", "task.default.name", "DefaultTaskName", "task.default.time", "1", "task.default.cost", "0", "system.organisation.relations.default", "peer", "# Note: the ordering of the relations is important", "# Comment terminator", "system.organisation.relations", "superior:subordinate:peer:coworker", "ior.dir", "IOR_", "num.connections", "20", "http_root", "E:\\webapps\\ROOT\\", "TradeHouseName", "GateAgent", "TradeHousePlatform", "agntcity.barcelona.agentcities.net:2099/JADE", "service_platform", "http://193.113.27.14", "out_log", "FIPA_out_log.html", "in_log", "FIPA_in_log.html"};
        String string2 = System.getProperty("user.home");
        if (!string2.endsWith(string = File.separator)) {
            string2 = string2 + string;
        }
        String string3 = string2 + ".zeus.prp";
        File file = new File(string3);
        try {
            props.load(new FileInputStream(file));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 0;
        while (n < defaults.length) {
            if (props.get(defaults[n]) == null) {
                props.put(defaults[n], defaults[n + 1]);
            }
            n += 2;
        }
        String string4 = props.getProperty("install.dir");
        if (!string4.endsWith(string)) {
            string4 = string4 + string;
        }
        if (!(file = new File(string4)).exists()) {
            System.err.println("Improper install.dir specified in 'zeus.prp' properties file.\nExiting...");
            System.exit(0);
        }
        props.put("zeus.dir", string4);
        String string5 = string4 + "gifs" + string;
        props.put("gif.dir", string5);
        FIPA_IMPLEMENTED_TIGHTLY = false;
        transports = new StringHashtable();
    }
}

