/*
 * Decompiled with CFR 0.152.
 */
package zeus.util;

import java.util.Enumeration;
import java.util.Hashtable;
import zeus.util.Misc;

public class Profile {
    protected Hashtable table = new Hashtable();
    protected static final double TINY = 1.0E-8;

    public double p(double d) {
        String string = Integer.toString((int)d);
        Data data = (Data)this.table.get(string);
        if (data == null) {
            data = new Data();
            this.table.put(string, data);
        }
        return data.reject + data.accept == 0 ? 1.0 : 1.0 * (double)data.accept / (double)(data.reject + data.accept);
    }

    public double c(double d) {
        String string = Integer.toString((int)d);
        Data data = (Data)this.table.get(string);
        if (data == null) {
            data = new Data();
            this.table.put(string, data);
        }
        return data.cost;
    }

    public double e(double d) {
        double d3 = this.p(d);
        return d3 < 1.0E-8 ? Double.MAX_VALUE : this.c(d) / d3;
    }

    public void update(double d, double d3) {
        String string = Integer.toString((int)d);
        Data data = (Data)this.table.get(string);
        data.cost = ((double)data.accept * data.cost + d3) / (double)(data.accept + 1);
        ++data.accept;
    }

    public void update(double d) {
        String string = Integer.toString((int)d);
        Data data = (Data)this.table.get(string);
        ++data.reject;
    }

    public String toString() {
        Enumeration enumeration = this.table.keys();
        String string = "";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Data data = (Data)this.table.get(string2);
            if (!(Math.abs(data.cost - 0.0) > 1.0E-8)) continue;
            string = string + "Time:" + string2 + "\t" + "Accept:" + data.accept + "\t" + "Reject:" + data.reject + "\t" + "Cost:" + Misc.decimalPlaces(data.cost, 2) + "\n\t\t";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Profile profile = new Profile();
        double d = 4.2;
        double d3 = 125.0;
        double d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        profile.update(d, d3);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        d = 4.8;
        d3 = 300.0;
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        profile.update(d, d3);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        System.out.println("-----------");
        profile.update(d);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        profile.update(d);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        profile.update(d);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        profile.update(d);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        System.out.println("-----------");
        profile = new Profile();
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        profile.update(d);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        profile.update(d);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        profile.update(d);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        profile.update(d, d3);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
        profile.update(d, d3);
        d4 = profile.e(d);
        System.out.println(d4 + " " + profile);
    }

    class Data {
        double cost = 0.0;
        int reject = 0;
        int accept = 0;

        Data() {
        }
    }
}

