/*
 * Decompiled with CFR 0.152.
 */
package zeus.util;

import java.util.Enumeration;
import java.util.Vector;
import zeus.util.Assert;

public class PlainQueue {
    protected Vector[] data = null;

    public PlainQueue() {
        this(1);
    }

    public PlainQueue(int n) {
        Assert.notFalse(n > 0);
        this.data = new Vector[n];
        int n2 = 0;
        while (n2 < this.data.length) {
            this.data[n2] = new Vector();
            ++n2;
        }
    }

    public synchronized Enumeration elements() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (n2 < this.data[n].size()) {
                vector.addElement(this.data[n].elementAt(n2));
                ++n2;
            }
            ++n;
        }
        return vector.elements();
    }

    public synchronized boolean remove(Object object) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (n2 < this.data[n].size()) {
                if (this.data[n].contains(object)) {
                    this.data[n].removeElement(object);
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean remove(Object object, int n) {
        int n2 = 0;
        while (n2 < this.data[n].size()) {
            if (this.data[n].contains(object)) {
                this.data[n].removeElement(object);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void enqueue(Object object) {
        this.enqueue(object, 0);
    }

    public synchronized void enqueue(Object object, int n) {
        Assert.notFalse(n >= 0 && n < this.data.length);
        this.data[n].addElement(object);
    }

    public synchronized Object dequeue() {
        int n = 0;
        while (n < this.data.length) {
            if (!this.data[n].isEmpty()) {
                Object e = this.data[n].firstElement();
                this.data[n].removeElement(e);
                return e;
            }
            ++n;
        }
        return null;
    }

    public synchronized Object peek() {
        int n = 0;
        while (n < this.data.length) {
            if (!this.data[n].isEmpty()) {
                return this.data[n].firstElement();
            }
            ++n;
        }
        return null;
    }

    public synchronized boolean isEmpty() {
        int n = 0;
        while (n < this.data.length) {
            if (!this.data[n].isEmpty()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.data.length) {
            this.data[n].removeAllElements();
            ++n;
        }
    }
}

