/*
 * Decompiled with CFR 0.152.
 */
package zeus.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import zeus.util.HSet;

public class Misc {
    static final String DELIMITERS = "\n\r\t !%^&*()-+={[]}~,.:;#|\\";
    public static final String OPAQUE_CHAR = "#";
    public static final String QUOTE = "\"";

    public static final String literalToString(String string) {
        if (string.startsWith(QUOTE) && string.endsWith(QUOTE)) {
            return Misc.unescape(string.substring(1, string.length() - 1));
        }
        return Misc.unescape(string);
    }

    public static final String opaqueToString(String string) {
        return string.substring(1, string.length() - 1);
    }

    public static final String escape(String string) {
        String string2 = new String();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\u0000': {
                    Misc.debug("0 !");
                    string2 = string2 + '\u0000';
                    break;
                }
                case '\b': {
                    string2 = string2 + "\\b";
                    break;
                }
                case '\t': {
                    string2 = string2 + "\\t";
                    break;
                }
                case '\n': {
                    string2 = string2 + "\\n";
                    break;
                }
                case '\f': {
                    string2 = string2 + "\\f";
                    break;
                }
                case '\r': {
                    string2 = string2 + "\\r";
                    break;
                }
                case '\"': {
                    string2 = string2 + "\\\"";
                    break;
                }
                case '\'': {
                    string2 = string2 + "\\'";
                    break;
                }
                case '\\': {
                    string2 = string2 + "\\\\";
                    break;
                }
                default: {
                    char c = string.charAt(n);
                    if (c < ' ' || c > '~') {
                        String string3 = new String();
                        string3 = string3 + "0000";
                        string3 = string3 + Integer.toString(c, 16);
                        string2 = string2 + "\\u";
                        string2 = string2 + string3.substring(string3.length() - 4, string3.length());
                        break;
                    }
                    string2 = string2 + c;
                }
            }
            ++n;
        }
        return string2;
    }

    public static final String unescape(String string) {
        String string2 = new String();
        int n = 0;
        while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) != '\\') {
                string2 = string2 + c;
                continue;
            }
            c = string.charAt(n++);
            switch (c) {
                case '\u0000': {
                    break;
                }
                case 'b': {
                    string2 = string2 + "\b";
                    break;
                }
                case 't': {
                    string2 = string2 + "\t";
                    break;
                }
                case 'n': {
                    string2 = string2 + "\n";
                    break;
                }
                case 'f': {
                    string2 = string2 + "\f";
                    break;
                }
                case 'r': {
                    string2 = string2 + "\r";
                    break;
                }
                case '\"': {
                    string2 = string2 + QUOTE;
                    break;
                }
                case '\'': {
                    string2 = string2 + "'";
                    break;
                }
                case '\\': {
                    string2 = string2 + "\\";
                    break;
                }
                case ' ': {
                    string2 = string2 + " ";
                    break;
                }
                case 'u': {
                    String string3 = string.substring(n, n + 4);
                    Misc.debug("thisChar = " + string3);
                    n += 4;
                    int n2 = Integer.valueOf(string3, 16);
                    Misc.debug("val = " + String.valueOf(n2));
                    char c2 = (char)n2;
                    Misc.debug("appender = " + c2);
                    string2 = string2 + c2;
                    break;
                }
                default: {
                    string2 = string2 + "\\";
                    string2 = string2 + c;
                }
            }
        }
        return string2;
    }

    public static final String relativePath(String string) {
        if (string == null) {
            return null;
        }
        return Misc.relativePath(System.getProperty("user.dir"), string);
    }

    public static final String relativePath(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        return Misc.relativePath(string, new File(string2));
    }

    public static final String relativePath(String string, File file) {
        String string2;
        if (file == null) {
            return null;
        }
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        File file2 = new File(string);
        try {
            string = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file2.getAbsolutePath();
        }
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = file.getAbsolutePath();
        }
        int n = 0;
        while (string != null) {
            if (string2.startsWith(string) && !string.equals(File.separator)) {
                String string3 = "";
                int n2 = 0;
                while (n2 < n) {
                    string3 = string3 + "..";
                    if (n2 + 1 < n) {
                        string3 = string3 + File.separator;
                    }
                    ++n2;
                }
                if ((string3 = string3 + string2.substring(string.length())).startsWith(File.separator)) {
                    return "." + string3;
                }
                if (string3.equals("")) {
                    return ".";
                }
                return string3;
            }
            ++n;
            File file3 = new File(string);
            string = file3.getParent();
        }
        if (string2.equals("")) {
            return ".";
        }
        return string2;
    }

    public static final String spaces(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + " ";
            ++n2;
        }
        return string;
    }

    public static final String concat(String string, int[] nArray) {
        int n = 0;
        while (nArray != null && n < nArray.length) {
            string = string + " " + nArray[n];
            ++n;
        }
        return string;
    }

    public static final String concat(int[] nArray) {
        String string = "";
        int n = 0;
        while (nArray != null && n < nArray.length) {
            string = string + nArray[n] + " ";
            ++n;
        }
        string = string.trim();
        return string;
    }

    public static final String concat(String string, double[] dArray) {
        int n = 0;
        while (dArray != null && n < dArray.length) {
            string = string + " " + dArray[n];
            ++n;
        }
        return string;
    }

    public static final String concat(double[] dArray) {
        String string = "";
        int n = 0;
        while (dArray != null && n < dArray.length) {
            string = string + dArray[n] + " ";
            ++n;
        }
        return string.trim();
    }

    public static final String concat(String string, Object[] objectArray) {
        int n = 0;
        while (objectArray != null && n < objectArray.length) {
            string = string + " " + objectArray[n];
            ++n;
        }
        return string;
    }

    public static final String concat(Object[] objectArray) {
        String string = "";
        int n = 0;
        while (objectArray != null && n < objectArray.length) {
            string = string + objectArray[n] + " ";
            ++n;
        }
        string = string.trim();
        return string;
    }

    public static final String concat(String string, Vector vector) {
        int n = 0;
        while (vector != null && n < vector.size()) {
            string = string + " " + vector.elementAt(n);
            ++n;
        }
        return string;
    }

    public static final String concat(Vector vector) {
        String string = new String();
        int n = 0;
        while (vector != null && n < vector.size()) {
            string = string + vector.elementAt(n) + " ";
            ++n;
        }
        string = string.trim();
        return string;
    }

    public static final String concat(HSet hSet) {
        String string = new String();
        Enumeration enumeration = hSet.elements();
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement() + " ";
        }
        string = string.trim();
        return string;
    }

    public static final String substitute(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITERS, true);
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            string4 = string5.equals(string2) ? string4 + string3 : string4 + string5;
        }
        return string4;
    }

    public static final boolean member(int n, int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean member(String string, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final Vector intersection(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (!vector3.contains(e) && vector2.contains(e)) {
                vector3.addElement(e);
            }
            ++n;
        }
        return vector3;
    }

    public static final Vector union(Vector vector, Vector vector2) {
        Object e;
        Vector vector3 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            e = vector.elementAt(n);
            if (!vector3.contains(e)) {
                vector3.addElement(e);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            e = vector2.elementAt(n2);
            if (!vector3.contains(e)) {
                vector3.addElement(e);
            }
            ++n2;
        }
        return vector3;
    }

    public static final Vector difference(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (!vector3.contains(e) && !vector2.contains(e)) {
                vector3.addElement(e);
            }
            ++n;
        }
        return vector3;
    }

    public static final boolean isSubset(Vector vector, Vector vector2) {
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (!vector2.contains(e)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static final boolean sameVector(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            return false;
        }
        Vector vector3 = Misc.difference(vector, vector2);
        if (!vector3.isEmpty()) {
            return false;
        }
        vector3 = Misc.difference(vector2, vector);
        return vector3.isEmpty();
    }

    public static final boolean isNumber(String string) {
        return Misc.isLong(string) || Misc.isDouble(string);
    }

    public static final boolean isLong(String string) {
        try {
            long l = Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static final boolean isDouble(String string) {
        try {
            double d = Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static final void sort(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            int n = 0;
            while (n < stringArray.length - 1) {
                if (stringArray[n].compareTo(stringArray[n + 1]) > 0) {
                    String string = stringArray[n];
                    stringArray[n] = stringArray[n + 1];
                    stringArray[n + 1] = string;
                    bl = true;
                }
                ++n;
            }
        }
    }

    public static final void sort(Vector vector) {
        if (vector == null) {
            return;
        }
        if (vector.isEmpty()) {
            return;
        }
        if (!(vector.elementAt(0) instanceof String)) {
            return;
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            int n = 0;
            while (n < vector.size() - 1) {
                if (((String)vector.elementAt(n)).compareTo((String)vector.elementAt(n + 1)) > 0) {
                    Object e = vector.elementAt(n);
                    vector.setElementAt(vector.elementAt(n + 1), n);
                    vector.setElementAt(e, n + 1);
                    bl = true;
                }
                ++n;
            }
        }
    }

    public static final int whichPosition(String string, String[] stringArray) {
        if (string != null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public static final int whichPosition(String string, Vector vector) {
        if (string != null && vector != null) {
            int n = 0;
            while (n < vector.size()) {
                if (string.equals((String)vector.elementAt(n))) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public static final Vector flatten(Vector vector) {
        Vector vector2 = new Vector();
        if (vector == null || vector.isEmpty()) {
            return vector2;
        }
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof Vector) {
                Vector vector3 = Misc.flatten((Vector)e);
                int n2 = 0;
                while (n2 < vector3.size()) {
                    vector2.addElement(vector3.elementAt(n2));
                    ++n2;
                }
            } else {
                vector2.addElement(e);
            }
            ++n;
        }
        return vector2;
    }

    public static final Vector copyVector(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector vector2 = new Vector();
        if (vector.isEmpty()) {
            return vector2;
        }
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof Vector) {
                Vector vector3 = Misc.copyVector((Vector)e);
                vector2.addElement(vector3);
            } else {
                vector2.addElement(e);
            }
            ++n;
        }
        return vector2;
    }

    public static final String[] stringArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return Misc.stringArray(vector);
    }

    public static final String[] stringArray(Object[] objectArray) {
        if (objectArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = objectArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public static final String[] stringArray(Vector vector) {
        if (vector == null) {
            return new String[0];
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public static final Vector stringVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        return vector;
    }

    public static final String decimalPlaces(double d, int n) {
        return Misc.decimalPlaces(Double.toString(d), n);
    }

    public static final String decimalPlaces(String string, int n) {
        String string2 = "";
        int n2 = string.indexOf("E");
        if (n2 != -1) {
            string2 = string.substring(n2);
        }
        if ((n2 = string.indexOf(".")) == -1) {
            String string3 = string + ".";
            int n3 = 0;
            while (n3 < n) {
                string3 = string3 + "0";
                ++n3;
            }
            return string3 + string2;
        }
        int n4 = string.length();
        if (n4 > n2 + n) {
            return string.substring(0, n2 + n + 1) + string2;
        }
        String string4 = string;
        int n5 = 0;
        while (n5 < n + n2 + 1 - n4) {
            string4 = string4 + "0";
            ++n5;
        }
        return string4 + string2;
    }

    public static final String objectToContent(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        objectOutputStream.close();
        String string = byteArrayOutputStream.toString();
        string = Misc.escape(string);
        return string;
    }

    public static final Object contentToObject(String string) throws ClassNotFoundException, StreamCorruptedException, IOException {
        string = Misc.unescape(string);
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        return object;
    }

    public static final void debug(String string) {
    }

    public static final boolean isZero(double d) {
        return Math.abs(d) < 1.0E-12;
    }
}

