/*
 * Decompiled with CFR 0.152.
 */
package zeus.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import zeus.util.Assert;
import zeus.util.SystemProps;

public class Core {
    protected static PrintWriter out = new PrintWriter(System.out);
    public static boolean debug = SystemProps.getState("debug.on", false);
    public static int level = SystemProps.getInt("debug.level", 1);

    public static final void setDebuggerOutputFile(String string) {
        try {
            if (string != null) {
                out = new PrintWriter(new FileWriter(string));
            }
        }
        catch (IOException iOException) {
            out = new PrintWriter(System.out);
        }
    }

    public static void FAIL(String string) {
        System.err.println(string);
        if (debug) {
            Assert.notNull(null);
        }
    }

    public static final void DEBUG(int n, Object object) {
        if (debug && n <= level) {
            Core.debug(n, object);
        }
    }

    protected static final void debug(int n, Object object) {
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            out.print("DEBUG " + n + " [");
            int n2 = 0;
            while (n2 < objectArray.length) {
                out.print(objectArray[n2]);
                if (n2 < objectArray.length - 1) {
                    out.print(",");
                }
                ++n2;
            }
            out.println("]");
        } else {
            out.println("DEBUG " + n + " " + object);
        }
        out.flush();
    }

    public static void ERROR(Object object, int n, Object object2) {
        if (object == null) {
            Core.error(n, object2);
        }
    }

    public static void ERROR(boolean bl, int n, Object object) {
        if (!bl) {
            Core.error(n, object);
        }
    }

    protected static void error(int n, Object object) {
        if (object instanceof String) {
            System.err.println("INTERNAL ERROR: " + object + "#" + n);
        } else {
            String string = object.getClass().getName();
            System.err.println("INTERNAL ERROR in " + string + "#" + n);
        }
    }

    public static void USER_ERROR(String string) {
        System.err.println("USER ERROR: " + string);
        if (debug) {
            Assert.notNull(null);
        }
    }
}

