/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete.action;

import java.util.Enumeration;
import zeus.concepts.Fact;
import zeus.concepts.fn.ValueFunction;
import zeus.concepts.fn.VarFn;
import zeus.rete.Action;
import zeus.rete.Info;
import zeus.rete.action.ReteAction;
import zeus.util.Assert;
import zeus.util.Core;

public class ModifyAction
extends ReteAction {
    public void executeAction(Action action, Info info) {
        ValueFunction valueFunction = ((VarFn)action.head).resolve(info.getBindings());
        Assert.notFalse(valueFunction.getID() == 3);
        boolean bl = false;
        int n = 0;
        while (!bl && n < info.getInput().size()) {
            Fact fact = (Fact)info.getInput().elementAt(n);
            bl = fact.functor().equals(valueFunction);
            if (bl) {
                Core.DEBUG(2, " <== " + fact);
                this.retract(fact);
                Enumeration enumeration = action.table.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    ValueFunction valueFunction2 = (ValueFunction)action.table.get(string);
                    valueFunction2 = valueFunction2.resolve(info.getBindings());
                    fact.setValue(string, valueFunction2);
                }
                Core.DEBUG(2, " ==> " + fact);
                this.assertFact(fact);
            }
            ++n;
        }
        Assert.notFalse(bl);
    }

    private void retract(Fact fact) {
        if (this.context == null) {
            this.engine.update(1, fact);
        } else {
            this.context.ResourceDb().del(fact);
        }
    }

    public void assertFact(Fact fact) {
        if (this.context == null) {
            this.engine.update(0, fact);
        } else {
            this.context.ResourceDb().add(fact);
        }
    }
}

