/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.rete.PatternNode;
import zeus.rete.ReteEngine;
import zeus.util.Assert;
import zeus.util.Core;

class TestNode
extends PatternNode {
    ValueFunction value = null;

    TestNode(ReteEngine reteEngine, ValueFunction valueFunction) {
        super(reteEngine);
        this.value = valueFunction;
    }

    void evaluate(String string, int n, int n2, Vector vector, Bindings bindings) {
        Assert.notFalse(n2 == 0);
        ValueFunction valueFunction = this.value.resolve(bindings);
        if (!valueFunction.isDeterminate()) {
            Core.USER_ERROR("Non-ground argument in Rete test expression \"(test " + this.value + ")\"");
            return;
        }
        if (!(valueFunction instanceof LogicalFn)) {
            Core.USER_ERROR("Non-logical argument in Rete test expression \"(test " + this.value + ")\"");
            return;
        }
        if (((LogicalFn)valueFunction).evaluate() == 0) {
            this.propagate(string, n, vector, bindings);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TestNode)) {
            return false;
        }
        TestNode testNode = (TestNode)object;
        return this.value.equals(testNode.value);
    }

    public String toString() {
        return "TestNode(" + this.value + ")";
    }
}

