/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.ResourceDb;
import zeus.actors.event.FactAdapter;
import zeus.actors.event.FactEvent;
import zeus.actors.event.ReteEngineEvent;
import zeus.actors.event.ReteEngineMonitor;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.ReteKB;
import zeus.concepts.fn.ValueFunction;
import zeus.rete.ActionNode;
import zeus.rete.AttributeNode;
import zeus.rete.ConflictSet;
import zeus.rete.IdNode;
import zeus.rete.JoinNode;
import zeus.rete.LocalFactMonitor;
import zeus.rete.Node;
import zeus.rete.NotNode;
import zeus.rete.Pattern;
import zeus.rete.ReteFact;
import zeus.rete.Rule;
import zeus.rete.TestNode;
import zeus.rete.TypeNode;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Queue;

public class ReteEngine {
    static final int RULE_ACTIVATED = 0;
    static final int RULE_DEACTIVATED = 1;
    static final int RULE_ADDED = 2;
    static final int RULE_REMOVED = 3;
    static final int RULE_FIRED = 4;
    protected Hashtable factDb = new Hashtable();
    protected static final String PATH = "path#";
    protected static final String JPATH = "path@";
    protected Hashtable roots = new Hashtable();
    protected Hashtable ids = new Hashtable();
    protected Vector singles = new Vector();
    protected Vector joins = new Vector();
    protected Vector tests = new Vector();
    protected int pathNo = 0;
    protected int joinPathNo = 0;
    protected ConflictSet conflictSet;
    protected Fact initial_fact = null;
    protected AgentContext context = null;
    protected OntologyDb ontologyDb = null;
    private HSet[] eventMonitor = new HSet[5];
    private HSet localMonitor = new HSet();

    public ReteEngine() {
    }

    public ReteEngine(AgentContext agentContext) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        agentContext.set(this);
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
        this.conflictSet = new ConflictSet(agentContext);
        this.initial_fact = agentContext.OntologyDb().getFact(false, "ZeusFact");
        ResourceDb resourceDb = agentContext.ResourceDb();
        resourceDb.addFactMonitor(new SymFactAction(), 5L, true);
    }

    public ReteEngine(OntologyDb ontologyDb) {
        Assert.notNull(ontologyDb);
        this.ontologyDb = ontologyDb;
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
        this.conflictSet = new ConflictSet(this, ontologyDb);
        this.initial_fact = ontologyDb.getFact(false, "ZeusFact");
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public void run() {
        this.update(0, this.initial_fact);
        this.conflictSet.start();
    }

    public void reset() {
        this.conflictSet.reset();
        int n = 0;
        while (n < this.joins.size()) {
            JoinNode joinNode = (JoinNode)this.joins.elementAt(n);
            joinNode.reset();
            ++n;
        }
        Enumeration enumeration = this.factDb.elements();
        while (enumeration.hasMoreElements()) {
            this.update(0, (Fact)enumeration.nextElement());
        }
    }

    ConflictSet getConfictSet() {
        return this.conflictSet;
    }

    Hashtable getFactDb() {
        return this.factDb;
    }

    public void update(int n, ReteFact reteFact) {
        Fact fact = this.ontology().getFact(false, reteFact.type);
        Enumeration enumeration = reteFact.data.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ValueFunction valueFunction = (ValueFunction)reteFact.data.get(string);
            fact.setValue(string, valueFunction);
        }
        this.update(n, fact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int n, Fact fact) {
        Object object;
        if (this.context == null) {
            if (n == 0) {
                this.factDb.put(fact.getId(), fact);
            } else if (n == 1) {
                this.factDb.remove(fact.getId());
            }
        }
        this.fireLocalFactMonitor(n, fact);
        Vector<Fact> vector = new Vector<Fact>();
        vector.addElement(fact);
        boolean bl = false;
        TypeNode typeNode = (TypeNode)this.roots.get(fact.getType());
        if (typeNode != null) {
            bl = true;
            object = this.conflictSet.queue;
            synchronized (object) {
                typeNode.evaluate(null, n, 0, vector, new Bindings());
            }
        }
        object = this.ontology().allAncestors(fact.getType());
        while (object.hasNext() && !bl) {
            typeNode = (TypeNode)this.roots.get((String)object.next());
            if (typeNode == null) continue;
            bl = true;
            Queue queue = this.conflictSet.queue;
            synchronized (queue) {
                typeNode.evaluate(null, n, 0, vector, new Bindings());
            }
        }
    }

    private OntologyDb ontology() {
        return this.ontologyDb != null ? this.ontologyDb : this.context.OntologyDb();
    }

    public void add(ReteKB reteKB) {
        Rule[] ruleArray = reteKB.getRules();
        int n = 0;
        while (n < ruleArray.length) {
            ruleArray[n].setName(reteKB.getName() + "$" + ruleArray[n].getName());
            this.add(ruleArray[n]);
            ++n;
        }
    }

    public void add(Rule rule) {
        Object object;
        Object object2;
        int n;
        boolean bl;
        int n2;
        Object object3;
        Object[] objectArray;
        ReteFact reteFact;
        String string;
        Pattern pattern;
        Object object4 = null;
        rule = rule.duplicate("var", this.ontology().GenSym());
        Core.DEBUG(2, "Compiling rule " + rule.name);
        Node[] nodeArray = new Node[rule.nTerminals()];
        int n3 = 0;
        int n4 = 0;
        while (n4 < rule.patterns.size()) {
            pattern = (Pattern)rule.patterns.elementAt(n4);
            switch (pattern.tag) {
                case 2: 
                case 3: {
                    --n3;
                    break;
                }
                default: {
                    string = PATH + (this.pathNo + n3);
                    reteFact = (ReteFact)pattern.data;
                    if (this.roots.containsKey(reteFact.type)) {
                        nodeArray[n3] = (Node)this.roots.get(reteFact.type);
                        Core.DEBUG(4, "=t");
                        Core.DEBUG(5, "=t[" + nodeArray[n3] + "]");
                    } else {
                        nodeArray[n3] = new TypeNode(this, reteFact.type);
                        this.roots.put(reteFact.type, nodeArray[n3]);
                        Core.DEBUG(4, "+t");
                        Core.DEBUG(5, "+t[" + nodeArray[n3] + "]");
                    }
                    ++nodeArray[n3].use_count;
                    object4 = nodeArray[n3];
                    if (pattern.id != null) {
                        if (this.ids.containsKey(pattern.id)) {
                            nodeArray[n3] = (Node)this.ids.get(pattern.id);
                            Core.DEBUG(4, "=i");
                            Core.DEBUG(5, "=i[" + nodeArray[n3] + "]");
                        } else {
                            nodeArray[n3] = new IdNode(this, pattern.id);
                            this.ids.put(pattern.id, nodeArray[n3]);
                            Core.DEBUG(4, "+i");
                            Core.DEBUG(5, "+i[" + nodeArray[n3] + "]");
                        }
                        ++nodeArray[n3].use_count;
                        ((Node)object4).addSuccessor(string, nodeArray[n3], 0);
                        object4 = nodeArray[n3];
                    }
                    objectArray = reteFact.listValues();
                    String[] stringArray = reteFact.listAttributes();
                    object3 = new Vector();
                    n2 = 0;
                    while (n2 < objectArray.length) {
                        if (((ValueFunction)objectArray[n2]).isDeterminate()) {
                            nodeArray[n3] = new AttributeNode(this, stringArray[n2], (ValueFunction)objectArray[n2]);
                            bl = false;
                            n = 0;
                            while (!bl && n < this.singles.size()) {
                                bl = nodeArray[n3].equals(this.singles.elementAt(n));
                                if (bl) {
                                    nodeArray[n3] = (Node)this.singles.elementAt(n);
                                }
                                ++n;
                            }
                            if (!bl) {
                                this.singles.addElement(nodeArray[n3]);
                                Core.DEBUG(4, "+d");
                                Core.DEBUG(5, "+d[" + nodeArray[n3] + "]");
                            } else {
                                Core.DEBUG(4, "=d");
                                Core.DEBUG(5, "=d[" + nodeArray[n3] + "]");
                            }
                            ++nodeArray[n3].use_count;
                            ((Node)object4).addSuccessor(string, nodeArray[n3], 0);
                            object4 = nodeArray[n3];
                        } else {
                            ((Vector)object3).addElement(stringArray[n2]);
                            ((Vector)object3).addElement(objectArray[n2]);
                        }
                        ++n2;
                    }
                    n = 0;
                    while (n < ((Vector)object3).size()) {
                        object2 = (String)((Vector)object3).elementAt(n);
                        object = (ValueFunction)((Vector)object3).elementAt(n + 1);
                        nodeArray[n3] = new AttributeNode(this, (String)object2, (ValueFunction)object);
                        bl = false;
                        int n5 = 0;
                        while (!bl && n5 < this.singles.size()) {
                            bl = nodeArray[n3].equals(this.singles.elementAt(n5));
                            if (bl) {
                                nodeArray[n3] = (Node)this.singles.elementAt(n5);
                            }
                            ++n5;
                        }
                        if (!bl) {
                            this.singles.addElement(nodeArray[n3]);
                            Core.DEBUG(4, "+n");
                            Core.DEBUG(5, "+n[" + nodeArray[n3] + "]");
                        } else {
                            Core.DEBUG(4, "=n");
                            Core.DEBUG(5, "=n[" + nodeArray[n3] + "]");
                        }
                        ++nodeArray[n3].use_count;
                        ((Node)object4).addSuccessor(string, nodeArray[n3], 0);
                        object4 = nodeArray[n3];
                        n += 2;
                    }
                    break block0;
                }
            }
            ++n4;
            ++n3;
        }
        n3 = 0;
        objectArray = new JoinNode[nodeArray.length - 1];
        int n6 = 1;
        while (n6 < rule.patterns.size()) {
            pattern = (Pattern)rule.patterns.elementAt(n6);
            switch (pattern.tag) {
                case 2: 
                case 3: {
                    --n3;
                    break;
                }
                default: {
                    reteFact = (ReteFact)pattern.data;
                    objectArray[n3] = pattern.tag == 0 ? new JoinNode(this) : new NotNode(this);
                    object3 = reteFact.listValues();
                    object2 = reteFact.listAttributes();
                    object = reteFact.variables();
                    n2 = -1;
                    n = 0;
                    while (n < n6) {
                        pattern = (Pattern)rule.patterns.elementAt(n);
                        if (pattern.tag == 0) {
                            ++n2;
                            reteFact = (ReteFact)pattern.data;
                            ValueFunction[] valueFunctionArray = reteFact.listValues();
                            String[] stringArray = reteFact.listAttributes();
                            boolean[][] blArray = new boolean[valueFunctionArray.length][((ValueFunction[])object3).length];
                            int n7 = 0;
                            while (n7 < blArray.length) {
                                int n8 = 0;
                                while (n8 < blArray[n7].length) {
                                    blArray[n7][n8] = false;
                                    ++n8;
                                }
                                ++n7;
                            }
                            int n9 = 0;
                            while (n9 < ((ValueFunction[])object).length) {
                                int n10 = 0;
                                while (n10 < valueFunctionArray.length) {
                                    if (valueFunctionArray[n10].references(object[n9])) {
                                        int n11 = 0;
                                        while (n11 < ((Object)object3).length) {
                                            if (!blArray[n10][n11] && ((ValueFunction)object3[n11]).references(object[n9])) {
                                                blArray[n10][n11] = true;
                                                ((JoinNode)objectArray[n3]).add(n2, stringArray[n10], valueFunctionArray[n10], 0, (String)object2[n11], (ValueFunction)object3[n11]);
                                            }
                                            ++n11;
                                        }
                                    }
                                    ++n10;
                                }
                                ++n9;
                            }
                        }
                        ++n;
                    }
                    break block3;
                }
            }
            ++n6;
            ++n3;
        }
        object2 = nodeArray[0];
        object = PATH + this.pathNo;
        n3 = 0;
        n2 = 1;
        while (n2 < rule.patterns.size()) {
            pattern = (Pattern)rule.patterns.elementAt(n2);
            switch (pattern.tag) {
                case 3: {
                    --n3;
                    break;
                }
                case 2: {
                    --n3;
                    object4 = object2;
                    object2 = new TestNode(this, (ValueFunction)pattern.data);
                    bl = false;
                    n = 0;
                    while (!bl && n < this.tests.size()) {
                        bl = object2.equals(this.tests.elementAt(n));
                        if (bl) {
                            object2 = (Node)this.tests.elementAt(n);
                        }
                        ++n;
                    }
                    if (!bl) {
                        this.tests.addElement(object2);
                        Core.DEBUG(4, "+c");
                        Core.DEBUG(5, "+c[" + object2 + "]");
                    } else {
                        Core.DEBUG(4, "=c");
                        Core.DEBUG(5, "=c[" + object2 + "]");
                    }
                    ++((Node)object2).use_count;
                    ((Node)object4).addSuccessor((String)object, (Node)object2, 0);
                    break;
                }
                default: {
                    bl = false;
                    int n12 = 0;
                    while (!bl && n12 < this.joins.size()) {
                        bl = objectArray[n3].equals(this.joins.elementAt(n12));
                        if (bl) {
                            objectArray[n3] = (JoinNode)this.joins.elementAt(n12);
                        }
                        ++n12;
                    }
                    if (!bl) {
                        this.joins.addElement(objectArray[n3]);
                        Core.DEBUG(4, "+j");
                        Core.DEBUG(5, "+j[" + objectArray[n3] + "]");
                    } else {
                        Core.DEBUG(4, "=j");
                        Core.DEBUG(5, "=j[" + objectArray[n3] + "]");
                    }
                    ++objectArray[n3].use_count;
                    string = JPATH + this.joinPathNo++;
                    object3 = PATH + (this.pathNo + n3 + 1);
                    ((JoinNode)objectArray[n3]).addPath((String)object, (String)object3, string);
                    ((Node)object2).addSuccessor((String)object, (Node)objectArray[n3], 2);
                    nodeArray[n3 + 1].addSuccessor((String)object3, (Node)objectArray[n3], 3);
                    object2 = objectArray[n3];
                    object = string;
                }
            }
            ++n2;
            ++n3;
        }
        ActionNode actionNode = new ActionNode(this, rule.name, rule.salience, rule.actions);
        ++actionNode.use_count;
        ((Node)object2).addSuccessor((String)object, actionNode, 1);
        Core.DEBUG(4, "+a");
        Core.DEBUG(5, "+a[" + actionNode + "]");
        this.pathNo += nodeArray.length;
        String string2 = "ADD [" + actionNode.rule_name + "]";
        this.fireEvent(2, actionNode, string2);
    }

    public void remove(Rule rule) {
        Core.USER_ERROR("Function ReteEngine.remove(Rule r) not yet implemented");
    }

    public void addLocalFactMonitor(LocalFactMonitor localFactMonitor) {
        this.localMonitor.add(localFactMonitor);
    }

    public void removeLocalFactMonitor(LocalFactMonitor localFactMonitor) {
        this.localMonitor.remove(localFactMonitor);
    }

    void fireLocalFactMonitor(int n, Fact fact) {
        Enumeration enumeration = this.localMonitor.elements();
        while (enumeration.hasMoreElements()) {
            LocalFactMonitor localFactMonitor = (LocalFactMonitor)enumeration.nextElement();
            if (n == 0) {
                localFactMonitor.reteFactAdded(fact);
                continue;
            }
            localFactMonitor.reteFactDeleted(fact);
        }
    }

    public void addMonitor(ReteEngineMonitor reteEngineMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[2].add(reteEngineMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[3].add(reteEngineMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[0].add(reteEngineMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[1].add(reteEngineMonitor);
        }
        if ((l & 0x10L) != 0L) {
            this.eventMonitor[4].add(reteEngineMonitor);
        }
    }

    public void removeMonitor(ReteEngineMonitor reteEngineMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[2].remove(reteEngineMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[3].remove(reteEngineMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[0].remove(reteEngineMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[1].remove(reteEngineMonitor);
        }
        if ((l & 0x10L) != 0L) {
            this.eventMonitor[4].remove(reteEngineMonitor);
        }
    }

    void fireEvent(int n, ActionNode actionNode, String string) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 2: {
                ReteEngineEvent reteEngineEvent = new ReteEngineEvent((Object)this, actionNode.rule_name, actionNode.salience, string, 1L);
                while (enumeration.hasMoreElements()) {
                    ReteEngineMonitor reteEngineMonitor = (ReteEngineMonitor)enumeration.nextElement();
                    reteEngineMonitor.reteRuleAddedEvent(reteEngineEvent);
                }
                break;
            }
            case 3: {
                ReteEngineEvent reteEngineEvent = new ReteEngineEvent((Object)this, actionNode.rule_name, actionNode.salience, string, 2L);
                while (enumeration.hasMoreElements()) {
                    ReteEngineMonitor reteEngineMonitor = (ReteEngineMonitor)enumeration.nextElement();
                    reteEngineMonitor.reteRuleDeletedEvent(reteEngineEvent);
                }
                break;
            }
            case 0: {
                ReteEngineEvent reteEngineEvent = new ReteEngineEvent((Object)this, actionNode.rule_name, actionNode.salience, string, 4L);
                while (enumeration.hasMoreElements()) {
                    ReteEngineMonitor reteEngineMonitor = (ReteEngineMonitor)enumeration.nextElement();
                    reteEngineMonitor.reteRuleActivatedEvent(reteEngineEvent);
                }
                break;
            }
            case 1: {
                ReteEngineEvent reteEngineEvent = new ReteEngineEvent((Object)this, actionNode.rule_name, actionNode.salience, string, 8L);
                while (enumeration.hasMoreElements()) {
                    ReteEngineMonitor reteEngineMonitor = (ReteEngineMonitor)enumeration.nextElement();
                    reteEngineMonitor.reteRuleDeactivatedEvent(reteEngineEvent);
                }
                break;
            }
            case 4: {
                ReteEngineEvent reteEngineEvent = new ReteEngineEvent((Object)this, actionNode.rule_name, actionNode.salience, string, 16L);
                while (enumeration.hasMoreElements()) {
                    ReteEngineMonitor reteEngineMonitor = (ReteEngineMonitor)enumeration.nextElement();
                    reteEngineMonitor.reteRuleFiredEvent(reteEngineEvent);
                }
                break;
            }
        }
    }

    protected class SymFactAction
    extends FactAdapter {
        protected SymFactAction() {
        }

        public void factAddedEvent(FactEvent factEvent) {
            Fact fact = factEvent.getFact();
            ReteEngine.this.update(0, fact);
        }

        public void factDeletedEvent(FactEvent factEvent) {
            Fact fact = factEvent.getFact();
            ReteEngine.this.update(1, fact);
        }
    }
}

