/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.fn.ValueFunction;
import zeus.rete.JoinEntry;
import zeus.rete.Node;
import zeus.rete.ReteEngine;
import zeus.util.Assert;

class JoinNode
extends Node {
    static final int PLAIN = 0;
    static final int NOT = 1;
    Vector constraints = new Vector();
    Hashtable db = new Hashtable();
    Hashtable pathDb1 = new Hashtable();
    Hashtable pathDb2 = new Hashtable();
    Hashtable bindingsDb = new Hashtable();
    int type = 0;

    JoinNode(ReteEngine reteEngine) {
        super(reteEngine);
    }

    void add(int n, String string, ValueFunction valueFunction, int n2, String string2, ValueFunction valueFunction2) {
        JoinEntry joinEntry = new JoinEntry(n, string, valueFunction, n2, string2, valueFunction2);
        this.constraints.addElement(joinEntry);
    }

    void addPath(String string, String string2, String string3) {
        Assert.notFalse(this.pathDb1.put(string, string2) == null);
        Assert.notFalse(this.pathDb1.put(string2, string) == null);
        Assert.notFalse(this.pathDb2.put(string, string3) == null);
    }

    void reset() {
        this.db.clear();
        this.bindingsDb.clear();
    }

    void evaluate(String string, int n, int n2, Vector vector, Bindings bindings) {
        switch (n2) {
            case 2: {
                Vector vector2;
                int n3;
                String string2 = string;
                String string3 = (String)this.pathDb1.get(string);
                Vector<Vector> vector3 = (Vector<Vector>)this.db.get(string2);
                Vector<Bindings> vector4 = (Vector<Bindings>)this.bindingsDb.get(string2);
                if (vector3 == null) {
                    vector3 = new Vector<Vector>();
                    vector4 = new Vector<Bindings>();
                    this.db.put(string2, vector3);
                    this.bindingsDb.put(string2, vector4);
                }
                Vector vector5 = (Vector)this.db.get(string3);
                Vector vector6 = (Vector)this.bindingsDb.get(string3);
                if (vector5 == null) {
                    vector5 = new Vector();
                    vector6 = new Vector();
                    this.db.put(string3, vector5);
                    this.bindingsDb.put(string3, vector6);
                }
                if (n == 0) {
                    vector3.addElement(vector);
                    vector4.addElement(new Bindings(bindings));
                } else {
                    boolean bl = false;
                    n3 = 0;
                    while (!bl && n3 < vector3.size()) {
                        vector2 = (Vector)vector3.elementAt(n3);
                        bl = true;
                        int n4 = 0;
                        while (bl && n4 < vector.size()) {
                            Fact fact = (Fact)vector.elementAt(n4);
                            Fact fact2 = (Fact)vector2.elementAt(n4);
                            bl &= fact.equals(fact2);
                            ++n4;
                        }
                        if (bl) {
                            vector3.removeElementAt(n3);
                            vector4.removeElementAt(n3--);
                        }
                        ++n3;
                    }
                    if (!bl) {
                        return;
                    }
                }
                n3 = 0;
                while (n3 < vector5.size()) {
                    vector2 = (Vector)vector5.elementAt(n3);
                    Bindings bindings2 = new Bindings(bindings);
                    Bindings bindings3 = (Bindings)vector6.elementAt(n3);
                    if (bindings2.add(bindings3)) {
                        this.evaluate(string2, n, vector, vector2, bindings2);
                    }
                    ++n3;
                }
                break;
            }
            case 3: {
                Vector vector7;
                int n5;
                String string4 = string;
                String string5 = (String)this.pathDb1.get(string);
                Vector vector8 = (Vector)this.db.get(string5);
                Vector vector9 = (Vector)this.bindingsDb.get(string5);
                if (vector8 == null) {
                    vector8 = new Vector();
                    vector9 = new Vector();
                    this.db.put(string5, vector8);
                    this.bindingsDb.put(string5, vector9);
                }
                Vector<Vector> vector10 = (Vector<Vector>)this.db.get(string4);
                Vector<Bindings> vector11 = (Vector<Bindings>)this.bindingsDb.get(string4);
                if (vector10 == null) {
                    vector10 = new Vector<Vector>();
                    vector11 = new Vector<Bindings>();
                    this.db.put(string4, vector10);
                    this.bindingsDb.put(string4, vector11);
                }
                if (n == 0) {
                    vector10.addElement(vector);
                    vector11.addElement(new Bindings(bindings));
                } else {
                    boolean bl = false;
                    n5 = 0;
                    while (!bl && n5 < vector10.size()) {
                        vector7 = (Vector)vector10.elementAt(n5);
                        bl = true;
                        int n6 = 0;
                        while (bl && n6 < vector.size()) {
                            Fact fact = (Fact)vector.elementAt(n6);
                            Fact fact3 = (Fact)vector7.elementAt(n6);
                            bl &= fact.equals(fact3);
                            ++n6;
                        }
                        if (bl) {
                            vector10.removeElementAt(n5);
                            vector11.removeElementAt(n5--);
                        }
                        ++n5;
                    }
                    if (!bl) {
                        return;
                    }
                }
                n5 = 0;
                while (n5 < vector8.size()) {
                    vector7 = (Vector)vector8.elementAt(n5);
                    Bindings bindings4 = new Bindings(bindings);
                    Bindings bindings5 = (Bindings)vector9.elementAt(n5);
                    if (bindings4.add(bindings5)) {
                        this.evaluate(string5, n, vector7, vector, bindings4);
                    }
                    ++n5;
                }
                break;
            }
            default: {
                Assert.notNull(null);
            }
        }
    }

    protected void evaluate(String string, int n, Vector vector, Vector vector2, Bindings bindings) {
        Object object;
        boolean bl = true;
        int n2 = 0;
        while (bl && n2 < this.constraints.size()) {
            JoinEntry joinEntry = (JoinEntry)this.constraints.elementAt(n2);
            Fact fact = (Fact)vector.elementAt(joinEntry.l_position);
            Fact fact2 = (Fact)vector2.elementAt(joinEntry.r_position);
            object = fact.getFn(joinEntry.l_attribute);
            ValueFunction valueFunction = fact2.getFn(joinEntry.r_attribute);
            bl &= object != null && valueFunction != null && joinEntry.l_value.unifiesWith((ValueFunction)object, bindings) != null && joinEntry.r_value.unifiesWith(valueFunction, bindings) != null;
            ++n2;
        }
        if (bl) {
            object = new Vector();
            int n3 = 0;
            while (n3 < vector.size()) {
                ((Vector)object).addElement(vector.elementAt(n3));
                ++n3;
            }
            int n4 = 0;
            while (n4 < vector2.size()) {
                ((Vector)object).addElement(vector2.elementAt(n4));
                ++n4;
            }
            string = (String)this.pathDb2.get(string);
            this.propagate(string, n, (Vector)object, bindings);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof JoinNode)) {
            return false;
        }
        JoinNode joinNode = (JoinNode)object;
        if (joinNode.type != 0) {
            return false;
        }
        if (joinNode.constraints.size() != this.constraints.size()) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (bl && n < this.constraints.size()) {
            JoinEntry joinEntry = (JoinEntry)this.constraints.elementAt(n);
            JoinEntry joinEntry2 = (JoinEntry)joinNode.constraints.elementAt(n);
            bl &= joinEntry.equals(joinEntry2);
            ++n;
        }
        return bl;
    }

    public String toString() {
        return "JoinNode(" + this.constraints + ")";
    }
}

