/*
 * Decompiled with CFR 0.152.
 */
package zeus.rete;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.rete.Action;
import zeus.rete.ActionNode;
import zeus.rete.DataReader;
import zeus.rete.Info;
import zeus.rete.ReteEngine;
import zeus.rete.action.AbstractActionFactory;
import zeus.rete.action.ActionFactory;
import zeus.rete.action.BasicAction;
import zeus.util.Core;
import zeus.util.Queue;

public class ConflictSet
extends Thread {
    protected ReteEngine engine = null;
    protected AgentContext context = null;
    protected OntologyDb db = null;
    protected boolean running = true;
    protected Hashtable writers = new Hashtable();
    protected Hashtable readers = new Hashtable();
    public int cleanUpInterval = 1000;
    Queue queue = new Queue(10);

    ConflictSet(ReteEngine reteEngine, OntologyDb ontologyDb) {
        this.engine = reteEngine;
        this.db = ontologyDb;
        this.createWriter("t", System.out);
        this.createReader("t", System.in);
    }

    ConflictSet(AgentContext agentContext) {
        this.context = agentContext;
        this.engine = agentContext.ReteEngine();
        this.createWriter("t", System.out);
        this.createReader("t", System.in);
    }

    public Hashtable getWriters() {
        return this.writers;
    }

    public Hashtable getReaders() {
        return this.readers;
    }

    public void setReaders(Hashtable hashtable) {
        this.readers = hashtable;
    }

    public void setWriters(Hashtable hashtable) {
        this.writers = hashtable;
    }

    public void createWriter(String string, OutputStream outputStream) {
        if (this.writers.containsKey(string)) {
            Core.USER_ERROR("Output writer with logical name '" + string + " is already defined");
            return;
        }
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        this.writers.put(string, printWriter);
    }

    public void createWriter(String string, String string2, boolean bl) {
        if (this.writers.containsKey(string)) {
            Core.USER_ERROR("Output writer with logical name '" + string + " is already defined");
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(string2, bl), true);
            this.writers.put(string, printWriter);
        }
        catch (IOException iOException) {
            Core.USER_ERROR("Cannot create file " + string2);
        }
    }

    public void createReader(String string, String string2) {
        if (this.readers.containsKey(string)) {
            Core.USER_ERROR("Input reader with logical name '" + string + " is already defined");
            return;
        }
        try {
            DataReader dataReader = new DataReader(new FileReader(string2));
            this.readers.put(string, dataReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Core.USER_ERROR("File not found: " + string2 + ". Cannot create reader");
        }
    }

    public void createReader(String string, InputStream inputStream) {
        if (this.readers.containsKey(string)) {
            Core.USER_ERROR("Input reader with logical name '" + string + " is already defined");
            return;
        }
        DataReader dataReader = new DataReader(new InputStreamReader(inputStream));
        this.readers.put(string, dataReader);
    }

    OntologyDb ontology() {
        return this.context == null ? this.db : this.context.OntologyDb();
    }

    void update(String string, int n, Vector vector, Bindings bindings, ActionNode actionNode) {
        switch (n) {
            case 0: {
                Info info = new Info();
                info.path = string;
                info.input = vector;
                info.bindings = bindings;
                info.node = actionNode;
                String string2 = "==> Activation: " + actionNode.rule_name + ": " + this.getFactList(vector);
                this.engine.fireEvent(0, actionNode, string2);
                Core.DEBUG(3, string2);
                this.queue.enqueue(info, 9 - actionNode.salience);
                break;
            }
            case 1: {
                Enumeration enumeration = this.queue.elements();
                while (enumeration.hasMoreElements()) {
                    Info info = (Info)enumeration.nextElement();
                    if (!info.path.equals(string) || info.node != actionNode || !this.sameInput(info.input, vector)) continue;
                    String string3 = "<== Activation: " + actionNode.rule_name + ": " + this.getFactList(vector);
                    this.engine.fireEvent(1, actionNode, string3);
                    Core.DEBUG(3, string3);
                    this.queue.remove(info);
                }
                break;
            }
        }
    }

    public void reset() {
        this.queue.clear();
    }

    public void assertFact(Fact fact) {
        if (this.context == null) {
            this.engine.update(0, fact);
        } else {
            this.context.ResourceDb().add(fact);
        }
    }

    public void retract(Fact fact) {
        if (this.context == null) {
            this.engine.update(1, fact);
        } else {
            this.context.ResourceDb().del(fact);
        }
    }

    public void run() {
        int n = 0;
        while (this.running) {
            Core.DEBUG(5, this);
            Info info = (Info)this.queue.dequeue();
            String string = "FIRE [" + info.node.rule_name + "; " + info.input.size() + " facts] " + this.getFactList(info.input);
            this.engine.fireEvent(4, info.node, string);
            Core.DEBUG(2, string);
            int n2 = 0;
            while (n2 < info.node.actions.size()) {
                Action action = (Action)info.node.actions.elementAt(n2);
                this.executeAction(action, info);
                ++n2;
            }
            Thread.yield();
            if (n > this.cleanUpInterval) {
                System.gc();
                System.runFinalization();
                n = 0;
            }
            ++n;
        }
    }

    protected void executeAction(Action action, Info info) {
        AbstractActionFactory abstractActionFactory = new AbstractActionFactory();
        ActionFactory actionFactory = abstractActionFactory.getActionFactory();
        try {
            BasicAction basicAction = actionFactory.getAction(action.type);
            basicAction.setActuators(this, this.context);
            basicAction.executeAction(action, info);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getFactList(Vector vector) {
        String string = "";
        int n = 0;
        while (n < vector.size()) {
            Fact fact = (Fact)vector.elementAt(n);
            string = string + fact.getId();
            if (n + 1 < vector.size()) {
                string = string + ", ";
            }
            ++n;
        }
        return string;
    }

    private boolean sameInput(Vector vector, Vector vector2) {
        String string = this.getFactList(vector);
        String string2 = this.getFactList(vector2);
        return string.equals(string2);
    }

    public String toString() {
        String string = "BEGIN CONFLICT SET\n";
        Enumeration enumeration = this.queue.elements();
        while (enumeration.hasMoreElements()) {
            Info info = (Info)enumeration.nextElement();
            string = string + info.node.rule_name + ":  " + this.getFactList(info.input) + "\n";
        }
        string = string + "END CONFLICT SET";
        return string;
    }
}

