/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.service;

import zeus.ontology.service.DAML_S_Renderer;
import zeus.ontology.service.InstanceRenderer;
import zeus.ontology.service.ProcessRenderer;
import zeus.ontology.service.ProfileRenderer;
import zeus.ontology.service.RangeRenderer;
import zeus.ontology.service.SchemaRenderer;
import zeus.ontology.service.UnknownRendererTypeException;

public class RendererFactory {
    public static InstanceRenderer getInstanceRenderer(String string) throws UnknownRendererTypeException {
        if (string == null) {
            throw new UnknownRendererTypeException("Type cannot be null");
        }
        if (string.equalsIgnoreCase("DAML-S")) {
            return new DAML_S_Renderer();
        }
        throw new UnknownRendererTypeException("No type " + string + " available.");
    }

    public static RangeRenderer getRangeRenderer(String string) throws UnknownRendererTypeException {
        if (string == null) {
            throw new UnknownRendererTypeException("Type cannot be null");
        }
        if (string.equalsIgnoreCase("XSD")) {
            return new SchemaRenderer();
        }
        throw new UnknownRendererTypeException("Unknown type: " + string);
    }

    public static ProfileRenderer getProfileRenderer(String string) throws UnknownRendererTypeException {
        if (string == null) {
            throw new UnknownRendererTypeException("Type cannot be null");
        }
        if (string.equalsIgnoreCase("DAML-S")) {
            return new DAML_S_Renderer();
        }
        throw new UnknownRendererTypeException("No type " + string + " available.");
    }

    public static ProcessRenderer getProcessRenderer(String string) throws UnknownRendererTypeException {
        if (string == null) {
            throw new UnknownRendererTypeException("Type cannot be null");
        }
        if (string.equalsIgnoreCase("DAML-S")) {
            return new DAML_S_Renderer();
        }
        throw new UnknownRendererTypeException("No type " + string + " available.");
    }
}

