/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import zeus.actors.AgentContext;
import zeus.concepts.Fact;
import zeus.concepts.Restriction;
import zeus.concepts.Task;
import zeus.ontology.service.InstanceRenderer;
import zeus.ontology.service.ProcessRenderer;
import zeus.ontology.service.ProfileRenderer;

public class DAML_S_Renderer
implements InstanceRenderer,
ProfileRenderer,
ProcessRenderer {
    public static final boolean SUBCLASS = true;
    private HashMap namespaces = new HashMap();
    private static final String processPrefix = "procmod";
    private static final String profilePrefix = "servprof";
    private static final String instanceRangePrefix = "range";
    private static final String ontologyPrefix = "ont";

    public DAML_S_Renderer() {
        this.namespaces.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns");
        this.namespaces.put("rdfs", "http://www.w3.org/2000/01/rdf-schema");
        this.namespaces.put("daml", "http://www.daml.org/2001/03/daml+oil");
        this.namespaces.put("process", "http://www.daml.org/services/daml-s/0.7/Process");
        this.namespaces.put("service", "http://www.daml.org/services/daml-s/0.7/Service");
        this.namespaces.put("profile", "http://www.daml.org/services/daml-s/0.7/Profile");
        this.namespaces.put("xsd", "http://www.w3.org/2000/10/XMLSchema.xsd");
    }

    private String makeHeader() {
        String string = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<!DOCTYPE uridef[\n";
        Iterator iterator = this.namespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = string + "  <!ENTITY " + string2 + " \"" + this.namespaces.get(string2) + "\" >\n";
        }
        string = string + "]>\n";
        return string;
    }

    private String startRDF() {
        String string = "<rdf:RDF\n";
        Iterator iterator = this.namespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = string2.matches("(?i)default") ? string + "  xmlns =\"&default;#\"\n" : string + "  xmlns:" + string2 + "=\"&" + string2 + ";#\"\n";
        }
        string = string + ">\n";
        return string;
    }

    private String makeOntology(String string) {
        String string2 = "<daml:ontology rdf:about=\"\" >\n";
        string2 = string2 + "  <daml:versionInfo>" + string + "</daml:versionInfo>\n";
        Iterator iterator = this.namespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            string2 = string2 + "  <daml:imports rdf:resource=\"&" + string3 + ";\" />\n";
        }
        string2 = string2 + "</daml:ontology>\n\n";
        return string2;
    }

    public String renderInstance(Task task, AgentContext agentContext) {
        String string = agentContext.whoami() + "__" + task.getName();
        String string2 = "";
        String string3 = "servprof:" + task.getName() + "Service";
        this.namespaces.put(processPrefix, "http://" + agentContext.whereAmI() + "/services/classes/" + task.getName() + "/" + task.getName() + "Process.daml");
        this.namespaces.put(profilePrefix, "http://" + agentContext.whereAmI() + "/services/classes/" + task.getName() + "/" + task.getName() + "Profile.daml");
        this.namespaces.put(instanceRangePrefix, "http://" + agentContext.whereAmI() + "/services/instances/" + agentContext.whoami() + "/" + string + "Range.xsd");
        this.namespaces.put("default", "http://" + agentContext.whereAmI() + "/services/instances/" + agentContext.whoami() + "/" + string + "Instance.daml");
        string2 = string2 + this.makeHeader() + this.startRDF() + this.makeOntology("");
        string2 = string2 + "<" + string3 + " rdf:ID=\"" + string + "\">\n";
        string2 = string2 + "  <profile:providedBy>\n";
        string2 = string2 + "    <profile:ServiceProvider rdf:ID=\"" + agentContext.whoami() + "\">\n";
        String string4 = task.getPhoneInfo();
        if (string4 != null && string4.length() > 0) {
            string2 = string2 + "      <profile:phone>" + string4 + "</profile:phone>\n";
        }
        if ((string4 = task.getFaxInfo()) != null && string4.length() > 0) {
            string2 = string2 + "      <profile:fax>" + string4 + "</profile:fax>\n";
        }
        if ((string4 = task.getEmailInfo()) != null && string4.length() > 0) {
            string2 = string2 + "      <profile:email>" + string4 + "</profile:email>\n";
        }
        if ((string4 = task.getPhysicalInfo()) != null && string4.length() > 0) {
            string2 = string2 + "      <profile:physicalAddress>" + string4 + "</profile:physicalAddress>\n";
        }
        string2 = string2 + "      <profile:webURL>" + agentContext.whereAmI() + "</profile:webURL>\n";
        string2 = string2 + "    </profile:ServiceProvider>\n";
        string2 = string2 + "  </profile:providedBy>\n";
        string4 = task.getGeoInfo();
        if (string4 != null && string4.length() > 0) {
            string2 = string2 + "  <profile:geographicRadius>" + string4 + "</profile:geographicRadius>\n";
        }
        string2 = string2 + "  <service:presents rdf:resource=\"&servprof;#" + task.getName() + "\" />\n";
        string2 = string2 + "  <service:describedBy rdf:resource=\"&procmod;#" + task.getName() + "\" />\n";
        string2 = string2 + this.generateInstanceValues(task);
        string2 = string2 + "</" + string3 + ">\n";
        string2 = string2 + "</rdf:RDF>\n";
        return string2;
    }

    private String generateInstanceValues(Task task) {
        String string = "";
        List list = task.getRestrictions();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Restriction restriction = (Restriction)iterator.next();
            string = string + this.generateRestriction(this.lookupFactId(restriction.getFactName(), task), restriction.getAttributeName(), restriction.getRestriction());
        }
        return string;
    }

    private String generateRestriction(String string, String string2, String string3) {
        String string4 = "";
        if (string3.matches(".*\\|.*")) {
            String[] stringArray = string3.split("\\|");
            string4 = string4 + "  <daml:unionOf rdf:parseType=\"daml:collection\">\n";
            int n = 0;
            while (n < stringArray.length) {
                string4 = string4 + this.generateRestriction(string, string2, stringArray[n]);
                ++n;
            }
            string4 = string4 + "  </daml:unionOf>\n";
        } else if (string3.matches(".*&.*")) {
            String[] stringArray = string3.split("&");
            int n = 0;
            while (n < stringArray.length) {
                string4 = string4 + this.generateRestriction(string, string2, stringArray[n]);
                ++n;
            }
        } else {
            if (string3.matches("((.*<.*)|(.*>.*))")) {
                return "";
            }
            string3 = string3.replaceAll("=", "").trim();
            string4 = string4 + "  <servprof:" + string + " " + processPrefix + ":" + string2 + "=\"" + string3 + "\" />\n";
        }
        return string4;
    }

    private String lookupFactId(String string, Task task) {
        Fact[] factArray = task.getPreconditions();
        int n = 0;
        while (n < factArray.length) {
            if (factArray[n].getId().equals(string)) {
                return factArray[n].getType();
            }
            ++n;
        }
        factArray = task.getPostconditions();
        int n2 = 0;
        while (n2 < factArray.length) {
            if (factArray[n2].getId().equals(string)) {
                return factArray[n2].getType();
            }
            ++n2;
        }
        return "";
    }

    private String generateFactRestrictions(Task task) {
        String string = "";
        Fact[] factArray = task.getPreconditions();
        Fact[] factArray2 = task.getPostconditions();
        int n = 0;
        while (n < factArray.length) {
            string = string + this.generateRestriction(factArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < factArray2.length) {
            string = string + this.generateRestriction(factArray2[n2]);
            ++n2;
        }
        return string;
    }

    private String generateRestriction(Fact fact) {
        String string = "";
        String[] stringArray = fact.listAttributes();
        int n = 0;
        while (n < stringArray.length) {
            string = string + "  <daml:Property rdf:about=\"&procmod;#" + fact.getType() + "." + stringArray[n] + "\" >\n";
            string = string + "    <daml:range rdf:resource=\"&range;#" + fact.getType() + "." + stringArray[n] + ".type\" />\n";
            string = string + "  </daml:Property>\n";
            ++n;
        }
        return string;
    }

    public String renderProfile(Task task, AgentContext agentContext) {
        return this.renderProfile(task, agentContext.whereAmI());
    }

    public String renderProfile(Task task, String string) {
        String string2 = task.getName();
        this.namespaces.put(processPrefix, "http://" + string + "/services/classes/" + string2 + "/" + string2 + "Process.daml");
        this.namespaces.put("default", "http://" + string + "/services/classes/" + string2 + "/" + string2 + "Profile.daml");
        String string3 = this.makeHeader() + this.startRDF() + this.makeOntology("");
        string3 = string3 + this.generateServiceClass(task) + "\n";
        string3 = string3 + "<service:serviceProfile rdf:ID=\"" + string2 + "\" >\n";
        string3 = string3 + "  <profile:textDescription>\"" + task.getTextInfo() + "\"</profile:textDescription>\n";
        string3 = string3 + "  <profile:has_process rdf:resource=\"&procmod;#" + string2 + "\" />\n";
        string3 = string3 + this.generateIOPEs(task);
        string3 = string3 + "</service:serviceProfile>\n";
        string3 = string3 + "</rdf:RDF>";
        return string3;
    }

    private String generateIOPEs(Task task) {
        String string = "";
        Fact[] factArray = task.getPreconditions();
        Fact[] factArray2 = task.getPostconditions();
        int n = 0;
        while (n < factArray.length) {
            string = factArray[n].isReadOnly() ? string + this.generateParameter(factArray[n], "precondition") : string + this.generateParameter(factArray[n], "input");
            ++n;
        }
        int n2 = 0;
        while (n2 < factArray2.length) {
            string = factArray2[n2].isReadOnly() ? string + this.generateParameter(factArray2[n2], "effect") : string + this.generateParameter(factArray2[n2], "output");
            ++n2;
        }
        return string;
    }

    private String generateParameter(Fact fact, String string) {
        String string2 = "";
        string2 = string2 + "  <profile:" + string + ">\n";
        string2 = string2 + "    <profile:ParameterDescription rdf:ID=\"" + fact.getType() + "IOPE\" >\n";
        string2 = string2 + "      <profile:parameterName>" + fact.getId().replaceAll("\\?", "") + "</profile:parameterName>\n";
        string2 = string2 + "      <profile:restrictedTo rdf:resource=\"&procmod;#" + fact.getType() + "\" />\n";
        string2 = string2 + "      <profile:refersTo rdf:resource=\"&procmod;#" + fact.getType() + "\" />\n";
        string2 = string2 + "    </profile:ParameterDescription>\n";
        string2 = string2 + "  </profile:" + string + ">\n";
        return string2;
    }

    private String generateServiceClass(Task task) {
        String string = "";
        string = string + "<daml:Class rdf:ID=\"" + task.getName() + "Service\" >\n";
        string = string + "  <daml:subclassof rdf:resource=\"&service;#Service\" />\n";
        string = string + "</daml:Class>\n";
        string = string + this.generateServiceClassProperties(task);
        return string;
    }

    private String generateServiceClassProperties(Task task) {
        String string = "";
        Fact[] factArray = task.getPreconditions();
        Fact[] factArray2 = task.getPostconditions();
        int n = 0;
        while (n < factArray.length) {
            string = string + this.generateProperty(factArray[n], task);
            ++n;
        }
        int n2 = 0;
        while (n2 < factArray2.length) {
            string = string + this.generateProperty(factArray2[n2], task);
            ++n2;
        }
        return string;
    }

    private String generateProperty(Fact fact, Task task) {
        String string = "";
        string = string + "<daml:Property rdf:ID=\"" + fact.getType() + "\" >\n";
        string = string + "  <daml:domain rdf:resource=\"#" + task.getName() + "Service\" />\n";
        string = string + "  <daml:range rdf:resource=\"#" + fact.getType() + "IOPE\" />\n";
        string = string + "</daml:Property>\n";
        return string;
    }

    public String renderProcess(Task task, AgentContext agentContext) {
        String string = task.getName() + ".daml";
        this.namespaces.put(ontologyPrefix, "http://" + agentContext.whereAmI() + "/services/ontologies/" + string);
        String string2 = this.makeHeader() + this.startRDF() + this.makeOntology("");
        string2 = string2 + "<process:ProcessModel rdf:ID=\"" + task.getName() + "_Process\">\n";
        string2 = string2 + "  <process:hasProcess rdf:resource=\"" + task.getName() + "\">\n";
        string2 = string2 + "</process:ProcessModel>\n";
        string2 = string2 + "<daml:Class rdf:ID=\"" + task.getName() + "\" >\n";
        string2 = string2 + "  <daml:subclassOf rdf:resource=\"&process;#AtomicProcess\" />\n";
        string2 = string2 + "<daml:Class>\n\n";
        string2 = string2 + this.makeIOPEs(task);
        string2 = string2 + "</rdf:RDF>\n";
        return string2;
    }

    private String makeIOPEs(Task task) {
        String string = "";
        Fact[] factArray = task.getPreconditions();
        Fact[] factArray2 = task.getPostconditions();
        int n = 0;
        while (n < factArray.length) {
            string = factArray[n].isReadOnly() ? string + this.generateIOPE(factArray[n], task, "precondition") : string + this.generateIOPE(factArray[n], task, "input");
            ++n;
        }
        int n2 = 0;
        while (n2 < factArray2.length) {
            string = factArray2[n2].isReadOnly() ? string + this.generateIOPE(factArray2[n2], task, "effect") : string + this.generateIOPE(factArray2[n2], task, "output");
            ++n2;
        }
        return string;
    }

    private String generateIOPE(Fact fact, Task task, String string) {
        String string2 = "";
        string2 = string2 + "<daml:Property rdf:ID=\"" + fact.getType() + "\" >\n";
        string2 = string2 + "  <daml:subclassOf rdf:resource=\"&process;#" + string + "\" />\n";
        string2 = string2 + "  <daml:domain rdf:resource=\"" + task.getName() + "\" />\n";
        string2 = string2 + "  <daml:range rdf:resource=\"&ont;#" + fact.getType() + "\" />\n";
        string2 = string2 + "</daml:Property>\n";
        return string2;
    }
}

