/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.restrictions;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.OntologyDb;
import zeus.concepts.OntologyDbChangeEvent;
import zeus.gui.editors.ValidatingModel;

public class RestrictionTableModel
extends AbstractTableModel
implements ChangeListener,
ValidatingModel {
    protected String[] columnNames = new String[]{"Name", "Type", "Restrictions"};
    protected String[][] data = null;
    protected boolean[][] validityInfo = null;
    protected OntologyDb model = null;
    static final int NAME = 0;
    static final int TYPE = 1;
    static final int RESTRICTION = 2;

    public RestrictionTableModel(OntologyDb ontologyDb) {
        this.model = ontologyDb;
        ontologyDb.addChangeListener(this);
        this.refresh();
    }

    void refresh() {
        this.data = this.model.getAllRestrictions();
        this.validityInfo = this.model.getAllRestrictionValidityInfo();
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data != null ? this.data.length : 0;
    }

    public String[] getRow(int n) {
        return this.data[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    public boolean isValidEntry(int n, int n2) {
        return this.validityInfo[n][n2];
    }

    public void setValueAt(Object object, int n, int n2) {
        String string;
        String string2 = object == null ? "" : ((String)object).trim();
        if (this.data[n][n2].equals(string2)) {
            return;
        }
        this.data[n][n2] = string = this.model.setRestrictionData(this.data[n][0], n2, string2);
        this.validityInfo[n] = this.model.isRestrictionValid(this.data[n][0]);
        this.fireTableCellUpdated(n, n2);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        OntologyDbChangeEvent ontologyDbChangeEvent = (OntologyDbChangeEvent)changeEvent;
        if (ontologyDbChangeEvent.getEventType() == 0) {
            this.refresh();
        }
    }

    void addNewRow() {
        this.model.addNewRestriction();
        this.refresh();
    }

    void deleteRows(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.data[nArray[n]][0];
            ++n;
        }
        this.model.deleteRestrictions(stringArray);
        this.refresh();
    }

    void addRows(String[][] stringArray) {
        this.model.addRestrictions(stringArray);
        this.refresh();
    }

    String[][] getRows(int[] nArray) {
        String[][] stringArray = new String[nArray.length][this.columnNames.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < stringArray[n].length) {
                stringArray[n][n2] = this.data[nArray[n]][n2];
                ++n2;
            }
            ++n;
        }
        return stringArray;
    }
}

