/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.facts;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import zeus.concepts.OntologyDb;
import zeus.gui.fields.NameField;
import zeus.ontology.attributes.AttributeTablePanel;
import zeus.ontology.facts.FactTreeModel;
import zeus.util.SystemProps;

public class FactTreeUI
extends JTree {
    protected AttributeTablePanel dataPanel;
    protected FactTreeModel model = (FactTreeModel)this.getModel();
    protected DefaultMutableTreeNode clipboard;
    static final String[] ERROR_MESSAGE = new String[]{"You cannot add a peer node to the root fact", "Please select a node before\ncalling this operation", "You cannot delete this fact", "Renaming fact to a name that already\nexists in fact hierarchy", "You cannot rename this fact"};

    public FactTreeUI(OntologyDb ontologyDb) {
        super(new FactTreeModel(ontologyDb));
        this.setEditable(false);
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "ontology" + string;
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(new ImageIcon(string2 + "cloud.gif"));
        this.setCellRenderer(defaultTreeCellRenderer);
        this.putClientProperty("JTree.lineStyle", "Angled");
    }

    public FactTreeUI(OntologyDb ontologyDb, AttributeTablePanel attributeTablePanel) {
        this(ontologyDb);
        this.dataPanel = attributeTablePanel;
        this.setEditable(true);
        SymSelectAction symSelectAction = new SymSelectAction();
        FactCellEditor factCellEditor = new FactCellEditor();
        factCellEditor.addCellEditorListener(symSelectAction);
        this.setCellEditor(new DefaultTreeCellEditor(this, (DefaultTreeCellRenderer)this.getCellRenderer(), factCellEditor));
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(symSelectAction);
        treeSelectionModel.setSelectionMode(1);
    }

    public void refresh() {
        this.model.refresh();
    }

    void addPeerNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            this.errorMsg(1);
            return;
        }
        if (defaultMutableTreeNode.isRoot()) {
            this.errorMsg(0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode != null ? (DefaultMutableTreeNode)defaultMutableTreeNode.getParent() : (DefaultMutableTreeNode)this.model.getRoot();
        this.model.addNewChild(defaultMutableTreeNode2);
    }

    void addSubNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            this.errorMsg(1);
            return;
        }
        this.model.addNewChild(defaultMutableTreeNode);
        this.expandPath(this.getSelectionPath());
    }

    void removeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            this.errorMsg(1);
            return;
        }
        if (!this.model.isEditable(defaultMutableTreeNode.getUserObject().toString())) {
            this.errorMsg(2);
            return;
        }
        this.model.removeNode(defaultMutableTreeNode);
        this.dataPanel.clear();
    }

    void cutNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            this.errorMsg(1);
            return;
        }
        if (!this.model.isEditable(defaultMutableTreeNode.getUserObject().toString())) {
            this.errorMsg(2);
            return;
        }
        this.clipboard = this.model.cutNode(defaultMutableTreeNode);
        this.dataPanel.clear();
    }

    void copyNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            this.errorMsg(1);
            return;
        }
        this.clipboard = this.model.copyNode(defaultMutableTreeNode);
    }

    void pasteNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            this.errorMsg(1);
            return;
        }
        this.model.pasteNode(defaultMutableTreeNode, this.clipboard);
        this.expandPath(this.getSelectionPath());
    }

    void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    void expandRow() {
        this.expandRow(this.getLeadSelectionRow());
    }

    void collapseRow() {
        this.collapseRow(this.getLeadSelectionRow());
    }

    DefaultMutableTreeNode getSelectedNode() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            return (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    public String getSelectedNodeName() {
        String string = null;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode != null) {
            string = defaultMutableTreeNode.getUserObject().toString();
        }
        return string;
    }

    public String[] getSelectedNodeNames() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[treePathArray.length];
        int n = 0;
        while (n < stringArray.length) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
            stringArray[n] = defaultMutableTreeNode.getUserObject().toString();
            ++n;
        }
        return stringArray;
    }

    class SymSelectAction
    implements TreeSelectionListener,
    CellEditorListener {
        SymSelectAction() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            FactTreeUI.this.dataPanel.displayAttributes(FactTreeUI.this.getSelectedNodeName());
        }

        public void editingStopped(ChangeEvent changeEvent) {
            FactTreeUI.this.dataPanel.displayAttributes(FactTreeUI.this.getSelectedNodeName());
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }
    }

    class FactCellEditor
    extends DefaultCellEditor {
        public FactCellEditor() {
            super(new NameField());
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                TreePath treePath = FactTreeUI.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (FactTreeUI.this.model.isEditable(defaultMutableTreeNode.getUserObject().toString())) {
                    return super.isCellEditable(eventObject);
                }
                FactTreeUI.this.errorMsg(4);
                return false;
            }
            return super.isCellEditable(eventObject);
        }
    }
}

