/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.facts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import zeus.concepts.OntologyDb;
import zeus.gui.help.HelpWindow;
import zeus.ontology.OntologyEditor;
import zeus.ontology.attributes.AttributeTablePanel;
import zeus.ontology.facts.FactTreeUI;
import zeus.util.SystemProps;

public class FactTreePane
extends JSplitPane {
    protected FactTreeUI treeView;
    protected AttributeTablePanel tablePanel;

    public FactTreePane(OntologyEditor ontologyEditor, OntologyDb ontologyDb) {
        super(0, true);
        this.tablePanel = new AttributeTablePanel(ontologyEditor, ontologyDb);
        this.treeView = new FactTreeUI(ontologyDb, this.tablePanel);
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(), "The Fact Hierarchy");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel.setBorder(titledBorder);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        FactTreeToolBar factTreeToolBar = new FactTreeToolBar();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        gridBagLayout.setConstraints(factTreeToolBar, gridBagConstraints);
        jPanel.add(factTreeToolBar);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.treeView);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 16, 16, 16);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        jPanel.setPreferredSize(new Dimension(540, 250));
        jPanel.setMinimumSize(new Dimension(0, 0));
        this.tablePanel.setPreferredSize(new Dimension(540, 350));
        this.tablePanel.setMinimumSize(new Dimension(0, 0));
        this.setTopComponent(jPanel);
        this.setBottomComponent(this.tablePanel);
        this.setDividerSize(7);
    }

    class FactTreeToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin;
        protected JButton newSBtn;
        protected JButton newPBtn;
        protected JButton deleteBtn;
        protected JButton cutBtn;
        protected JButton copyBtn;
        protected JButton pasteBtn;
        protected JToggleButton helpBtn;
        protected JToggleButton showBtn;

        public FactTreeToolBar() {
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "ontology" + string;
            this.newSBtn = new JButton(new ImageIcon(string2 + "newsub.gif"));
            this.newSBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newSBtn);
            this.newSBtn.setToolTipText("Add new child fact");
            this.newSBtn.addActionListener(this);
            this.newPBtn = new JButton(new ImageIcon(string2 + "newpeer.gif"));
            this.newPBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newPBtn);
            this.newPBtn.setToolTipText("Add new peer fact");
            this.newPBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.cutBtn = new JButton(new ImageIcon(string2 + "cut.gif"));
            this.cutBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.cutBtn);
            this.cutBtn.setToolTipText("Cut");
            this.cutBtn.addActionListener(this);
            this.copyBtn = new JButton(new ImageIcon(string2 + "copy.gif"));
            this.copyBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.copyBtn);
            this.copyBtn.setToolTipText("Copy");
            this.copyBtn.addActionListener(this);
            this.pasteBtn = new JButton(new ImageIcon(string2 + "paste.gif"));
            this.pasteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.pasteBtn);
            this.pasteBtn.setToolTipText("Paste");
            this.pasteBtn.addActionListener(this);
            this.addSeparator();
            this.showBtn = new JToggleButton(new ImageIcon(string2 + "expand.gif"), false);
            this.showBtn.setSelectedIcon(new ImageIcon(string2 + "collapse.gif"));
            this.showBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.showBtn);
            this.showBtn.setToolTipText("Expand/Collapse hierarchy");
            this.showBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newPBtn) {
                FactTreePane.this.treeView.addPeerNode();
            } else if (object == this.newSBtn) {
                FactTreePane.this.treeView.addSubNode();
            } else if (object == this.deleteBtn) {
                FactTreePane.this.treeView.removeNode();
            } else if (object == this.showBtn) {
                if (this.showBtn.isSelected()) {
                    FactTreePane.this.treeView.expandRow();
                } else {
                    FactTreePane.this.treeView.collapseRow();
                }
            } else if (object == this.cutBtn) {
                FactTreePane.this.treeView.cutNode();
            } else if (object == this.copyBtn) {
                FactTreePane.this.treeView.copyNode();
            } else if (object == this.pasteBtn) {
                FactTreePane.this.treeView.pasteNode();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this.helpBtn), point, "ontology", "Fact Hierarchy");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }
}

