/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.database;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.ontology.database.ColumnsTableModel;
import zeus.ontology.database.TablesTableModel;

public class TablesTableUI
extends JPanel {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected JTable table;
    protected TablesTableModel model;
    protected ColumnsTableModel cmodel;
    protected int selRow = -1;

    public TablesTableUI(ColumnsTableModel columnsTableModel) {
        this.cmodel = columnsTableModel;
        this.model = new TablesTableModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0);
        tableColumn.setHeaderValue(this.model.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.model, defaultTableColumnModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(140, 180));
        this.table.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 16, 16, 16);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SymListAction());
    }

    public TablesTableModel getModel() {
        return this.model;
    }

    private void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    public String getSelectedRow() {
        if (this.selRow == -1) {
            return null;
        }
        return (String)this.model.getValueAt(this.selRow, 0);
    }

    class SymListAction
    implements ListSelectionListener {
        SymListAction() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = TablesTableUI.this.table.getSelectedRow();
            if (n != TablesTableUI.this.selRow) {
                TablesTableUI.this.selRow = n;
                String string = (String)TablesTableUI.this.model.getValueAt(n, 0);
                TablesTableUI.this.cmodel.refreshColumns(string);
            }
        }
    }
}

