/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.database;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import zeus.concepts.OntologyDb;
import zeus.ext.DbConnector;
import zeus.generator.GeneratorModel;
import zeus.ontology.database.ColumnsTableModel;
import zeus.ontology.database.ColumnsTableUI;
import zeus.ontology.database.TablesTableModel;
import zeus.ontology.database.TablesTableUI;
import zeus.util.TreeNode;

public class DatabasePane
extends JPanel
implements ActionListener {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    public DbConnector MYDB = null;
    public OntologyDb ONTDB = null;
    public GeneratorModel genModel = null;
    protected TablesTableModel tablesModel;
    protected ColumnsTableModel columnsModel;
    protected ColumnsTableUI columnsUI;
    protected TablesTableUI tablesUI;
    protected Vector tablesList = new Vector();
    protected JTextField dbNameField;
    protected JTextField dbDriverField;
    protected JTextField dbUsernameField;
    protected JTextField dbPasswordField;
    protected JButton connBtn;
    public JButton importBtn;
    public JTextArea messageArea;

    public DatabasePane(OntologyDb ontologyDb, GeneratorModel generatorModel) {
        this.setLayout(new BorderLayout());
        this.ONTDB = ontologyDb;
        this.genModel = generatorModel;
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Database Parameters");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.blue);
        jPanel.setBorder(titledBorder);
        this.add("North", jPanel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        this.dbNameField = new JTextField(20);
        JLabel jLabel = new JLabel("Database");
        jLabel.setFont(new Font("Helvetica", 0, 12));
        jLabel.setToolTipText("Enter the path to your database, consult your JDBC driver documentation for syntax");
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagLayout.setConstraints(this.dbNameField, gridBagConstraints);
        jPanel.add(this.dbNameField);
        this.dbDriverField = new JTextField(20);
        JLabel jLabel2 = new JLabel("JDBC Driver");
        jLabel2.setFont(new Font("Helvetica", 0, 12));
        jLabel2.setToolTipText("Enter the full classname of the JDBC driver used to access your database");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.dbDriverField, gridBagConstraints);
        jPanel.add(this.dbDriverField);
        this.dbUsernameField = new JTextField(20);
        JLabel jLabel3 = new JLabel("Username");
        jLabel3.setFont(new Font("Helvetica", 0, 12));
        jLabel3.setToolTipText("Provide this if you need to be authenticated when connecting to your database");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.dbUsernameField, gridBagConstraints);
        jPanel.add(this.dbUsernameField);
        this.dbPasswordField = new JTextField(20);
        JLabel jLabel4 = new JLabel("Password");
        jLabel4.setFont(new Font("Helvetica", 0, 12));
        jLabel4.setToolTipText("Provide this if you need to be authenticated when connecting to your database");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.dbPasswordField, gridBagConstraints);
        jPanel.add(this.dbPasswordField);
        this.connBtn = new JButton("Connect");
        this.connBtn.addActionListener(this);
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.connBtn, gridBagConstraints);
        jPanel.add(this.connBtn);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.columnsUI = new ColumnsTableUI(this);
        this.columnsModel = this.columnsUI.getModel();
        this.tablesUI = new TablesTableUI(this.columnsModel);
        this.tablesModel = this.tablesUI.getModel();
        jPanel2.add("West", this.tablesUI);
        jPanel2.add("East", this.columnsUI);
        this.importBtn = new JButton("Import Selected");
        this.importBtn.addActionListener(this);
        if (this.tablesList.size() == 0) {
            this.importBtn.setEnabled(false);
        }
        jPanel2.add(new JLabel());
        jPanel2.add("South", this.importBtn);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Database Schema");
        titledBorder2.setTitlePosition(2);
        titledBorder2.setTitleJustification(3);
        titledBorder2.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder2.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder2);
        this.add("Center", jPanel2);
        JPanel jPanel3 = new JPanel();
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder("Messages");
        titledBorder3.setTitlePosition(2);
        titledBorder3.setTitleJustification(3);
        titledBorder3.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder3.setTitleColor(Color.blue);
        jPanel3.setBorder(titledBorder3);
        jPanel3.setLayout(new GridLayout(1, 1));
        this.messageArea = new JTextArea(8, 200);
        this.messageArea.setEditable(false);
        this.messageArea.setLineWrap(true);
        this.messageArea.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.messageArea);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(300, 160));
        jPanel3.add(jScrollPane);
        this.add("South", jPanel3);
        this.initParams();
    }

    private void initParams() {
        this.dbNameField.setText("jdbc:mysql://steerpike:3306/test");
        this.dbDriverField.setText("org.gjt.mm.mysql.Driver");
    }

    private void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.connBtn) {
            this.makeDbConnection();
        } else if (object == this.importBtn) {
            this.importTable();
        }
    }

    private void makeDbConnection() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string = this.dbNameField.getText();
        string2 = this.dbDriverField.getText();
        string3 = this.dbUsernameField.getText();
        string4 = this.dbPasswordField.getText();
        if (this.genModel != null) {
            this.genModel.dbName = string;
            this.genModel.dbDriver = string2;
            this.genModel.dbUsername = string3;
            this.genModel.dbPassword = string4;
        }
        this.MYDB = new DbConnector(string3, string4, string2, string);
        this.messageArea.append("** Reading table information from " + string);
        try {
            DatabaseMetaData databaseMetaData = this.MYDB.getConnection().getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, stringArray);
            while (resultSet.next()) {
                String string5 = resultSet.getString(3);
                this.tablesList.add(string5);
            }
            this.tablesModel.setValues(this.tablesList);
            this.MYDB.close();
            this.messageArea.append(" OK \n");
        }
        catch (SQLException sQLException) {
            this.messageArea.append("\nSQL Exception: " + sQLException + "\n");
        }
    }

    private void importTable() {
        if (this.columnsUI.getTable().getSelectedRow() == -1) {
            this.messageArea.append("Error - no selected columns to import\n");
            return;
        }
        String[][] stringArray = this.columnsUI.getSelectedRows();
        String string = this.tablesUI.getSelectedRow();
        TreeNode treeNode = this.ONTDB.getRoot();
        boolean bl = this.ONTDB.addNamedChildFact(treeNode, string);
        if (bl) {
            this.messageArea.append("Created new entity: " + string + "\n");
        } else {
            this.messageArea.append("Entity: " + string + " already exists\n");
        }
        this.messageArea.append("Importing: " + stringArray.length + " attribute(s) \n");
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n][0];
            String string3 = stringArray[n][1];
            String string4 = stringArray[n][2];
            this.ONTDB.addNewAttribute(string, string2, string4);
            ++n;
        }
        this.messageArea.append("Import successful. \n");
        this.messageArea.append("The imported fact and its attributes are now in the fact tree \n\n");
    }
}

