/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology.attributes;

import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.OntologyDb;
import zeus.gui.editors.ValidatingModel;
import zeus.util.Misc;

public class AttributeTableModel
extends AbstractTableModel
implements ChangeListener,
ValidatingModel {
    static final int NAME = 0;
    static final int TYPE = 1;
    static final int RESTRICTION = 2;
    static final int DEFAULT = 3;
    protected static final String[] columnNames = new String[]{"Name", "Type", "Restriction", "Default Value"};
    protected String[][] data = null;
    protected boolean[][] validityInfo = null;
    protected String currentName = null;
    protected boolean showAll = false;
    protected OntologyDb model;

    public AttributeTableModel(OntologyDb ontologyDb) {
        this.model = ontologyDb;
    }

    void refreshAttributes(String string) {
        this.currentName = string;
        this.showAll = false;
        this.data = this.model.getAttributeEntriesFor(string);
        this.validityInfo = this.model.getValidityInfoFor(string);
        this.fireTableStructureChanged();
    }

    void refreshAllAttributes(String string) {
        this.currentName = string;
        this.showAll = true;
        this.data = this.model.getAllAttributeEntriesFor(string);
        this.validityInfo = this.model.getAllValidityInfoFor(string);
        this.fireTableStructureChanged();
    }

    void addNewRow() {
        this.model.addNewAttributeRow(this.currentName);
        this.refresh();
    }

    void deleteRows(int[] nArray) {
        Vector<String> vector = new Vector<String>(100);
        int n = this.model.getEditableLimit();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < n) {
                JOptionPane.showMessageDialog(null, "Attribute " + this.data[nArray[n2]][0] + " cannot be deleted", "Error", 0);
            } else {
                vector.addElement(this.data[nArray[n2]][0]);
            }
            ++n2;
        }
        this.model.deleteAttributes(this.currentName, Misc.stringArray(vector));
        this.refresh();
    }

    void addRows(String[][] stringArray) {
        this.model.addAttributeRows(this.currentName, stringArray);
        this.refresh();
    }

    String[][] getRows(int[] nArray) {
        String[][] stringArray = new String[nArray.length][columnNames.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < stringArray[n].length) {
                stringArray[n][n2] = this.data[nArray[n]][n2];
                ++n2;
            }
            ++n;
        }
        return stringArray;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return this.data != null ? this.data.length : 0;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    public String[] getRow(int n) {
        return this.data[n];
    }

    public boolean isValidEntry(int n, int n2) {
        return this.validityInfo[n][n2];
    }

    public boolean isCellEditable(int n, int n2) {
        return this.isNodeEditable() && n >= this.model.getEditableLimit();
    }

    public boolean isNodeEditable() {
        return this.currentName != null && this.model.isFactEditable(this.currentName);
    }

    public void setValueAt(Object object, int n, int n2) {
        String string = object == null ? "" : object.toString().trim();
        if (this.data[n][n2].equals(string)) {
            return;
        }
        this.data[n][n2] = this.model.setAttribute(this.currentName, this.data[n][0], n2, string);
        this.validityInfo[n] = this.model.isAttributeValid(this.currentName, this.data[n][0]);
        this.fireTableCellUpdated(n, n2);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refresh();
    }

    protected void refresh() {
        if (this.currentName == null) {
            return;
        }
        if (!this.model.hasFact(this.currentName)) {
            this.currentName = null;
            this.data = new String[0][4];
            this.fireTableStructureChanged();
            return;
        }
        if (this.showAll) {
            this.refreshAllAttributes(this.currentName);
        } else {
            this.refreshAttributes(this.currentName);
        }
    }
}

