/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology;

import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import zeus.concepts.OntologyDb;
import zeus.util.TreeNode;

public class TypeTreeModel
extends DefaultTreeModel {
    public static final int FACT = 0;
    public static final int RESTRICTION = 1;
    protected static final String DEFAULT_ROOT = "#DefaultRoot#";
    protected static final String BASIC_TYPES = "Basic Types";
    protected static final String RESTRICTIONS = "Restrictions";
    protected static final String FACTS = "Facts";
    protected static final String SETS = "Set of ...";
    protected OntologyDb model;
    protected int mode;

    public TypeTreeModel(OntologyDb ontologyDb, int n) {
        super(new DefaultMutableTreeNode(DEFAULT_ROOT));
        this.model = ontologyDb;
        this.mode = n;
        this.refresh();
    }

    void refresh() {
        this.root = new DefaultMutableTreeNode(DEFAULT_ROOT);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(BASIC_TYPES);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(RESTRICTIONS);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(FACTS);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        int n = 0;
        while (n < OntologyDb.BASIC_TYPES.length) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(OntologyDb.BASIC_TYPES[n]));
            ++n;
        }
        String[] stringArray = this.model.getAllRestrictionNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(stringArray[n2]));
            ++n2;
        }
        if (this.mode == 0) {
            defaultMutableTreeNode.add(defaultMutableTreeNode4);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("JavaObject"));
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(this.model.getRoot());
            defaultMutableTreeNode4.add(defaultMutableTreeNode5);
            this.createTree(defaultMutableTreeNode5, this.model.getRoot());
        }
        this.reload();
    }

    protected void createTree(DefaultMutableTreeNode defaultMutableTreeNode, TreeNode treeNode) {
        Vector vector = treeNode.getChildren();
        int n = 0;
        while (n < vector.size()) {
            TreeNode treeNode2 = (TreeNode)vector.elementAt(n);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.createTree(defaultMutableTreeNode2, treeNode2);
            ++n;
        }
    }
}

