/*
 * Decompiled with CFR 0.152.
 */
package zeus.ontology;

import com.hp.hpl.jena.daml.DAMLClass;
import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.DAMLProperty;
import com.hp.hpl.jena.daml.common.DAMLModelImpl;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import zeus.concepts.FactDescription;
import zeus.concepts.OntologyDb;
import zeus.ontology.TypesHandler;
import zeus.util.SystemProps;
import zeus.util.TreeNode;

public class DAMLReader {
    protected OntologyDb db;
    protected Hashtable factIndex;

    public DAMLReader(OntologyDb ontologyDb) {
        this.db = ontologyDb;
        this.factIndex = ontologyDb.getFactIndex();
    }

    public void read(File file) {
        String string = SystemProps.getProperty("daml.namespace") + file.getName() + "#";
        try {
            Object object;
            DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
            FileReader fileReader = new FileReader(file);
            dAMLModelImpl.read((Reader)fileReader, string);
            Vector vector = new Vector();
            Iterator iterator = dAMLModelImpl.listDAMLClasses();
            while (iterator.hasNext()) {
                object = (DAMLClass)iterator.next();
                this.translateClass((DAMLClass)object, vector);
            }
            while (vector.size() > 0) {
                object = (DAMLClass)vector.remove(0);
                this.translateClass((DAMLClass)object, vector);
            }
            object = dAMLModelImpl.listDAMLProperties();
            while (object.hasNext()) {
                DAMLProperty dAMLProperty = (DAMLProperty)object.next();
                this.translateProperty(dAMLProperty);
            }
            this.loadRestrictions(file);
        }
        catch (RDFException rDFException) {
            this.debug(rDFException.toString());
        }
        catch (IOException iOException) {
            this.debug(iOException.toString());
        }
    }

    private void translateClass(DAMLClass dAMLClass, List list) throws RDFException {
        String string = dAMLClass.getLocalName();
        if (this.factIndex.get(string) != null) {
            return;
        }
        DAMLCommon dAMLCommon = dAMLClass.prop_subClassOf().getDAMLValue();
        if (dAMLCommon == null) {
            return;
        }
        String string2 = dAMLCommon.getLocalName();
        if (this.factIndex.get(string2) == null) {
            list.add(dAMLClass);
            return;
        }
        TreeNode treeNode = new TreeNode(new FactDescription(string));
        this.factIndex.put(string, treeNode);
        TreeNode treeNode2 = (TreeNode)this.factIndex.get(string2);
        treeNode2.addChild(treeNode);
    }

    private void translateProperty(DAMLProperty dAMLProperty) throws RDFException {
        Object object;
        Resource resource;
        String string = "";
        String string2 = dAMLProperty.getLocalName();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        DAMLCommon dAMLCommon = dAMLProperty.prop_domain().getDAMLValue();
        if (dAMLCommon != null) {
            string = dAMLCommon.getLocalName();
        }
        if ((resource = (Resource)dAMLProperty.prop_range().get()) != null) {
            string3 = this.translateRange(resource.getLocalName());
        }
        NodeIterator nodeIterator = dAMLProperty.prop_comment().getValues();
        while (nodeIterator.hasNext()) {
            object = nodeIterator.next().toString();
            if (((String)object).matches("Restriction: \\\".*\\\"")) {
                string4 = ((String)object).substring(((String)object).indexOf("\"") + 1, ((String)object).lastIndexOf("\""));
                continue;
            }
            if (!((String)object).matches("Default: \\\".*\\\"")) continue;
            string5 = ((String)object).substring(((String)object).indexOf("\"") + 1, ((String)object).lastIndexOf("\""));
        }
        object = (TreeNode)this.factIndex.get(string);
        if (object == null) {
            this.debug("Invalid property: " + string);
            return;
        }
        if (string2.matches(string + "\\..*")) {
            string2 = string2.substring(string.length() + 1);
        }
        FactDescription factDescription = (FactDescription)((TreeNode)object).getValue();
        factDescription.setAttributeEntry(new String[]{string2, string3, string4, string5});
    }

    private String translateRange(String string) {
        if (string.toLowerCase().equals("string")) {
            return "String";
        }
        if (string.toLowerCase().equals("integer")) {
            return "Integer";
        }
        if (string.toLowerCase().equals("real")) {
            return "Real";
        }
        if (string.toLowerCase().equals("boolean")) {
            return "Boolean";
        }
        if (string.toLowerCase().equals("date")) {
            return "Date";
        }
        if (string.toLowerCase().equals("time")) {
            return "Time";
        }
        if (string.toLowerCase().equals("list")) {
            return "List";
        }
        return string;
    }

    private void debug(String string) {
    }

    private void loadRestrictions(File file) {
        File file2;
        String string;
        String string2 = this.readFile(file);
        if (string2.matches("(?smi).*comment>types: .*")) {
            try {
                string = string2.toLowerCase();
                int n = string.indexOf(":ontology");
                n = string.indexOf(":comment", n);
                n = string.indexOf("types: ", n) + "types: ".length();
                int n2 = string.indexOf("<", n);
                String string3 = string2.substring(n, n2);
                File file3 = new File(string3);
                if (file3.exists()) {
                    this.readRestrictions(file3);
                    return;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        if ((file2 = new File(string = file.getAbsolutePath().replaceAll("\\.[^\\.]*$", ".xsd"))).exists()) {
            this.readRestrictions(file2);
        }
    }

    private void readRestrictions(File file) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        TypesHandler typesHandler = new TypesHandler();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(file, (DefaultHandler)typesHandler);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        typesHandler.addRestrictions(this.db);
    }

    private String readFile(File file) {
        if (file == null || !file.exists()) {
            return "";
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(byArray, 0, byArray.length);
            fileInputStream.close();
            return new String(byArray);
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

