/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import zeus.gui.help.HtmlPanel;
import zeus.util.SystemProps;

public class HelpWindow
extends JFrame {
    protected HtmlPanel textPane;
    protected JScrollPane displayArea;
    protected HelpToolBar helpBar;
    protected AbstractButton sourceBtn;
    protected Vector history = new Vector();
    protected int histpos = 0;

    public HelpWindow(Component component, Point point, String string, String string2) {
        this.addWindowListener(new HWHandler());
        this.setTitle("Help on " + string2);
        String string3 = System.getProperty("file.separator");
        String string4 = SystemProps.getProperty("gif.dir") + "help" + string3;
        ImageIcon imageIcon = new ImageIcon(string4 + "questionicon.gif");
        this.setIconImage(imageIcon.getImage());
        Point point2 = component.getLocation();
        int n = component.getSize().width;
        Point point3 = new Point(point2.x + n, point2.y + point.y);
        this.setLocation(point3.x, point3.y);
        this.setSize(new Dimension(400, 300));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.yellow.brighter());
        BevelBorder bevelBorder = new BevelBorder(0);
        jPanel.setBorder(bevelBorder);
        String string5 = string2 + string3 + "what.html";
        String string6 = SystemProps.getProperty("zeus.dir") + "help" + string3 + string + string3;
        String string7 = "file:" + string6 + string5;
        this.textPane = new HtmlPanel(this);
        this.history.addElement(string7);
        this.textPane.setPage(string7);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.helpBar = new HelpToolBar();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagLayout.setConstraints(this.helpBar, gridBagConstraints);
        jPanel.add(this.helpBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 16, 16, 16);
        gridBagLayout.setConstraints(this.textPane, gridBagConstraints);
        jPanel.add(this.textPane);
        this.getContentPane().add("Center", jPanel);
        this.pack();
        this.show();
    }

    public void setSource(AbstractButton abstractButton) {
        this.sourceBtn = abstractButton;
    }

    public void addToHistory(String string) {
        this.history.addElement(string);
        ++this.histpos;
    }

    class HelpToolBar
    extends JPanel
    implements ActionListener {
        protected JButton prevBtn;
        protected JButton nextBtn;

        public HelpToolBar() {
            this.setBorder(new BevelBorder(1));
            this.setLayout(new BoxLayout(this, 0));
            this.setBackground(Color.yellow);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "help" + string;
            this.prevBtn = new JButton(new ImageIcon(string2 + "previous.gif"));
            this.add(this.prevBtn);
            this.prevBtn.setToolTipText("Previous Entry");
            this.prevBtn.setMargin(new Insets(0, 0, 0, 0));
            this.prevBtn.addActionListener(this);
            this.nextBtn = new JButton(new ImageIcon(string2 + "next.gif"));
            this.add(this.nextBtn);
            this.nextBtn.setToolTipText("Next Entry");
            this.nextBtn.setMargin(new Insets(0, 0, 0, 0));
            this.nextBtn.addActionListener(this);
            this.add(Box.createHorizontalGlue());
            JButton jButton = new JButton(new ImageIcon(string2 + "questionmark.gif"));
            jButton.setMargin(new Insets(0, 0, 0, 0));
            this.add(jButton);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.nextBtn && HelpWindow.this.histpos + 1 < HelpWindow.this.history.size()) {
                ++HelpWindow.this.histpos;
                HelpWindow.this.textPane.setPage((String)HelpWindow.this.history.elementAt(HelpWindow.this.histpos));
            } else if (object == this.prevBtn && HelpWindow.this.histpos > 0) {
                --HelpWindow.this.histpos;
                HelpWindow.this.textPane.setPage((String)HelpWindow.this.history.elementAt(HelpWindow.this.histpos));
            }
            HelpWindow.this.textPane.repaint();
        }
    }

    class HWHandler
    extends WindowAdapter {
        HWHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (HelpWindow.this.sourceBtn != null) {
                HelpWindow.this.sourceBtn.setSelected(false);
            }
            HelpWindow.this.dispose();
        }
    }
}

