/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SelectPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected Point anchor = new Point(0, 0);
    protected Point stretched = new Point(0, 0);
    protected Point last = new Point(0, 0);
    protected Point end = new Point(0, 0);
    protected boolean firstStretch = true;
    protected boolean regionSelected = false;
    protected Rectangle region = new Rectangle(0, 0, 0, 0);
    protected Vector items = new Vector();
    boolean source_ok = false;

    public SelectPanel() {
        super(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public SelectPanel(Dimension dimension) {
        this();
        this.setMaximumSize(dimension);
    }

    public SelectPanel(int n, int n2) {
        this();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = this.source_ok = mouseEvent.getSource() == this;
        if (!this.source_ok) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.anchor(mouseEvent.getPoint());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.source_ok) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.stretch(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.source_ok) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.end(mouseEvent.getPoint());
        }
        this.source_ok = false;
    }

    public void drawRegion(Graphics graphics) {
        graphics.drawRect(this.region.x, this.region.y, this.region.width, this.region.height);
    }

    public void clearRegion(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.drawRect(this.region.x, this.region.y, this.region.width, this.region.height);
        graphics.setColor(color);
    }

    public void drawLast(Graphics graphics) {
        Rectangle rectangle = this.lastBounds();
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawNext(Graphics graphics) {
        Rectangle rectangle = this.currentBounds();
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public Point getStretched() {
        return this.stretched;
    }

    public Point getLast() {
        return this.last;
    }

    public Point getEnd() {
        return this.end;
    }

    public void anchor(Point point) {
        this.firstStretch = true;
        this.last.x = this.anchor.x = point.x;
        this.stretched.x = this.anchor.x;
        this.last.y = this.anchor.y = point.y;
        this.stretched.y = this.anchor.y;
        if (this.regionSelected && !this.region.contains(this.anchor.x, this.anchor.y)) {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.clearRegion(graphics);
            }
            this.regionSelected = false;
        }
    }

    public void stretch(Point point) {
        this.last.x = this.stretched.x;
        this.last.y = this.stretched.y;
        this.stretched.x = point.x;
        this.stretched.y = point.y;
        Graphics graphics = this.getGraphics();
        if (graphics != null && !this.regionSelected) {
            graphics.setXORMode(this.getBackground());
            if (this.firstStretch) {
                this.firstStretch = false;
            } else {
                this.drawLast(graphics);
            }
            this.drawNext(graphics);
        }
    }

    public void end(Point point) {
        this.last.x = this.end.x = point.x;
        this.last.y = this.end.y = point.y;
        Graphics graphics = this.getGraphics();
        if (graphics != null && !this.regionSelected) {
            graphics.setXORMode(this.getBackground());
            this.drawLast(graphics);
            this.region.setBounds(this.stretched.x < this.anchor.x ? this.stretched.x : this.anchor.x, this.stretched.y < this.anchor.y ? this.stretched.y : this.anchor.y, Math.abs(this.stretched.x - this.anchor.x), Math.abs(this.stretched.y - this.anchor.y));
            if (this.findItems()) {
                this.regionSelected = true;
                this.drawRegion(graphics);
            }
        }
    }

    public Rectangle currentBounds() {
        return new Rectangle(this.stretched.x < this.anchor.x ? this.stretched.x : this.anchor.x, this.stretched.y < this.anchor.y ? this.stretched.y : this.anchor.y, Math.abs(this.stretched.x - this.anchor.x), Math.abs(this.stretched.y - this.anchor.y));
    }

    public Rectangle lastBounds() {
        return new Rectangle(this.last.x < this.anchor.x ? this.last.x : this.anchor.x, this.last.y < this.anchor.y ? this.last.y : this.anchor.y, Math.abs(this.last.x - this.anchor.x), Math.abs(this.last.y - this.anchor.y));
    }

    public Vector boundedItems() {
        if (this.regionSelected) {
            return this.items;
        }
        return new Vector();
    }

    protected boolean findItems() {
        Component[] componentArray = this.getComponents();
        this.items.removeAllElements();
        int n = 0;
        while (n < componentArray.length) {
            Rectangle rectangle = componentArray[n].getBounds();
            if (this.region.contains(rectangle.x, rectangle.y) && this.region.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) {
                this.items.addElement(componentArray[n]);
            }
            ++n;
        }
        return !this.items.isEmpty();
    }
}

