/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import zeus.gui.graph.BulletinLayout;
import zeus.gui.graph.DefaultGraphNodeEditor;
import zeus.gui.graph.GraphIcon;
import zeus.gui.graph.GraphIconEvent;
import zeus.gui.graph.GraphIconListener;
import zeus.gui.graph.GraphModel;
import zeus.gui.graph.GraphModelEvent;
import zeus.gui.graph.GraphModelListener;
import zeus.gui.graph.GraphNode;
import zeus.gui.graph.GraphNodeEditor;
import zeus.gui.graph.GraphNodeEditorEvent;
import zeus.gui.graph.GraphNodeEditorListener;
import zeus.gui.graph.GraphNodeRenderer;
import zeus.gui.graph.MovePanel;
import zeus.util.ArrowData;
import zeus.util.Core;
import zeus.util.Misc;

public class Graph
extends MovePanel
implements GraphIconListener,
GraphModelListener,
GraphNodeEditorListener {
    public static final int VERTICAL_PARENT_CHILD = 0;
    public static final int VERTICAL_CHILD_PARENT = 1;
    public static final int HORIZONTAL_PARENT_CHILD = 2;
    public static final int HORIZONTAL_CHILD_PARENT = 3;
    public static final int CENTRED = 4;
    public static final int CIRCLES = 5;
    protected static final int ORG_DX = 20;
    protected static final int ORG_DY = 20;
    protected static final double HEIGHT_FACTOR = 2.0;
    protected static final int BETA = 30;
    protected static final int GAMMA = 20;
    protected static final int BOTTOM_EDGE = 1;
    protected static final int TOP_EDGE = 2;
    protected static final int LEFT_EDGE = 3;
    protected static final int RIGHT_EDGE = 4;
    protected Hashtable ViewList = new Hashtable();
    protected GraphModel model;
    protected GraphNodeRenderer nodeRenderer = null;
    protected GraphNodeEditor nodeEditor = null;
    protected Component nodeEditorComponent = null;
    protected JLayeredPane pane = null;
    protected boolean isNodeEditable;
    protected boolean isLinkEditable;
    protected int viewMode;
    private Point startPoint = null;
    private Point lastPoint = null;
    private Point stretchedPoint = null;
    private GraphIcon sourceIcon = null;
    private GraphIcon destIcon = null;
    static /* synthetic */ Class class$javax$swing$JViewport;

    public Graph(int n, GraphModel graphModel, boolean bl, boolean bl2) {
        super(2000, 2000);
        this.setLayout(new BulletinLayout());
        this.model = graphModel;
        this.isNodeEditable = bl;
        this.isLinkEditable = bl2;
        this.viewMode = n;
        graphModel.addGraphModelListener(this);
    }

    public Graph(GraphModel graphModel, boolean bl, boolean bl2) {
        this(3, graphModel, bl, bl2);
    }

    public Graph(GraphModel graphModel) {
        this(3, graphModel, true, true);
    }

    public void setModel(GraphModel graphModel) {
        this.model.removeGraphModelListener(this);
        this.model = graphModel;
        this.model.addGraphModelListener(this);
        this.reset();
    }

    public GraphModel getModel() {
        return this.model;
    }

    public void setViewMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.viewMode = n;
                break;
            }
            default: {
                Core.USER_ERROR("Attempt to set an illegal view mode: " + n);
            }
        }
    }

    public GraphNodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public void setNodeRenderer(GraphNodeRenderer graphNodeRenderer) {
        this.nodeRenderer = graphNodeRenderer;
    }

    public GraphNodeEditor getNodeEditor() {
        return this.nodeEditor;
    }

    public void setNodeEditor(GraphNodeEditor graphNodeEditor) {
        if (this.nodeEditor != null) {
            this.nodeEditor.removeGraphNodeEditorListener(this);
        }
        this.nodeEditor = graphNodeEditor;
        if (this.nodeEditor != null) {
            this.nodeEditor.addGraphNodeEditorListener(this);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.reset();
    }

    public boolean isVisible(GraphNode graphNode) {
        GraphIcon graphIcon = (GraphIcon)this.ViewList.get(graphNode);
        return graphIcon != null && graphIcon.isVisible();
    }

    public Rectangle getBounds(GraphNode graphNode) {
        GraphIcon graphIcon = (GraphIcon)this.ViewList.get(graphNode);
        if (graphIcon != null) {
            return graphIcon.getBounds();
        }
        Core.USER_ERROR("getBounds called on a null node");
        return new Rectangle(0, 0, 0, 0);
    }

    protected void reset() {
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            GraphIcon graphIcon = (GraphIcon)enumeration.nextElement();
            graphIcon.removeGraphIconListener(this);
        }
        this.ViewList.clear();
        this.removeAll();
        enumeration = this.model.nodes();
        while (enumeration.hasMoreElements()) {
            this.addNode((GraphNode)enumeration.nextElement());
        }
        this.recompute();
    }

    protected void addNode(GraphNode graphNode) {
        GraphIcon graphIcon;
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            graphIcon = (GraphIcon)enumeration.nextElement();
            rectangle = rectangle.union(graphIcon.getBounds());
        }
        graphIcon = new GraphIcon(graphNode, this);
        this.ViewList.put(graphNode, graphIcon);
        this.add(graphIcon);
        graphIcon.setLocation(new Point(rectangle.x + rectangle.width, rectangle.y));
        graphIcon.addGraphIconListener(this);
    }

    protected void removeNode(GraphNode graphNode) {
        GraphIcon graphIcon = (GraphIcon)this.ViewList.remove(graphNode);
        if (graphIcon != null) {
            this.remove(graphIcon);
            graphIcon.removeGraphIconListener(this);
        }
    }

    protected void updateNode(GraphNode graphNode) {
        GraphIcon graphIcon = (GraphIcon)this.ViewList.get(graphNode);
        if (graphIcon != null) {
            graphIcon.reset();
        }
    }

    public void hide() {
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            GraphIcon graphIcon = (GraphIcon)enumeration.nextElement();
            if (!graphIcon.isSelected()) continue;
            graphIcon.setVisible(false);
        }
        this.repaint();
    }

    public void show() {
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            GraphIcon graphIcon = (GraphIcon)enumeration.nextElement();
            if (graphIcon.isVisible()) continue;
            graphIcon.setVisible(true);
        }
        this.repaint();
    }

    public void collapse() {
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            GraphIcon graphIcon = (GraphIcon)enumeration.nextElement();
            if (!graphIcon.isSelected()) continue;
            this.collapseNode(graphIcon.getGraphNode(), new Vector());
        }
        this.repaint();
    }

    public void expand() {
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            GraphIcon graphIcon = (GraphIcon)enumeration.nextElement();
            if (!graphIcon.isSelected()) continue;
            this.expandNode(graphIcon.getGraphNode(), new Vector());
        }
        this.repaint();
    }

    public GraphNode[] getSelectedNodes() {
        Vector<GraphIcon> vector = new Vector<GraphIcon>();
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            GraphIcon graphIcon = (GraphIcon)enumeration.nextElement();
            if (!graphIcon.isSelected()) continue;
            vector.addElement(graphIcon);
        }
        GraphNode[] graphNodeArray = new GraphNode[vector.size()];
        int n = 0;
        while (n < graphNodeArray.length) {
            graphNodeArray[n] = ((GraphIcon)vector.elementAt(n)).getGraphNode();
            ++n;
        }
        return graphNodeArray;
    }

    protected void collapseNode(GraphNode graphNode, Vector vector) {
        GraphNode[] graphNodeArray = graphNode.getChildren();
        vector.addElement(graphNode);
        int n = 0;
        while (n < graphNodeArray.length) {
            GraphIcon graphIcon = (GraphIcon)this.ViewList.get(graphNodeArray[n]);
            if (graphIcon != null) {
                graphIcon.setVisible(false);
                graphIcon.setSelected(false);
                if (!vector.contains(graphNodeArray[n])) {
                    this.collapseNode(graphNodeArray[n], vector);
                }
            }
            ++n;
        }
    }

    protected void expandNode(GraphNode graphNode, Vector vector) {
        GraphNode[] graphNodeArray = graphNode.getChildren();
        vector.addElement(graphNode);
        int n = 0;
        while (n < graphNodeArray.length) {
            GraphIcon graphIcon = (GraphIcon)this.ViewList.get(graphNodeArray[n]);
            if (graphIcon != null) {
                graphIcon.setVisible(true);
                if (!vector.contains(graphNodeArray[n])) {
                    this.expandNode(graphNodeArray[n], vector);
                }
            }
            ++n;
        }
    }

    public void select() {
        Vector vector = this.boundedItems();
        if (vector != null) {
            GraphIcon graphIcon;
            boolean bl = true;
            int n = 0;
            while (n < vector.size()) {
                graphIcon = (GraphIcon)vector.elementAt(n);
                boolean bl2 = bl = bl && graphIcon.isSelected();
                if (!bl) break;
                ++n;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                graphIcon = (GraphIcon)vector.elementAt(n2);
                if (bl) {
                    graphIcon.setSelected(false);
                } else {
                    graphIcon.setSelected(true);
                }
                ++n2;
            }
        }
    }

    public void selectAll() {
        GraphIcon graphIcon;
        boolean bl = true;
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            graphIcon = (GraphIcon)enumeration.nextElement();
            boolean bl2 = bl = bl && graphIcon.isSelected();
            if (!bl) break;
        }
        enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            graphIcon = (GraphIcon)enumeration.nextElement();
            if (bl) {
                graphIcon.setSelected(false);
                continue;
            }
            graphIcon.setSelected(true);
        }
    }

    public void recompute() {
        Point point = new Point(0, 0);
        Vector<GraphNode> vector = new Vector<GraphNode>();
        switch (this.viewMode) {
            case 0: 
            case 1: {
                GraphNode graphNode;
                GraphIcon graphIcon;
                point.x = 20;
                point.y = 20;
                Enumeration<Object> enumeration = this.ViewList.elements();
                while (enumeration.hasMoreElements()) {
                    graphIcon = (GraphIcon)enumeration.nextElement();
                    graphNode = graphIcon.getGraphNode();
                    if (!graphIcon.isVisible() || graphNode.getNodeType() != 0) continue;
                    this.computeVerticalPosition(graphNode, vector, point);
                }
                enumeration = this.ViewList.elements();
                while (enumeration.hasMoreElements()) {
                    graphIcon = (GraphIcon)enumeration.nextElement();
                    graphNode = graphIcon.getGraphNode();
                    if (!graphIcon.isVisible() || graphNode.getNodeType() != 1 || vector.contains(graphNode)) continue;
                    this.computeVerticalPosition(graphNode, vector, point);
                }
                if (this.viewMode == 0) break;
                Rectangle rectangle = this.getDrawArea(vector);
                int n = rectangle.y + rectangle.height / 2;
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    graphNode = (GraphNode)enumeration.nextElement();
                    graphIcon = (GraphIcon)this.ViewList.get(graphNode);
                    Rectangle rectangle2 = graphIcon.getBounds();
                    Point point2 = new Point(rectangle2.x, rectangle2.y + rectangle2.height);
                    point2 = new Point(point2.x, 2 * n - point2.y);
                    graphIcon.setLocation(point2);
                }
                break;
            }
            case 2: 
            case 3: {
                Point point3;
                GraphNode graphNode;
                GraphIcon graphIcon;
                Enumeration<Object> enumeration = this.ViewList.elements();
                while (enumeration.hasMoreElements()) {
                    graphIcon = (GraphIcon)enumeration.nextElement();
                    graphNode = graphIcon.getGraphNode();
                    if (!graphIcon.isVisible() || graphNode.getNodeType() != 0) continue;
                    this.computeHorizontalPosition(graphNode, vector, point);
                }
                enumeration = this.ViewList.elements();
                while (enumeration.hasMoreElements()) {
                    graphIcon = (GraphIcon)enumeration.nextElement();
                    graphNode = graphIcon.getGraphNode();
                    if (!graphIcon.isVisible() || graphNode.getNodeType() != 1 || vector.contains(graphNode)) continue;
                    this.computeHorizontalPosition(graphNode, vector, point);
                }
                Rectangle rectangle = this.getDrawArea(vector);
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    graphNode = (GraphNode)enumeration.nextElement();
                    graphIcon = (GraphIcon)this.ViewList.get(graphNode);
                    point3 = graphIcon.getLocation();
                    graphIcon.setLocation(point3.x - rectangle.x + 20, point3.y - rectangle.y + 20);
                }
                if (this.viewMode == 3) break;
                rectangle = this.getDrawArea(vector);
                int n = rectangle.x + rectangle.width / 2;
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    graphNode = (GraphNode)enumeration.nextElement();
                    graphIcon = (GraphIcon)this.ViewList.get(graphNode);
                    Rectangle rectangle3 = graphIcon.getBounds();
                    point3 = new Point(rectangle3.x + rectangle3.width, rectangle3.y);
                    point3 = new Point(2 * n - point3.x + 20, point3.y - 20);
                    graphIcon.setLocation(point3);
                }
                break;
            }
            case 4: {
                Enumeration enumeration;
                GraphIcon graphIcon;
                GraphNode[] graphNodeArray = this.getSelectedNodes();
                GraphNode graphNode = null;
                boolean bl = false;
                if (graphNodeArray.length > 0) {
                    int n = 0;
                    while (!bl && n < graphNodeArray.length) {
                        graphNode = graphNodeArray[n];
                        graphIcon = (GraphIcon)this.ViewList.get(graphNode);
                        bl = graphIcon.isVisible();
                        ++n;
                    }
                }
                if (!bl && !this.ViewList.isEmpty()) {
                    enumeration = this.ViewList.keys();
                    while (!bl && enumeration.hasMoreElements()) {
                        graphNode = (GraphNode)enumeration.nextElement();
                        graphIcon = (GraphIcon)this.ViewList.get(graphNode);
                        bl = graphIcon.isVisible();
                    }
                }
                if (!bl) break;
                GraphNode graphNode2 = graphNode;
                enumeration = this.ViewList.keys();
                while (enumeration.hasMoreElements()) {
                    graphNode = (GraphNode)enumeration.nextElement();
                    graphIcon = (GraphIcon)this.ViewList.get(graphNode);
                    if (!graphIcon.isVisible()) continue;
                    vector.addElement(graphNode);
                }
                this.centerView(graphNode2, vector);
                break;
            }
            case 5: {
                point.x = 20;
                point.y = 20;
                Enumeration enumeration = this.ViewList.elements();
                while (enumeration.hasMoreElements()) {
                    GraphIcon graphIcon = (GraphIcon)enumeration.nextElement();
                    GraphNode graphNode = graphIcon.getGraphNode();
                    if (!graphIcon.isVisible()) continue;
                    this.computeCircularPosition(graphNode, vector, point);
                }
                break;
            }
        }
        this.redraw();
    }

    protected Rectangle getDrawArea(Vector vector) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            GraphIcon graphIcon = (GraphIcon)enumeration.nextElement();
            GraphNode graphNode = graphIcon.getGraphNode();
            if (!vector.contains(graphNode)) continue;
            rectangle = rectangle.union(graphIcon.getBounds());
        }
        return rectangle;
    }

    public void redraw() {
        this.invalidate();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paintComponent(graphics);
        this.drawLinks(graphics);
    }

    protected void drawLinks(Graphics graphics) {
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            GraphIcon graphIcon = (GraphIcon)enumeration.nextElement();
            GraphNode graphNode = graphIcon.getGraphNode();
            if (!graphIcon.isVisible()) continue;
            this.drawLinks(graphNode, graphics);
        }
        this.revalidate();
    }

    protected void getRelations(Vector vector, Vector vector2) {
        int n = 0;
        while (n < vector.size()) {
            GraphNode graphNode = (GraphNode)vector.elementAt(n);
            if (!vector2.contains(graphNode)) {
                vector2.addElement(graphNode);
                Vector vector3 = this.model.getViewRelations(graphNode);
                vector3 = Misc.difference(vector3, vector2);
                this.getRelations(vector3, vector2);
            }
            ++n;
        }
    }

    protected boolean computeCircularPosition(GraphNode graphNode, Vector vector, Point point) {
        GraphIcon graphIcon;
        GraphNode graphNode2;
        if (vector.contains(graphNode)) {
            return false;
        }
        Point point2 = new Point(0, 0);
        Vector<GraphNode> vector2 = new Vector<GraphNode>();
        vector2.addElement(graphNode);
        this.getRelations(this.model.getViewRelations(graphNode), vector2);
        int n = 0;
        while (n < vector2.size()) {
            graphNode2 = (GraphNode)vector2.elementAt(n);
            graphIcon = (GraphIcon)this.ViewList.get(graphNode2);
            vector.addElement(graphNode2);
            if (!graphIcon.isVisible()) {
                vector2.removeElementAt(n--);
            }
            ++n;
        }
        if (vector2.size() <= 2) {
            int n2 = 0;
            while (n2 < vector2.size()) {
                graphNode2 = (GraphNode)vector2.elementAt(n2);
                graphIcon = (GraphIcon)this.ViewList.get(graphNode2);
                Dimension dimension = graphIcon.getSize();
                point2.x = point.x + (30 + dimension.width) / 2;
                point2.y = point.y + (60 + dimension.height) / 2;
                graphIcon.setLocation(new Point(point2.x - dimension.width / 2, point2.y - dimension.height / 2));
                point.x += dimension.width + 30;
                ++n2;
            }
            return true;
        }
        Dimension[] dimensionArray = new Dimension[vector2.size()];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < vector2.size()) {
            graphNode2 = (GraphNode)vector2.elementAt(n5);
            graphIcon = (GraphIcon)this.ViewList.get(graphNode2);
            dimensionArray[n5] = graphIcon.getSize();
            n4 = Math.max(n4, dimensionArray[n5].width);
            n3 = Math.max(n3, dimensionArray[n5].height);
            ++n5;
        }
        int n6 = (int)(2.0 * (double)n3 / Math.tan(Math.PI / (double)vector2.size()));
        int n7 = 2 * n4 + 30 + 2 * n6;
        int n8 = 2 * n3 + 20 + 2 * n6;
        int n9 = point.x + n7 / 2;
        int n10 = point.y + n8 / 2;
        point.x += n7;
        double d = Math.PI * 2 / (double)vector2.size();
        int n11 = 0;
        while (n11 < vector2.size()) {
            double d3 = (double)n11 * d;
            point2.x = (int)((double)n9 + (double)n6 * Math.cos(d3)) - dimensionArray[n11].width / 2;
            point2.y = (int)((double)n10 + (double)n6 * Math.sin(d3)) - dimensionArray[n11].height / 2;
            graphNode2 = (GraphNode)vector2.elementAt(n11);
            graphIcon = (GraphIcon)this.ViewList.get(graphNode2);
            graphIcon.setLocation(point2);
            ++n11;
        }
        return true;
    }

    protected boolean centerView(GraphNode graphNode, Vector vector) {
        GraphNode graphNode2;
        Dimension dimension;
        Serializable serializable;
        GraphIcon graphIcon = (GraphIcon)this.ViewList.get(graphNode);
        if (graphIcon == null) {
            return false;
        }
        if (this.getParent().getClass() == (class$javax$swing$JViewport == null ? (class$javax$swing$JViewport = Graph.class$("javax.swing.JViewport")) : class$javax$swing$JViewport)) {
            serializable = (JViewport)this.getParent();
            ((JViewport)serializable).setViewPosition(new Point(0, 0));
            dimension = ((Component)serializable).getSize();
        } else {
            dimension = this.getSize();
        }
        serializable = graphIcon.getSize();
        int n = Math.min(dimension.width, dimension.height) / 2;
        graphIcon.setLocation(new Point(dimension.width / 2 - ((Dimension)serializable).width / 2, dimension.height / 2 - ((Dimension)serializable).height / 2));
        int n2 = (((Dimension)serializable).width + ((Dimension)serializable).height) / 2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < vector.size()) {
            graphNode2 = (GraphNode)vector.elementAt(n4);
            if (graphNode2 != graphNode && (graphIcon = (GraphIcon)this.ViewList.get(graphNode2)) != null) {
                serializable = graphIcon.getSize();
                n2 += (((Dimension)serializable).width + ((Dimension)serializable).height) / 2;
                ++n3;
            }
            ++n4;
        }
        if (n3 != 0) {
            n -= n2 / n3;
            Point point = new Point(0, 0);
            double d = Math.PI * 2 / (double)n3;
            int n5 = 0;
            int n6 = 0;
            while (n6 < vector.size()) {
                graphNode2 = (GraphNode)vector.elementAt(n6);
                if (graphNode2 != graphNode && (graphIcon = (GraphIcon)this.ViewList.get(graphNode2)) != null) {
                    double d3 = (double)n5 * d;
                    point.x = (int)((double)(dimension.width / 2) + (double)n * Math.cos(d3));
                    point.y = (int)((double)(dimension.height / 2) + (double)n * Math.sin(d3));
                    serializable = graphIcon.getSize();
                    graphIcon.setLocation(new Point(point.x - ((Dimension)serializable).width / 2, point.y - ((Dimension)serializable).height / 2));
                    ++n5;
                }
                ++n6;
            }
        }
        return false;
    }

    public boolean computeHorizontalPosition(GraphNode graphNode, Vector vector, Point point) {
        Point point2 = new Point(0, 0);
        Point point3 = new Point(0, 0);
        Point point4 = new Point(0, 0);
        if (vector.contains(graphNode)) {
            return false;
        }
        vector.addElement(graphNode);
        GraphIcon graphIcon = (GraphIcon)this.ViewList.get(graphNode);
        if (graphIcon == null) {
            return false;
        }
        if (!graphIcon.isVisible()) {
            return false;
        }
        GraphNode[] graphNodeArray = graphNode.getChildren();
        Vector<GraphNode> vector2 = new Vector<GraphNode>();
        int n = 0;
        while (n < graphNodeArray.length) {
            if (!vector.contains(graphNodeArray[n])) {
                vector2.addElement(graphNodeArray[n]);
            }
            ++n;
        }
        Dimension dimension = graphIcon.getSize();
        if (vector2.isEmpty()) {
            point4.y = point.y + (60 + dimension.height) / 2 - dimension.height / 2;
            point4.x = point.x - (30 + dimension.width) / 2 - dimension.width / 2;
            graphIcon.setLocation(point4);
            point.y += dimension.height + 60;
        } else {
            point2.y = point.y;
            point2.x = point.x - (dimension.width + 30);
            int n2 = 0;
            while (n2 < vector2.size()) {
                GraphNode graphNode2 = (GraphNode)vector2.elementAt(n2);
                this.computeHorizontalPosition(graphNode2, vector, point2);
                ++n2;
            }
            point4.y = (point.y + point2.y) / 2 - dimension.height / 2;
            point4.x = point.x - (dimension.width + 30) / 2 - dimension.width / 2;
            graphIcon.setLocation(point4);
            point.y = point2.y;
        }
        GraphNode[] graphNodeArray2 = graphNode.getSiblings();
        int n3 = 0;
        while (n3 < graphNodeArray2.length) {
            if (!vector.contains(graphNodeArray2[n3])) {
                this.computeHorizontalPosition(graphNodeArray2[n3], vector, point);
            }
            ++n3;
        }
        return true;
    }

    public boolean computeVerticalPosition(GraphNode graphNode, Vector vector, Point point) {
        Point point2 = new Point(0, 0);
        Point point3 = new Point(0, 0);
        Point point4 = new Point(0, 0);
        if (vector.contains(graphNode)) {
            return false;
        }
        vector.addElement(graphNode);
        GraphIcon graphIcon = (GraphIcon)this.ViewList.get(graphNode);
        if (graphIcon == null) {
            return false;
        }
        if (!graphIcon.isVisible()) {
            return false;
        }
        GraphNode[] graphNodeArray = graphNode.getChildren();
        Vector<GraphNode> vector2 = new Vector<GraphNode>();
        int n = 0;
        while (n < graphNodeArray.length) {
            if (!vector.contains(graphNodeArray[n])) {
                vector2.addElement(graphNodeArray[n]);
            }
            ++n;
        }
        Dimension dimension = graphIcon.getSize();
        if (vector2.isEmpty()) {
            point4.x = point.x + (30 + dimension.width) / 2 - dimension.width / 2;
            point4.y = point.y + (60 + dimension.height) / 2 - dimension.height / 2;
            graphIcon.setLocation(point4);
            point.x += dimension.width + 30;
        } else {
            point2.x = point.x;
            point2.y = point.y + dimension.height + 60;
            int n2 = 0;
            while (n2 < vector2.size()) {
                GraphNode graphNode2 = (GraphNode)vector2.elementAt(n2);
                this.computeVerticalPosition(graphNode2, vector, point2);
                ++n2;
            }
            point4.x = (point.x + point2.x) / 2 - dimension.width / 2;
            point4.y = point.y + (dimension.height + 60) / 2 - dimension.height / 2;
            graphIcon.setLocation(point4);
            point.x = point2.x;
        }
        GraphNode[] graphNodeArray2 = graphNode.getSiblings();
        int n3 = 0;
        while (n3 < graphNodeArray2.length) {
            if (!vector.contains(graphNodeArray2[n3])) {
                this.computeVerticalPosition(graphNodeArray2[n3], vector, point);
            }
            ++n3;
        }
        return true;
    }

    protected void drawLinks(GraphNode graphNode, Graphics graphics) {
        Color color;
        GraphIcon graphIcon = (GraphIcon)this.ViewList.get(graphNode);
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        GraphNode[] graphNodeArray = graphNode.getParents();
        int n = 0;
        while (n < graphNodeArray.length) {
            if (this.model.isLinkVisible(graphNode, graphNodeArray[n]) && this.getConnections(graphNode, graphNodeArray[n], point, point2)) {
                color = this.model.getLinkColor(graphNode, graphNodeArray[n]);
                this.drawEdge(color, point, point2, graphics);
            }
            ++n;
        }
        GraphNode[] graphNodeArray2 = graphNode.getChildren();
        int n2 = 0;
        while (n2 < graphNodeArray2.length) {
            if (this.model.isLinkVisible(graphNode, graphNodeArray2[n2]) && this.getConnections(graphNode, graphNodeArray2[n2], point, point2)) {
                color = this.model.getLinkColor(graphNode, graphNodeArray2[n2]);
                this.drawEdge(color, point, point2, graphics);
            }
            ++n2;
        }
        GraphNode[] graphNodeArray3 = graphNode.getSiblings();
        int n3 = 0;
        while (n3 < graphNodeArray3.length) {
            if (this.model.isLinkVisible(graphNode, graphNodeArray3[n3]) && this.getConnections(graphNode, graphNodeArray3[n3], point, point2)) {
                color = this.model.getLinkColor(graphNode, graphNodeArray3[n3]);
                this.drawEdge(color, point, point2, graphics);
            }
            ++n3;
        }
    }

    protected void getConnection(Rectangle rectangle, int n, Point point) {
        switch (n) {
            case 1: {
                point.x = rectangle.x + rectangle.width / 2;
                point.y = rectangle.y;
                return;
            }
            case 2: {
                point.x = rectangle.x + rectangle.width / 2;
                point.y = rectangle.y + rectangle.height;
                return;
            }
            case 3: {
                point.x = rectangle.x;
                point.y = rectangle.y + rectangle.height / 2;
                return;
            }
            case 4: {
                point.x = rectangle.x + rectangle.width;
                point.y = rectangle.y + rectangle.height / 2;
                return;
            }
        }
    }

    protected boolean getConnections(GraphNode graphNode, GraphNode graphNode2, Point point, Point point2) {
        GraphIcon graphIcon = (GraphIcon)this.ViewList.get(graphNode);
        GraphIcon graphIcon2 = (GraphIcon)this.ViewList.get(graphNode2);
        if (graphIcon == null || graphIcon2 == null || !graphIcon.isVisible() || !graphIcon2.isVisible()) {
            return false;
        }
        Rectangle rectangle = graphIcon.getBounds();
        Rectangle rectangle2 = graphIcon2.getBounds();
        switch (this.viewMode) {
            case 2: 
            case 3: {
                if (rectangle2.x > rectangle.x + rectangle.width) {
                    this.getConnection(rectangle, 4, point);
                    this.getConnection(rectangle2, 3, point2);
                    return true;
                }
                if (rectangle2.x + rectangle2.width < rectangle.x) {
                    this.getConnection(rectangle, 3, point);
                    this.getConnection(rectangle2, 4, point2);
                    return true;
                }
                if (rectangle2.y > rectangle.y + rectangle.height) {
                    this.getConnection(rectangle, 2, point);
                    this.getConnection(rectangle2, 1, point2);
                    return true;
                }
                if (rectangle2.y + rectangle2.height < rectangle.y) {
                    this.getConnection(rectangle, 1, point);
                    this.getConnection(rectangle2, 2, point2);
                    return true;
                }
                return false;
            }
        }
        if (rectangle2.y > rectangle.y + rectangle.height) {
            this.getConnection(rectangle, 2, point);
            this.getConnection(rectangle2, 1, point2);
            return true;
        }
        if (rectangle2.y + rectangle2.height < rectangle.y) {
            this.getConnection(rectangle, 1, point);
            this.getConnection(rectangle2, 2, point2);
            return true;
        }
        if (rectangle2.x > rectangle.x + rectangle.width) {
            this.getConnection(rectangle, 4, point);
            this.getConnection(rectangle2, 3, point2);
            return true;
        }
        if (rectangle2.x + rectangle2.width < rectangle.x) {
            this.getConnection(rectangle, 3, point);
            this.getConnection(rectangle2, 4, point2);
            return true;
        }
        return false;
    }

    protected void drawEdge(Color color, Point point, Point point2, Graphics graphics) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.setPaintMode();
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        Point[] pointArray = ArrowData.getPoints(point.x, point.y, point2.x, point2.y);
        int n = 0;
        while (n < 2) {
            graphics.drawLine(pointArray[n].x, pointArray[n].y, pointArray[n + 1].x, pointArray[n + 1].y);
            ++n;
        }
        graphics.setColor(color2);
    }

    protected GraphIcon findIcon(Point point) {
        Enumeration enumeration = this.ViewList.elements();
        while (enumeration.hasMoreElements()) {
            GraphIcon graphIcon = (GraphIcon)enumeration.nextElement();
            Rectangle rectangle = graphIcon.getBounds();
            if (!rectangle.contains(point.x, point.y)) continue;
            return graphIcon;
        }
        return null;
    }

    public void locationChanged(GraphIconEvent graphIconEvent) {
        this.redraw();
    }

    public void performLeftMouseDClickAction(GraphIconEvent graphIconEvent) {
        GraphIcon graphIcon;
        GraphNode graphNode;
        if (this.nodeEditorComponent == null && this.isNodeEditable && this.model.isNodeEditable(graphNode = (graphIcon = (GraphIcon)graphIconEvent.getSource()).getGraphNode())) {
            if (this.nodeEditor == null) {
                this.nodeEditor = new DefaultGraphNodeEditor();
                this.nodeEditor.addGraphNodeEditorListener(this);
            }
            this.nodeEditorComponent = this.nodeEditor.getNodeEditorComponent(this, graphNode);
            Component component = SwingUtilities.getRoot(this);
            if (!(this.nodeEditorComponent instanceof Window)) {
                if (component instanceof JDialog) {
                    this.pane = ((JDialog)component).getLayeredPane();
                } else if (component instanceof JFrame) {
                    this.pane = ((JFrame)component).getLayeredPane();
                } else {
                    Core.ERROR(null, 1, (Object)this);
                }
                this.pane.add(this.nodeEditorComponent, JLayeredPane.PALETTE_LAYER);
                this.pane.moveToFront(this.nodeEditorComponent);
            }
            Point point = SwingUtilities.convertPoint(graphIcon, 0, 0, component);
            this.nodeEditorComponent.setLocation(point);
            this.nodeEditorComponent.setVisible(true);
            if (this.nodeEditorComponent instanceof JComponent) {
                this.nodeEditorComponent.requestFocus();
            }
        }
    }

    public void performLeftMouseAction(GraphIconEvent graphIconEvent) {
    }

    public void performRightMouseAction(GraphIconEvent graphIconEvent) {
        if (!this.isLinkEditable) {
            return;
        }
        Graphics graphics = this.getGraphics();
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        if (graphIconEvent.isRightMousePressed()) {
            if (!(graphIconEvent.getSource() instanceof GraphIcon)) {
                this.sourceIcon = null;
                return;
            }
            this.sourceIcon = (GraphIcon)graphIconEvent.getSource();
            this.stretchedPoint = this.startPoint = SwingUtilities.convertPoint(this.sourceIcon, graphIconEvent.getPoint().x, graphIconEvent.getPoint().y, this);
            this.lastPoint = this.startPoint;
        } else if (graphIconEvent.isRightMouseDragged()) {
            if (this.sourceIcon == null) {
                return;
            }
            this.lastPoint = this.stretchedPoint;
            this.stretchedPoint = SwingUtilities.convertPoint(this.sourceIcon, graphIconEvent.getPoint().x, graphIconEvent.getPoint().y, this);
            graphics.setXORMode(this.getBackground());
            graphics.drawLine(this.startPoint.x, this.startPoint.y, this.lastPoint.x, this.lastPoint.y);
            graphics.drawLine(this.startPoint.x, this.startPoint.y, this.stretchedPoint.x, this.stretchedPoint.y);
        } else if (graphIconEvent.isRightMouseReleased()) {
            if (this.sourceIcon == null) {
                return;
            }
            this.lastPoint = this.stretchedPoint;
            this.stretchedPoint = SwingUtilities.convertPoint(this.sourceIcon, graphIconEvent.getPoint().x, graphIconEvent.getPoint().y, this);
            graphics.setXORMode(this.getBackground());
            graphics.drawLine(this.startPoint.x, this.startPoint.y, this.lastPoint.x, this.lastPoint.y);
            this.destIcon = this.findIcon(this.stretchedPoint);
            if (this.destIcon == null) {
                return;
            }
            graphics.drawLine(this.startPoint.x, this.startPoint.y, this.stretchedPoint.x, this.stretchedPoint.y);
            Point[] pointArray = ArrowData.getPoints(this.startPoint.x, this.startPoint.y, this.stretchedPoint.x, this.stretchedPoint.y);
            int n = 0;
            while (n < 2) {
                graphics.drawLine(pointArray[n].x, pointArray[n].y, pointArray[n + 1].x, pointArray[n + 1].y);
                ++n;
            }
        }
        graphics.setColor(color);
    }

    public void performMiddleMouseAction(GraphIconEvent graphIconEvent) {
    }

    public void graphNodeEditingStopped(GraphNodeEditorEvent graphNodeEditorEvent) {
        if (this.nodeEditorComponent != null) {
            this.nodeEditorComponent.setVisible(false);
            if (!(this.nodeEditorComponent instanceof Window)) {
                this.pane.remove(this.nodeEditorComponent);
            }
            this.nodeEditorComponent = null;
            this.model.setValue(graphNodeEditorEvent.getNode(), graphNodeEditorEvent.getValue());
        }
    }

    public void graphNodeEditingCancelled(GraphNodeEditorEvent graphNodeEditorEvent) {
        if (this.nodeEditorComponent != null) {
            this.nodeEditorComponent.setVisible(false);
            if (!(this.nodeEditorComponent instanceof Window)) {
                this.pane.remove(this.nodeEditorComponent);
            }
            this.nodeEditorComponent = null;
        }
    }

    public void graphStructureChanged(GraphModelEvent graphModelEvent) {
        if (this.model == graphModelEvent.getModel()) {
            this.reset();
        }
    }

    public void graphNodeAdded(GraphModelEvent graphModelEvent) {
        if (this.model == graphModelEvent.getModel()) {
            this.addNode(graphModelEvent.getNode());
            this.redraw();
        }
    }

    public void graphNodeRemoved(GraphModelEvent graphModelEvent) {
        if (this.model == graphModelEvent.getModel()) {
            this.removeNode(graphModelEvent.getNode());
            this.redraw();
        }
    }

    public void graphNodeStateChanged(GraphModelEvent graphModelEvent) {
        if (this.model == graphModelEvent.getModel()) {
            this.updateNode(graphModelEvent.getNode());
            this.redraw();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

