/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.graph;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import zeus.gui.graph.GraphModel;
import zeus.gui.graph.GraphModelEvent;
import zeus.gui.graph.GraphModelListener;
import zeus.gui.graph.GraphNode;

public abstract class AbstractGraphModel
implements GraphModel {
    private static final int STRUCTURE_CHANGED = 0;
    private static final int NODE_ADDED = 1;
    private static final int NODE_REMOVED = 2;
    private static final int NODE_STATE_CHANGED = 3;
    protected EventListenerList graphModelListeners = new EventListenerList();
    static /* synthetic */ Class class$zeus$gui$graph$GraphModelListener;

    public abstract Enumeration nodes();

    public abstract void setValue(GraphNode var1, Object var2);

    public abstract boolean isNodeEditable(GraphNode var1);

    public Color getLinkColor(GraphNode graphNode, GraphNode graphNode2) {
        return Color.black;
    }

    public boolean isLinkVisible(GraphNode graphNode, GraphNode graphNode2) {
        return true;
    }

    public Vector getViewRelations(GraphNode graphNode) {
        return new Vector(10);
    }

    protected void fireGraphStructureChanged() {
        this.fireGraphAction(0, null);
    }

    protected void fireGraphNodeAdded(GraphNode graphNode) {
        this.fireGraphAction(1, graphNode);
    }

    protected void fireGraphNodeRemoved(GraphNode graphNode) {
        this.fireGraphAction(2, graphNode);
    }

    protected void fireGraphNodeStateChanged(GraphNode graphNode) {
        this.fireGraphAction(3, graphNode);
    }

    public void addGraphModelListener(GraphModelListener graphModelListener) {
        this.graphModelListeners.add(class$zeus$gui$graph$GraphModelListener == null ? (class$zeus$gui$graph$GraphModelListener = AbstractGraphModel.class$("zeus.gui.graph.GraphModelListener")) : class$zeus$gui$graph$GraphModelListener, graphModelListener);
    }

    public void removeGraphModelListener(GraphModelListener graphModelListener) {
        this.graphModelListeners.remove(class$zeus$gui$graph$GraphModelListener == null ? (class$zeus$gui$graph$GraphModelListener = AbstractGraphModel.class$("zeus.gui.graph.GraphModelListener")) : class$zeus$gui$graph$GraphModelListener, graphModelListener);
    }

    private void fireGraphAction(int n, GraphNode graphNode) {
        GraphModelEvent graphModelEvent = new GraphModelEvent(this, graphNode);
        Object[] objectArray = this.graphModelListeners.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$zeus$gui$graph$GraphModelListener == null ? AbstractGraphModel.class$("zeus.gui.graph.GraphModelListener") : class$zeus$gui$graph$GraphModelListener)) {
                GraphModelListener graphModelListener = (GraphModelListener)objectArray[n2 + 1];
                switch (n) {
                    case 0: {
                        graphModelListener.graphStructureChanged(graphModelEvent);
                        break;
                    }
                    case 1: {
                        graphModelListener.graphNodeAdded(graphModelEvent);
                        break;
                    }
                    case 2: {
                        graphModelListener.graphNodeRemoved(graphModelEvent);
                        break;
                    }
                    case 3: {
                        graphModelListener.graphNodeStateChanged(graphModelEvent);
                    }
                }
            }
            n2 -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

