/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.fields;

import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class RealNumberField
extends JTextField
implements FocusListener,
DocumentListener {
    protected static char MINUS = (char)45;
    protected static char PERIOD = (char)46;
    protected EventListenerList changeListeners = new EventListenerList();
    protected double min;
    protected double max;
    protected boolean range_check = false;
    protected boolean range_checked = false;
    static char[] numberSet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public RealNumberField() {
    }

    public RealNumberField(double d, double d3) {
        this();
        this.min = d;
        this.max = d3;
        this.range_check = true;
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.range_check && !this.range_checked) {
            this.range_checked = true;
            try {
                double d = Double.valueOf(this.getText());
                if (d < this.min || d > this.max) {
                    this.errorMsg();
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.errorMsg();
                return;
            }
        }
    }

    public void setText(Double d) {
        this.setText(d.toString());
    }

    public void setText(Integer n) {
        this.setText(n.toString());
    }

    public void setText(Long l) {
        this.setText(l.toString());
    }

    protected void errorMsg() {
        JOptionPane.showMessageDialog(this, "Illegal entry\nValue must be between " + this.min + " and " + this.max + " inclusive", "Error", 0);
    }

    public void setValue(double d) {
        if (this.range_check && (d < this.min || d > this.max)) {
            this.errorMsg();
            return;
        }
        this.setText(Double.toString(d));
    }

    public Double getValue() {
        try {
            return new Double(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Double getValue(double d) {
        try {
            return new Double(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return new Double(d);
        }
    }

    protected Document createDefaultModel() {
        RealNumberFieldDocument realNumberFieldDocument = new RealNumberFieldDocument();
        realNumberFieldDocument.addDocumentListener(this);
        return realNumberFieldDocument;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.range_checked = false;
        this.fireChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.range_checked = false;
        this.fireChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.range_checked = false;
        this.fireChanged();
    }

    static boolean member(char c, char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == c) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = RealNumberField.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = RealNumberField.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? RealNumberField.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RealNumberFieldDocument
    extends PlainDocument {
        RealNumberFieldDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            string = string.trim();
            int n2 = this.getLength();
            String string2 = this.getText(0, n) + string + this.getText(n, n2 - n);
            char[] cArray = (string2 = string2.trim()).toCharArray();
            if (cArray.length > 0 && cArray[0] != MINUS && !RealNumberField.member(cArray[0], numberSet) && cArray[0] != PERIOD) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            boolean bl = cArray.length > 0 && cArray[0] == PERIOD;
            int n3 = 1;
            while (n3 < cArray.length) {
                if (!RealNumberField.member(cArray[n3], numberSet)) {
                    if (!bl && cArray[n3] == PERIOD) {
                        bl = true;
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
                ++n3;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

