/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import zeus.gui.fields.LargeTextField;
import zeus.util.Core;

public class ExpressionCellEditor
extends DefaultCellEditor
implements ActionListener {
    protected JButton button = new JButton("");
    protected int row;
    protected int column;
    protected LargeTextField valuefield = new LargeTextField(10, 40);
    protected boolean first = true;
    protected TableModel model;

    public ExpressionCellEditor(TableModel tableModel) {
        super(new JTextField());
        this.model = tableModel;
        this.setClickCountToStart(2);
        this.button.setBackground(Color.white);
        this.button.setBorderPainted(false);
        this.button.addActionListener(this);
        this.valuefield.setLineWrap(true);
        this.valuefield.addActionListener(this);
        this.valuefield.setBackground(Color.green);
        this.valuefield.setOpaque(true);
        this.valuefield.setSize(400, 80);
        this.valuefield.setMinimumSize(new Dimension(400, 80));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.button) {
            this.button.setEnabled(false);
            Component component = SwingUtilities.getRoot(this.button);
            JLayeredPane jLayeredPane = null;
            if (component instanceof JDialog) {
                jLayeredPane = ((JDialog)component).getLayeredPane();
            } else if (component instanceof JFrame) {
                jLayeredPane = ((JFrame)component).getLayeredPane();
            } else {
                Core.ERROR(null, 1, (Object)this);
            }
            if (this.first) {
                jLayeredPane.add((Component)this.valuefield, JLayeredPane.PALETTE_LAYER);
                this.first = false;
            }
            Point point = SwingUtilities.convertPoint(this.button, 0, 0, component);
            jLayeredPane.moveToFront(this.valuefield);
            this.valuefield.setVisible(true);
            this.valuefield.setLocation(new Point(point.x - 2, point.y - 22));
            this.valuefield.grabFocus();
        } else if (object == this.valuefield) {
            this.fireEditingStopped();
            this.valuefield.setVisible(false);
            String string = this.valuefield.getText();
            this.model.setValueAt(string, this.row, this.column);
        }
    }

    public Document getDocument() {
        return this.valuefield.getDocument();
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.valuefield.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.valuefield.removeMouseListener(mouseListener);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.row = n;
        this.column = n2;
        String string = "";
        if (object != null) {
            string = (String)object;
        }
        this.valuefield.setText(string);
        this.valuefield.selectAll();
        this.button.setEnabled(true);
        this.button.setText(string);
        return this.button;
    }
}

