/*
 * Decompiled with CFR 0.152.
 */
package zeus.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;

public class MultipleSelectionDialog
extends JDialog
implements ActionListener {
    protected JButton cancelButton;
    protected JButton selectButton;
    protected JButton clearButton;
    protected JButton invertButton;
    protected String SELECT_ALL = "Select All";
    protected String CLEAR_ALL = "Clear All";
    protected String INVERT = "Invert Selection";
    protected String OK = "OK";
    protected String CANCEL = "Cancel";
    protected JList list;
    protected JButton okButton;
    protected Object[] selection = null;

    public MultipleSelectionDialog(Frame frame, String string, Object[] objectArray) {
        this(frame, string);
        this.list.setListData(objectArray);
    }

    public MultipleSelectionDialog(Frame frame, String string, Object[] objectArray, Object[] objectArray2) {
        this(frame, string);
        this.list.setListData(objectArray);
        this.setSelection(objectArray2);
    }

    public MultipleSelectionDialog(Frame frame, String string) {
        super(frame, string, true);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new JButton(this.OK);
        this.cancelButton = new JButton(this.CANCEL);
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel3 = new JPanel();
        JSeparator jSeparator = new JSeparator();
        jPanel3.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel3.add(jSeparator);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel3.add(jPanel2);
        this.list = new JList();
        this.list.setSelectionModel(new DefaultListSelectionModel());
        this.list.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.list);
        jScrollPane.setPreferredSize(new Dimension(150, 150));
        this.selectButton = new JButton(this.SELECT_ALL);
        this.clearButton = new JButton(this.CLEAR_ALL);
        this.invertButton = new JButton(this.INVERT);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(3, 1, 2, 2));
        jPanel4.add(this.selectButton);
        jPanel4.add(this.clearButton);
        jPanel4.add(this.invertButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel5.add(jScrollPane);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 40, 0, 10);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel5.add(jPanel4);
        jPanel.add("South", jPanel3);
        jPanel.add("Center", jPanel5);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.selectButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.invertButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MultipleSelectionDialog.this.setVisible(false);
            }
        });
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.list.getModel().getSize();
        if (object == this.selectButton) {
            this.list.setSelectionInterval(0, n - 1);
        } else if (object == this.clearButton) {
            this.list.clearSelection();
        } else if (object == this.invertButton) {
            int[] nArray = this.list.getSelectedIndices();
            this.list.clearSelection();
            int n2 = 0;
            while (n2 < n) {
                boolean bl = false;
                int n3 = 0;
                while (!bl && n3 < nArray.length) {
                    bl = nArray[n3] == n2;
                    ++n3;
                }
                if (!bl) {
                    this.list.addSelectionInterval(n2, n2);
                }
                ++n2;
            }
        } else if (object == this.okButton) {
            if (!this.list.isSelectionEmpty()) {
                this.selection = this.list.getSelectedValues();
            }
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public Object[] getPriorSelection() {
        return this.list.getSelectedValues();
    }

    public Object[] getSelection() {
        this.selection = null;
        this.setVisible(true);
        return this.selection;
    }

    public void setListData(Object[] objectArray) {
        this.list.setListData(objectArray);
    }

    public void setSelection(Object[] objectArray) {
        ListModel listModel = this.list.getModel();
        int n = listModel.getSize();
        this.list.clearSelection();
        int n2 = 0;
        while (n2 < objectArray.length) {
            int n3 = 0;
            while (n3 < n) {
                if (objectArray[n2] == listModel.getElementAt(n3)) {
                    this.list.addSelectionInterval(n3, n3);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public Object[] getListData() {
        ListModel listModel = this.list.getModel();
        Vector vector = new Vector();
        int n = 0;
        while (n < listModel.getSize()) {
            vector.addElement(listModel.getElementAt(n));
            ++n;
        }
        return vector.toArray();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test");
        jFrame.setSize(200, 200);
        jFrame.show();
        Object[] objectArray = new String[]{"Dave", "John", "Henry", "Alice", "Albert"};
        MultipleSelectionDialog multipleSelectionDialog = new MultipleSelectionDialog((Frame)jFrame, "Select Servers");
        multipleSelectionDialog.setListData(objectArray);
        Object[] objectArray2 = multipleSelectionDialog.getSelection();
        int n = 0;
        while (objectArray2 != null && n < objectArray2.length) {
            System.out.println(objectArray2[n]);
            ++n;
        }
        System.out.println("DONE...");
    }
}

