/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import zeus.generator.util.HashtableModel;
import zeus.generator.util.HashtablePanel;
import zeus.generator.util.ParameterChooser;

public class ParameterDialog
extends JDialog
implements ActionListener {
    protected static final String CANCEL = "Cancel";
    protected static final String OK = "Ok";
    protected JButton okButton;
    protected JButton cancelButton;
    protected ParameterChooser caller = null;
    protected HashtableModel model;

    public ParameterDialog(Frame frame, String string) {
        super(frame, string, true);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new JButton(OK);
        this.cancelButton = new JButton(CANCEL);
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel3 = new JPanel();
        JSeparator jSeparator = new JSeparator();
        jPanel3.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel3.add(jSeparator);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel3.add(jPanel2);
        this.model = new HashtableModel();
        HashtablePanel hashtablePanel = new HashtablePanel(this.model);
        hashtablePanel.setBackground(Color.lightGray);
        jPanel.add("South", jPanel3);
        jPanel.add("Center", hashtablePanel);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ParameterDialog.this.setVisible(false);
            }
        });
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.setVisible(false);
            if (this.caller != null && this.model.hasChanged()) {
                this.caller.parametersChanged(this.model.getData());
                this.repaint();
            }
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public void display(ParameterChooser parameterChooser, Hashtable hashtable) {
        this.caller = parameterChooser;
        this.model.reset(hashtable);
        this.setVisible(true);
        this.pack();
    }
}

