/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.generator.util.AttributeModel;
import zeus.generator.util.AttributeTable;
import zeus.generator.util.FactDialog;
import zeus.generator.util.FactModel;
import zeus.generator.util.FactModifier;
import zeus.generator.util.FactSelector;
import zeus.generator.util.ModifierDialog;
import zeus.gui.fields.NameField;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class FactPanel
extends JPanel {
    public static final int NONE = 0;
    public static final int PRECONDITION = 1;
    public static final int POSTCONDITION = 2;
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected FactToolBar toolbar;
    protected AttributeTable attributePanel;
    protected AttributeModel aModel;
    protected JTable table;
    protected FactModel model;
    protected ChangeListener editor;
    protected Fact[] clipboard = null;
    protected OntologyDb ontologyDb;

    public FactPanel(OntologyDb ontologyDb, ChangeListener changeListener, Fact[] factArray, boolean bl, String string) {
        this(ontologyDb, changeListener, factArray, bl, 0, string);
    }

    public FactPanel(OntologyDb ontologyDb, ChangeListener changeListener, Fact[] factArray, boolean bl, int n, String string) {
        this(changeListener, n, string, new FactModel(ontologyDb, new AttributeModel(), bl, n, factArray));
    }

    public FactPanel(ChangeListener changeListener, String string, FactModel factModel) {
        this(changeListener, 0, string, factModel);
    }

    public FactPanel(ChangeListener changeListener, int n, String string, FactModel factModel) {
        this.ontologyDb = factModel.getOntologyDb();
        this.editor = changeListener;
        this.model = factModel;
        this.aModel = factModel.getAttributeModel();
        this.attributePanel = new AttributeTable(this.aModel);
        this.aModel.addChangeListener(changeListener);
        factModel.addChangeListener(changeListener);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12);
        tableColumn.setHeaderValue(factModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24, new DefaultTableCellRenderer(), new FactInstanceEditor());
        tableColumn.setHeaderValue(factModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        if (n != 0) {
            tableColumn = new TableColumn(2, 24, new FactModifiersCellRenderer(n), new FactModifiersEditor(n));
            tableColumn.setHeaderValue(factModel.getColumnName(2));
            defaultTableColumnModel.addColumn(tableColumn);
        }
        this.table = new JTable(factModel, defaultTableColumnModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SymListAction());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        this.table.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        this.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.toolbar = new FactToolBar();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(this.toolbar, gridBagConstraints);
        this.add(this.toolbar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(this.attributePanel, gridBagConstraints);
        this.add(this.attributePanel);
    }

    protected void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    public void reset(Fact[] factArray) {
        this.model.reset(factArray);
    }

    public Fact[] getData() {
        return this.model.getData();
    }

    public FactModel getFactModel() {
        return this.model;
    }

    public AttributeModel getAttributeModel() {
        return this.aModel;
    }

    public AttributeTable getAttributeTable() {
        return this.attributePanel;
    }

    protected Fact[] getSelectedRows() {
        int[] nArray = this.table.getSelectedRows();
        Fact[] factArray = new Fact[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            factArray[n] = (Fact)this.model.getValueAt(nArray[n], 3);
            ++n;
        }
        return factArray;
    }

    protected Fact[] cutSelectedRows() {
        Fact[] factArray = this.getSelectedRows();
        this.model.removeRows(this.table.getSelectedRows());
        return factArray;
    }

    protected void deleteSelectedRow() {
        if (!this.isRowSelected()) {
            return;
        }
        this.cutSelectedRows();
    }

    protected boolean isRowSelected() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return false;
        }
        return true;
    }

    public void setToolBarState(boolean bl) {
        this.toolbar.setEnabled(bl);
    }

    public FactInstanceEditor newInstanceEditor() {
        return new FactInstanceEditor();
    }

    class FactToolBar
    extends JToolBar
    implements ActionListener,
    FactSelector {
        protected FactDialog factWin;
        protected HelpWindow helpWin;
        protected JToggleButton helpBtn;
        protected JButton newBtn;
        protected JButton deleteBtn;
        protected JButton cutBtn;
        protected JButton copyBtn;
        protected JButton pasteBtn;

        public FactToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New");
            this.newBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.cutBtn = new JButton(new ImageIcon(string2 + "cut.gif"));
            this.cutBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.cutBtn);
            this.cutBtn.setToolTipText("Cut");
            this.cutBtn.addActionListener(this);
            this.copyBtn = new JButton(new ImageIcon(string2 + "copy.gif"));
            this.copyBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.copyBtn);
            this.copyBtn.setToolTipText("Copy");
            this.copyBtn.addActionListener(this);
            this.pasteBtn = new JButton(new ImageIcon(string2 + "paste.gif"));
            this.pasteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.pasteBtn);
            this.pasteBtn.setToolTipText("Paste");
            this.pasteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
            this.factWin = new FactDialog((Frame)SwingUtilities.getRoot(this), FactPanel.this.ontologyDb);
        }

        public void setEnabled(boolean bl) {
            this.newBtn.setEnabled(bl);
            this.deleteBtn.setEnabled(bl);
            this.cutBtn.setEnabled(bl);
            this.copyBtn.setEnabled(bl);
            this.pasteBtn.setEnabled(bl);
            this.helpBtn.setEnabled(bl);
        }

        public void factSelected(String[] stringArray) {
            FactPanel.this.model.addNewRows(stringArray);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                this.factWin.setLocationRelativeTo(this.newBtn);
                this.factWin.display(this);
            } else if (object == this.deleteBtn) {
                FactPanel.this.deleteSelectedRow();
            } else if (object == this.copyBtn) {
                FactPanel.this.clipboard = FactPanel.this.getSelectedRows();
            } else if (object == this.pasteBtn) {
                FactPanel.this.model.addRows(FactPanel.this.clipboard);
                FactPanel.this.table.clearSelection();
            } else if (object == this.cutBtn) {
                FactPanel.this.clipboard = FactPanel.this.cutSelectedRows();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Fact Table");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class FactModifiersEditor
    extends DefaultCellEditor
    implements ActionListener,
    FactModifier {
        protected JButton button = new JButton("");
        protected int row;
        protected int column;
        protected ModifierDialog dialog;
        protected int type;
        protected int modifier;

        public FactModifiersEditor(int n) {
            super(new JTextField());
            this.setClickCountToStart(1);
            this.type = n;
            this.dialog = new ModifierDialog((Frame)SwingUtilities.getRoot(FactPanel.this.table), "Set Modifiers");
            this.button.setBackground(Color.white);
            this.button.setHorizontalAlignment(2);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.button) {
                this.dialog.setLocationRelativeTo(this.button);
                this.fireEditingCanceled();
                this.dialog.display(this, this.modifier, this.type);
            }
        }

        public void factModifiersChanged(int n) {
            FactPanel.this.model.setValueAt(new Integer(n), this.row, this.column);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.modifier = (Integer)object;
            return this.button;
        }
    }

    class FactModifiersCellRenderer
    extends DefaultTableCellRenderer {
        protected int type;

        public FactModifiersCellRenderer(int n) {
            this.type = n;
        }

        public void setValue(Object object) {
            String string = "";
            int n = (Integer)object;
            if (this.type == 1) {
                if (Fact.isNegative(n)) {
                    string = string + " NOT";
                }
                if (Fact.isReadOnly(n)) {
                    string = string + " READ_ONLY";
                }
                if (Fact.isLocal(n)) {
                    string = string + " LOCAL";
                }
                if (Fact.isReplaced(n)) {
                    string = string + " REPLACED";
                }
            } else if (Fact.isSideEffect(n)) {
                string = string + "SIDE_EFFECT";
            }
            super.setValue(string);
        }
    }

    class FactInstanceEditor
    extends DefaultCellEditor {
        public FactInstanceEditor() {
            super(new NameField());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)object;
            string = string.substring(1);
            return super.getTableCellEditorComponent(jTable, string, bl, n, n2);
        }
    }

    class SymListAction
    implements ListSelectionListener {
        SymListAction() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FactPanel.this.model.selectRow(FactPanel.this.table.getSelectedRow());
        }
    }
}

