/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.util;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import zeus.concepts.Fact;
import zeus.generator.util.AttributeModel;
import zeus.generator.util.BasicFactModel;
import zeus.util.TreeNode;

public class AttributeTreeModel
extends DefaultTreeModel
implements ChangeListener {
    static final String PRECONDITIONS = "PRECONDITIONS";
    static final String EFFECTS = "EFFECTS";
    static final String DEFAULT_ROOT = "#Root";
    static final String[] INVISIBLE_ITEMS = new String[]{"#Root", "PRECONDITIONS", "EFFECTS"};
    protected AttributeModel model = null;
    protected BasicFactModel preconditionsModel = null;
    protected BasicFactModel postconditionsModel = null;
    protected BasicFactModel singletonModel = null;
    protected boolean changed = true;

    public AttributeTreeModel(AttributeModel attributeModel) {
        this();
        this.model = attributeModel;
    }

    public AttributeTreeModel() {
        super(new DefaultMutableTreeNode(DEFAULT_ROOT));
    }

    public void setFactModels(BasicFactModel basicFactModel, BasicFactModel basicFactModel2) {
        if (this.preconditionsModel != null) {
            this.preconditionsModel.removeChangeListener(this);
            this.postconditionsModel.removeChangeListener(this);
        }
        this.preconditionsModel = basicFactModel;
        this.postconditionsModel = basicFactModel2;
        basicFactModel.addChangeListener(this);
        basicFactModel2.addChangeListener(this);
        if (this.singletonModel != null) {
            this.singletonModel.removeChangeListener(this);
            this.singletonModel = null;
        }
        this.changed = true;
    }

    public void setFactModel(BasicFactModel basicFactModel) {
        if (this.preconditionsModel != null) {
            this.preconditionsModel.removeChangeListener(this);
            this.postconditionsModel.removeChangeListener(this);
            this.preconditionsModel = null;
            this.postconditionsModel = null;
        }
        if (this.singletonModel != null) {
            this.singletonModel.removeChangeListener(this);
        }
        this.singletonModel = basicFactModel;
        this.singletonModel.addChangeListener(this);
        this.changed = true;
    }

    void refresh() {
        if (!this.changed) {
            return;
        }
        this.root = new DefaultMutableTreeNode(DEFAULT_ROOT);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root;
        if (this.preconditionsModel != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            TreeNode treeNode;
            String string = this.model != null ? this.model.getData().getId() : "";
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(PRECONDITIONS);
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(EFFECTS);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            defaultMutableTreeNode.add(defaultMutableTreeNode4);
            Fact[] factArray = this.preconditionsModel.getData();
            int n = 0;
            while (n < factArray.length) {
                treeNode = factArray[n].createAttributeTree(factArray[n].getId().equals(string));
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeNode);
                this.createTree(defaultMutableTreeNode2, treeNode);
                defaultMutableTreeNode3.add(defaultMutableTreeNode2);
                ++n;
            }
            factArray = this.postconditionsModel.getData();
            int n2 = 0;
            while (n2 < factArray.length) {
                treeNode = factArray[n2].createAttributeTree(factArray[n2].getId().equals(string));
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeNode);
                this.createTree(defaultMutableTreeNode2, treeNode);
                defaultMutableTreeNode4.add(defaultMutableTreeNode2);
                ++n2;
            }
        } else if (this.singletonModel != null) {
            String string = this.model != null ? this.model.getData().getId() : "";
            Fact[] factArray = this.singletonModel.getData();
            int n = 0;
            while (n < factArray.length) {
                TreeNode treeNode = factArray[n].createAttributeTree(factArray[n].getId().equals(string));
                DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(treeNode);
                this.createTree(defaultMutableTreeNode5, treeNode);
                defaultMutableTreeNode.add(defaultMutableTreeNode5);
                ++n;
            }
        } else if (this.model != null) {
            TreeNode treeNode = this.model.getData().createAttributeTree(true);
            DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(treeNode);
            this.createTree(defaultMutableTreeNode6, treeNode);
            defaultMutableTreeNode.add(defaultMutableTreeNode6);
        }
        this.changed = false;
        this.reload();
    }

    protected void createTree(DefaultMutableTreeNode defaultMutableTreeNode, TreeNode treeNode) {
        Vector vector = treeNode.getChildren();
        int n = 0;
        while (n < vector.size()) {
            TreeNode treeNode2 = (TreeNode)vector.elementAt(n);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.createTree(defaultMutableTreeNode2, treeNode2);
            ++n;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.changed = true;
    }
}

