/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import zeus.generator.util.AttributeDialog;
import zeus.generator.util.AttributeModel;
import zeus.generator.util.AttributeSelector;
import zeus.generator.util.AttributeTreeModel;
import zeus.generator.util.BasicFactModel;
import zeus.gui.editors.ExpressionCellEditor;
import zeus.gui.editors.ValidatingCellRenderer;
import zeus.gui.editors.ValidatingModel;
import zeus.util.Core;

public class AttributeTable
extends JPanel {
    protected JTable table;
    protected AttributeModel model;
    protected AttributeDialog dialog;
    protected AttributeTreeModel attributeTreeModel;

    public AttributeTable(AttributeModel attributeModel) {
        this.model = attributeModel;
        this.attributeTreeModel = new AttributeTreeModel(attributeModel);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12);
        tableColumn.setHeaderValue(attributeModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        ExpressionCellEditor expressionCellEditor = new ExpressionCellEditor(attributeModel);
        expressionCellEditor.addMouseListener(new SymMouseAction());
        tableColumn = new TableColumn(1, 24, new ValidatingCellRenderer((ValidatingModel)attributeModel, 1), expressionCellEditor);
        tableColumn.setHeaderValue(attributeModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(attributeModel, defaultTableColumnModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(new BevelBorder(1));
        this.setPreferredSize(new Dimension(200, 120));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(400, 80));
        this.table.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
    }

    public void setFactModel(BasicFactModel basicFactModel) {
        this.attributeTreeModel.setFactModel(basicFactModel);
    }

    public void setFactModels(BasicFactModel basicFactModel, BasicFactModel basicFactModel2) {
        this.attributeTreeModel.setFactModels(basicFactModel, basicFactModel2);
    }

    class SymMouseAction
    extends MouseAdapter
    implements AttributeSelector {
        protected JTextComponent field = null;

        SymMouseAction() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (AttributeTable.this.dialog == null) {
                    Component component = SwingUtilities.getRoot(AttributeTable.this.table);
                    if (component instanceof Frame) {
                        AttributeTable.this.dialog = new AttributeDialog((Frame)component, AttributeTable.this.attributeTreeModel);
                    } else if (component instanceof Dialog) {
                        AttributeTable.this.dialog = new AttributeDialog((Dialog)component, AttributeTable.this.attributeTreeModel);
                    } else {
                        Core.ERROR(null, 1, (Object)this);
                    }
                }
                this.field = (JTextComponent)mouseEvent.getSource();
                AttributeTable.this.dialog.setLocationRelativeTo(this.field);
                AttributeTable.this.dialog.display(this);
            }
        }

        public void attributeSelected(String string) {
            try {
                Document document = this.field.getDocument();
                int n = document.getLength();
                AttributeSet attributeSet = document.getDefaultRootElement().getAttributes();
                document.insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

