/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task.rulebase;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.fn.ValueFunction;
import zeus.generator.task.rulebase.RuleUI;
import zeus.ontology.facts.FactTreeUI;

public class FactPanel
extends JPanel
implements ActionListener {
    static final String FACT_MARKER = "<-";
    protected FactTreeUI treeView;
    protected JButton factIDBtn;
    protected JButton factBtn;
    RuleUI parent;
    OntologyDb db;

    public FactPanel(RuleUI ruleUI, OntologyDb ontologyDb) {
        this.parent = ruleUI;
        this.db = ontologyDb;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.treeView = new FactTreeUI(ontologyDb);
        JScrollPane jScrollPane = new JScrollPane(this.treeView);
        jScrollPane.setPreferredSize(new Dimension(400, 150));
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 10, 10));
        this.add((Component)jPanel, "South");
        this.factBtn = new JButton("Insert Fact");
        this.factBtn.addActionListener(this);
        this.factIDBtn = new JButton("Insert with ID");
        this.factIDBtn.addActionListener(this);
        jPanel.add(this.factBtn);
        jPanel.add(this.factIDBtn);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = null;
        Fact fact = null;
        String string2 = this.treeView.getSelectedNodeName();
        if (string2 == null) {
            return;
        }
        fact = this.db.getFact(true, string2);
        if (actionEvent.getSource() == this.factBtn && fact != null) {
            string = this.getAttributeValues(fact);
        } else if (actionEvent.getSource() == this.factIDBtn && fact != null) {
            string = fact.getId() + " " + FACT_MARKER + " " + this.getAttributeValues(fact);
        }
        if (string != null) {
            this.parent.appendTextTo(string);
        }
    }

    public String getAttributeValues(Fact fact) {
        String[] stringArray = fact.listAttributes();
        ValueFunction[] valueFunctionArray = fact.listValues();
        String string = "(" + fact.getType();
        int n = 0;
        while (n < stringArray.length) {
            string = string + " (" + stringArray[n] + " " + valueFunctionArray[n] + ")";
            ++n;
        }
        return string + ")";
    }
}

