/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import zeus.concepts.ConditionalNode;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.TaskNode;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.task.GroupManager;
import zeus.generator.util.AttributeModel;
import zeus.generator.util.AttributeTable;
import zeus.generator.util.FactPanel;
import zeus.gui.fields.NameField;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class TaskNodePanel
extends JPanel {
    static final String[] ERROR_MESSAGE = new String[]{"Invalid name"};
    protected EventListenerList nameListeners = new EventListenerList();
    protected boolean isConditionalNode;
    protected NameField namefield;
    protected FactPanel preconditionsPanel;
    protected FactPanel postconditionsPanel;
    protected JPanel factPanel;
    protected JPanel leftPanel;
    protected JPanel rightPanel;
    protected GroupManager leftGroupManager;
    protected GroupManager rightGroupManager;
    protected JComboBox leftCombo;
    protected JComboBox rightCombo;
    protected GroupToolBar toolbar;
    protected Hashtable nameTable;
    protected String previousName = null;
    protected AttributeModel preAttrModel;
    protected AttributeModel postAttrModel;
    protected AttributeTable preAttrTable;
    protected AttributeTable postAttrTable;
    static /* synthetic */ Class class$zeus$generator$event$RenameListener;

    public TaskNodePanel(OntologyDb ontologyDb, ChangeListener changeListener) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        JPanel jPanel = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.factPanel = new JPanel();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.factPanel, gridBagConstraints);
        this.add(this.factPanel);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Node Name");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel.setBorder(titledBorder);
        gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.lightGray);
        JLabel jLabel = new JLabel("Name:");
        jLabel.setToolTipText("Name of this node");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.namefield = new NameField(20);
        this.namefield.addChangeListener(changeListener);
        this.namefield.addFocusListener(new SymFocusAction());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        gridBagLayout.setConstraints(this.namefield, gridBagConstraints);
        jPanel.add(this.namefield);
        this.factPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.factPanel.setBackground(Color.lightGray);
        this.leftGroupManager = new GroupManager(ontologyDb, new AttributeModel(), true, 1, new Fact[0]);
        this.rightGroupManager = new GroupManager(ontologyDb, new AttributeModel(), true, 2, new Fact[0]);
        this.preconditionsPanel = new FactPanel(changeListener, 1, "Node Preconditions", this.leftGroupManager);
        this.postconditionsPanel = new FactPanel(changeListener, 2, "Node Effects", this.rightGroupManager);
        this.preAttrModel = this.preconditionsPanel.getAttributeModel();
        this.postAttrModel = this.postconditionsPanel.getAttributeModel();
        this.preAttrTable = this.preconditionsPanel.getAttributeTable();
        this.postAttrTable = this.postconditionsPanel.getAttributeTable();
        this.leftGroupManager.addRenameListener(this.preAttrModel);
        this.leftGroupManager.addRenameListener(this.postAttrModel);
        this.rightGroupManager.addRenameListener(this.preAttrModel);
        this.rightGroupManager.addRenameListener(this.postAttrModel);
        SymRenameAction symRenameAction = new SymRenameAction();
        this.leftGroupManager.addRenameListener(symRenameAction);
        this.rightGroupManager.addRenameListener(symRenameAction);
        this.nameTable = new Hashtable();
        this.leftPanel = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.leftPanel.setLayout(gridBagLayout);
        this.leftPanel.setBackground(Color.lightGray);
        jLabel = new JLabel("Group:");
        jLabel.setToolTipText("Name of this preconditions group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.leftPanel.add(jLabel);
        this.leftCombo = new JComboBox(this.leftGroupManager.getComboBoxModel()){

            public void contentsChanged(ListDataEvent listDataEvent) {
                this.selectedItemReminder = null;
                super.contentsChanged(listDataEvent);
            }
        };
        this.leftCombo.setEnabled(false);
        this.leftCombo.addActionListener(this.leftGroupManager);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        gridBagLayout.setConstraints(this.leftCombo, gridBagConstraints);
        this.leftPanel.add(this.leftCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(this.preconditionsPanel, gridBagConstraints);
        this.leftPanel.add(this.preconditionsPanel);
        this.rightPanel = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.rightPanel.setLayout(gridBagLayout);
        this.rightPanel.setBackground(Color.lightGray);
        jLabel = new JLabel("Group:");
        jLabel.setToolTipText("Name of this postconditions group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.rightPanel.add(jLabel);
        this.rightCombo = new JComboBox(this.rightGroupManager.getComboBoxModel()){

            public void contentsChanged(ListDataEvent listDataEvent) {
                this.selectedItemReminder = null;
                super.contentsChanged(listDataEvent);
            }
        };
        this.rightCombo.setEditable(true);
        this.rightCombo.addActionListener(this.rightGroupManager);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(this.rightCombo, gridBagConstraints);
        this.rightPanel.add(this.rightCombo);
        this.toolbar = new GroupToolBar(this.rightGroupManager);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        gridBagLayout.setConstraints(this.toolbar, gridBagConstraints);
        this.rightPanel.add(this.toolbar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(this.postconditionsPanel, gridBagConstraints);
        this.rightPanel.add(this.postconditionsPanel);
    }

    protected void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    GroupManager getPostconditionsManager() {
        return this.rightGroupManager;
    }

    GroupManager getPreconditionsManager() {
        return this.leftGroupManager;
    }

    TaskNode getNode() {
        TaskNode taskNode = this.isConditionalNode ? new ConditionalNode(this.namefield.getText()) : new TaskNode(this.namefield.getText());
        taskNode.setPreconditions(this.leftGroupManager.getManagerData());
        taskNode.setPostconditions(this.rightGroupManager.getManagerData());
        return taskNode;
    }

    Hashtable getNameTable() {
        return this.nameTable;
    }

    void reset(TaskNode taskNode) {
        this.isConditionalNode = false;
        this.previousName = taskNode.getName();
        this.namefield.setText(this.previousName);
        this.factPanel.removeAll();
        this.nameTable.clear();
        this.leftGroupManager.removeRelatedModel(this.rightGroupManager);
        this.rightGroupManager.removeRelatedModel(this.leftGroupManager);
        this.leftGroupManager.removeFactModelListener(this.rightGroupManager);
        this.leftGroupManager.resetManager(taskNode.getAllPreconditions());
        this.rightGroupManager.resetManager(taskNode.getAllPostconditions());
        this.postconditionsPanel.setToolBarState(true);
        this.rightGroupManager.setEditable(true);
        if (taskNode.isBeginNode()) {
            this.namefield.setEditable(false);
            this.factPanel.add(this.rightPanel);
            this.toolbar.setEnabled(false);
            this.rightCombo.setEnabled(false);
            this.postAttrTable.setFactModel(this.rightGroupManager);
        } else if (taskNode.isEndNode()) {
            this.namefield.setEditable(false);
            this.factPanel.add(this.leftPanel);
            this.preAttrTable.setFactModel(this.leftGroupManager);
        } else if (taskNode.isConditionalNode()) {
            this.isConditionalNode = true;
            this.namefield.setEditable(true);
            this.factPanel.add(this.leftPanel);
            this.factPanel.add(this.rightPanel);
            this.toolbar.setEnabled(true);
            this.rightCombo.setEnabled(true);
            this.postconditionsPanel.setToolBarState(false);
            this.rightGroupManager.setEditable(false);
            this.leftGroupManager.addFactModelListener(this.rightGroupManager);
            this.preAttrTable.setFactModel(this.leftGroupManager);
            this.postAttrTable.setFactModel(this.leftGroupManager);
            this.rightGroupManager.resetManager(taskNode.getAllPostconditions(), taskNode.getPreconditions());
        } else {
            this.namefield.setEditable(true);
            this.factPanel.add(this.leftPanel);
            this.factPanel.add(this.rightPanel);
            this.toolbar.setEnabled(false);
            this.rightCombo.setEnabled(false);
            this.leftGroupManager.addRelatedModel(this.rightGroupManager);
            this.rightGroupManager.addRelatedModel(this.leftGroupManager);
            this.preAttrTable.setFactModels(this.leftGroupManager, this.rightGroupManager);
            this.postAttrTable.setFactModels(this.leftGroupManager, this.rightGroupManager);
        }
    }

    public void addRenameListener(RenameListener renameListener) {
        this.nameListeners.add(class$zeus$generator$event$RenameListener == null ? (class$zeus$generator$event$RenameListener = TaskNodePanel.class$("zeus.generator.event.RenameListener")) : class$zeus$generator$event$RenameListener, renameListener);
        this.leftGroupManager.addRenameListener(renameListener);
        this.rightGroupManager.addRenameListener(renameListener);
    }

    public void removeRenameListener(RenameListener renameListener) {
        this.nameListeners.remove(class$zeus$generator$event$RenameListener == null ? (class$zeus$generator$event$RenameListener = TaskNodePanel.class$("zeus.generator.event.RenameListener")) : class$zeus$generator$event$RenameListener, renameListener);
        this.leftGroupManager.removeRenameListener(renameListener);
        this.rightGroupManager.removeRenameListener(renameListener);
    }

    protected void fireRenameAction(Object object, Object object2, Object object3) {
        RenameEvent renameEvent = new RenameEvent(this, object, object2, object3);
        Object[] objectArray = this.nameListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$zeus$generator$event$RenameListener == null ? TaskNodePanel.class$("zeus.generator.event.RenameListener") : class$zeus$generator$event$RenameListener)) {
                RenameListener renameListener = (RenameListener)objectArray[n + 1];
                renameListener.nameChanged(renameEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class SymFocusAction
    implements FocusListener,
    ActionListener {
        protected SymFocusAction() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.update(focusEvent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.update(actionEvent);
        }

        public void update(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object == TaskNodePanel.this.namefield && TaskNodePanel.this.previousName != null) {
                String string = TaskNodePanel.this.namefield.getText();
                if (string == null) {
                    TaskNodePanel.this.errorMsg(0);
                    TaskNodePanel.this.namefield.setText(TaskNodePanel.this.previousName);
                }
                if ((string = string.trim()).equals("")) {
                    TaskNodePanel.this.errorMsg(0);
                    TaskNodePanel.this.namefield.setText(TaskNodePanel.this.previousName);
                }
                if (!TaskNodePanel.this.previousName.equals(string)) {
                    TaskNodePanel.this.nameTable.put(TaskNodePanel.this.previousName, string);
                    TaskNodePanel.this.fireRenameAction(TaskNodePanel.this.namefield, TaskNodePanel.this.previousName, string);
                }
            }
        }
    }

    protected class SymRenameAction
    implements RenameListener {
        protected SymRenameAction() {
        }

        public void nameChanged(RenameEvent renameEvent) {
            Object object = renameEvent.getSource();
            if (object == TaskNodePanel.this.leftGroupManager || object == TaskNodePanel.this.rightGroupManager) {
                TaskNodePanel.this.nameTable.put(renameEvent.getOriginal(), renameEvent.getCurrent());
            }
        }
    }

    protected class GroupToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin;
        protected JToggleButton helpBtn;
        protected JButton newBtn;
        protected JButton deleteBtn;
        protected JButton copyBtn;
        protected GroupManager groupManager;

        public GroupToolBar(GroupManager groupManager) {
            this.groupManager = groupManager;
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New group");
            this.newBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete group");
            this.deleteBtn.addActionListener(this);
            this.copyBtn = new JButton(new ImageIcon(string2 + "copy.gif"));
            this.copyBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.copyBtn);
            this.copyBtn.setToolTipText("Copy group");
            this.copyBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void setEnabled(boolean bl) {
            this.newBtn.setEnabled(bl);
            this.deleteBtn.setEnabled(bl);
            this.copyBtn.setEnabled(bl);
            this.helpBtn.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                this.groupManager.newGroup();
            } else if (object == this.deleteBtn) {
                this.groupManager.deleteGroup();
            } else if (object == this.copyBtn) {
                this.groupManager.copyGroup();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Task Node Conditions Group");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }
}

