/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import zeus.concepts.OntologyDb;
import zeus.concepts.TaskLink;
import zeus.concepts.TaskNode;
import zeus.generator.task.SummaryTaskNodeEditor;
import zeus.generator.task.TaskLinkPanel;
import zeus.generator.task.TaskNodePanel;

public class SummaryTaskNodeEditorDialog
extends JDialog
implements ActionListener,
ChangeListener {
    protected JTabbedPane tabbedPane;
    protected JButton okBtn;
    protected JButton cancelBtn;
    protected boolean changed = false;
    protected SummaryTaskNodeEditor editor = null;
    protected TaskNodePanel nodePanel;
    protected TaskLinkPanel linkPanel;

    public SummaryTaskNodeEditorDialog(Frame frame, OntologyDb ontologyDb) {
        super(frame, "Summary Task Node Editor");
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBackground(Color.lightGray);
        jPanel.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.nodePanel = new TaskNodePanel(ontologyDb, this);
        this.linkPanel = new TaskLinkPanel(this, this.nodePanel, this.nodePanel.getPreconditionsManager(), this.nodePanel.getPostconditionsManager());
        this.tabbedPane.addTab("Preconditions and Effects", this.nodePanel);
        this.tabbedPane.addTab("Links", this.linkPanel);
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.setTabPlacement(3);
        jPanel.add((Component)this.tabbedPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 10, 10));
        jPanel.add((Component)jPanel2, "South");
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
        jPanel2.setBorder(compoundBorder);
        this.okBtn = new JButton("OK");
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.addActionListener(this);
        jPanel2.add(this.okBtn);
        jPanel2.add(this.cancelBtn);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SummaryTaskNodeEditorDialog.this.closeDown(false);
            }
        });
        this.setModal(false);
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okBtn) {
            this.closeDown(this.changed);
        } else if (object == this.cancelBtn) {
            this.closeDown(false);
        }
    }

    protected void closeDown(boolean bl) {
        if (bl) {
            TaskNode taskNode = this.nodePanel.getNode();
            Hashtable hashtable = this.nodePanel.getNameTable();
            TaskLink[] taskLinkArray = this.linkPanel.getLinks();
            this.editor.editingStopped(taskNode, taskLinkArray, hashtable);
        } else {
            this.editor.editingCancelled();
        }
    }

    public void reset(SummaryTaskNodeEditor summaryTaskNodeEditor, TaskNode taskNode, TaskNode[] taskNodeArray, TaskLink[] taskLinkArray) {
        this.editor = summaryTaskNodeEditor;
        this.nodePanel.reset(taskNode);
        this.linkPanel.reset(taskNode, taskNodeArray, taskLinkArray);
        this.changed = false;
        this.tabbedPane.setSelectedIndex(0);
        this.pack();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.changed = true;
    }
}

