/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.awt.Component;
import java.awt.Frame;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import zeus.concepts.OntologyDb;
import zeus.concepts.TaskLink;
import zeus.concepts.TaskNode;
import zeus.generator.task.SummaryTaskModel;
import zeus.generator.task.SummaryTaskNodeEditorDialog;
import zeus.gui.graph.AbstractGraphNodeEditor;
import zeus.gui.graph.Graph;
import zeus.gui.graph.GraphNode;

public class SummaryTaskNodeEditor
extends AbstractGraphNodeEditor {
    protected SummaryTaskNodeEditorDialog dialog = null;
    protected OntologyDb ontologyDb = null;
    protected SummaryTaskModel model = null;

    public SummaryTaskNodeEditor(OntologyDb ontologyDb, SummaryTaskModel summaryTaskModel) {
        this.ontologyDb = ontologyDb;
        this.model = summaryTaskModel;
    }

    public Component getNodeEditorComponent(Graph graph, GraphNode graphNode) {
        this.graph = graph;
        this.node = graphNode;
        if (this.dialog == null) {
            this.dialog = new SummaryTaskNodeEditorDialog((Frame)SwingUtilities.getRoot(graph), this.ontologyDb);
        }
        TaskNode taskNode = (TaskNode)graphNode.getUserObject();
        this.dialog.reset(this, taskNode, this.model.getNodes(), this.model.getLinks());
        return this.dialog;
    }

    public void editingStopped(TaskNode taskNode, TaskLink[] taskLinkArray, Hashtable hashtable) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(taskNode);
        vector.addElement(taskLinkArray);
        vector.addElement(hashtable);
        this.fireEditAction(0, this.node, vector);
    }

    public void editingCancelled() {
        this.fireEditAction(1, this.node, null);
    }
}

