/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.Fact;
import zeus.concepts.Ordering;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.util.BasicFactModel;
import zeus.gui.editors.ValidatingModel;

public class OrderingModel
extends AbstractTableModel
implements ChangeListener,
ValidatingModel,
RenameListener {
    static final int BEFORE = 0;
    static final int AFTER = 1;
    protected static final String[] columnNames = new String[]{"Before", "After"};
    protected EventListenerList changeListeners = new EventListenerList();
    protected Vector data = new Vector();
    protected Vector validityInfo = new Vector();
    protected BasicFactModel preconditionsModel;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public OrderingModel(BasicFactModel basicFactModel, Ordering[] orderingArray) {
        this.preconditionsModel = basicFactModel;
        basicFactModel.addChangeListener(this);
        basicFactModel.addRenameListener(this);
        this.reset(orderingArray);
    }

    public void reset(Ordering[] orderingArray) {
        int n = this.data.size();
        this.data.removeAllElements();
        this.validityInfo.removeAllElements();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        Vector vector = this.getPreconditionIds();
        int n2 = 0;
        while (n2 < orderingArray.length) {
            this.data.addElement(orderingArray[n2]);
            this.validityInfo.addElement(this.isValid(orderingArray[n2], vector));
            ++n2;
        }
        this.fireTableRowsInserted(0, orderingArray.length - 1);
    }

    public Ordering[] getData() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.data.size()) {
            if (this.validityInfo.elementAt(n).equals(Boolean.TRUE)) {
                vector.addElement(this.data.elementAt(n));
            }
            ++n;
        }
        Ordering[] orderingArray = new Ordering[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            orderingArray[n2] = (Ordering)vector.elementAt(n2);
            ++n2;
        }
        return orderingArray;
    }

    public void removeRows(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.data.removeElementAt(nArray[n] - n);
            this.validityInfo.removeElementAt(nArray[n] - n);
            this.fireTableRowsDeleted(nArray[n] - n, nArray[n] - n);
            ++n;
        }
        this.fireTableStructureChanged();
        this.fireChanged();
    }

    public void addNewRows(String string, String[] stringArray) {
        int n = 0;
        int n2 = this.data.size();
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (this.additionOK(string, stringArray[n3], -1)) {
                ++n;
                Ordering ordering = new Ordering(string, stringArray[n3]);
                this.data.addElement(ordering);
                Vector vector = this.getPreconditionIds();
                this.validityInfo.addElement(this.isValid(ordering, vector));
            }
            ++n3;
        }
        if (n > 0) {
            this.fireTableRowsInserted(n2 - 1, n2 - 1 + n);
            this.fireTableStructureChanged();
            this.fireChanged();
        }
    }

    protected Vector getPreconditionIds() {
        Fact[] factArray = this.preconditionsModel.getData();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < factArray.length) {
            vector.addElement(factArray[n].getId());
            ++n;
        }
        return vector;
    }

    protected Boolean isValid(Ordering ordering, Vector vector) {
        boolean bl = vector.contains(ordering.getLHS()) && vector.contains(ordering.getRHS());
        return new Boolean(bl);
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isValidEntry(int n, int n2) {
        return this.validityInfo.elementAt(n).equals(Boolean.TRUE);
    }

    public Object getValueAt(int n, int n2) {
        Ordering ordering = (Ordering)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return ordering.getLHS();
            }
            case 1: {
                return ordering.getRHS();
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object.toString().equals("")) {
            return;
        }
        Ordering ordering = (Ordering)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                String string = (String)object;
                if (string.equals(ordering.getLHS())) {
                    return;
                }
                if (!this.additionOK(string, ordering.getRHS(), n)) {
                    return;
                }
                ordering.setLHS(string);
                Vector vector = this.getPreconditionIds();
                this.validityInfo.setElementAt(this.isValid(ordering, vector), n);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
                break;
            }
            case 1: {
                String string = (String)object;
                if (string.equals(ordering.getRHS())) {
                    return;
                }
                if (!this.additionOK(ordering.getLHS(), string, n)) {
                    return;
                }
                ordering.setRHS(string);
                Vector vector = this.getPreconditionIds();
                this.validityInfo.setElementAt(this.isValid(ordering, vector), n);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
            }
        }
    }

    protected boolean additionOK(String string, String string2, int n) {
        if (string.equals(string2)) {
            JOptionPane.showMessageDialog(null, "Attempting to add ordering " + string + "  --> " + string2, "Error", 0);
            return false;
        }
        int n2 = 0;
        while (n2 < this.data.size()) {
            if (n2 != n) {
                Ordering ordering = (Ordering)this.data.elementAt(n2);
                if (ordering.getLHS().equals(string) && ordering.getRHS().equals(string2)) {
                    JOptionPane.showMessageDialog(null, "Table already contains the ordering\n" + string + " < " + string2, "Error", 0);
                    return false;
                }
                if (ordering.getRHS().equals(string) && ordering.getLHS().equals(string2)) {
                    JOptionPane.showMessageDialog(null, "Attempting to add ordering " + string + " < " + string2 + "\nwhen table already contains ordering " + string2 + " < " + string, "Error", 0);
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Vector vector = this.getPreconditionIds();
        int n = 0;
        while (n < this.data.size()) {
            Ordering ordering = (Ordering)this.data.elementAt(n);
            this.validityInfo.setElementAt(this.isValid(ordering, vector), n);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public void nameChanged(RenameEvent renameEvent) {
        String string = (String)renameEvent.getOriginal();
        String string2 = (String)renameEvent.getCurrent();
        int n = 0;
        while (n < this.data.size()) {
            Ordering ordering = (Ordering)this.data.elementAt(n);
            if (ordering.getLHS().equals(string)) {
                ordering.setLHS(string2);
            }
            if (ordering.getRHS().equals(string)) {
                ordering.setRHS(string2);
            }
            ++n;
        }
        this.fireTableDataChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = OrderingModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = OrderingModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? OrderingModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

