/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.Task;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.task.ConstraintsModel;
import zeus.generator.task.OrderingDialog;
import zeus.generator.task.OrderingModel;
import zeus.generator.task.OrderingSelector;
import zeus.generator.task.TaskEditor;
import zeus.generator.util.AttributeDialog;
import zeus.generator.util.AttributeSelector;
import zeus.generator.util.AttributeTreeModel;
import zeus.generator.util.BasicFactModel;
import zeus.generator.util.ControlPanel;
import zeus.gui.editors.ExpressionCellEditor;
import zeus.gui.editors.ValidatingCellRenderer;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class ConstraintsPanel
extends JPanel {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected Task task;
    protected JTable constraintsTable;
    protected JTable orderingTable;
    protected OrderingModel orderingModel;
    protected ConstraintsModel constraintsModel;
    protected BasicFactModel precondsModel;
    protected BasicFactModel postcondsModel;

    public ConstraintsPanel(AgentGenerator agentGenerator, GeneratorModel generatorModel, OntologyDb ontologyDb, TaskEditor taskEditor, Task task, BasicFactModel basicFactModel, BasicFactModel basicFactModel2) {
        JScrollPane jScrollPane;
        TitledBorder titledBorder;
        JToolBar jToolBar;
        TableColumn tableColumn;
        DefaultCellEditor defaultCellEditor;
        ValidatingCellRenderer validatingCellRenderer;
        DefaultTableColumnModel defaultTableColumnModel;
        this.task = task;
        this.precondsModel = basicFactModel;
        this.postcondsModel = basicFactModel2;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        ControlPanel controlPanel = new ControlPanel(taskEditor, "Task Constraints", false, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(controlPanel, gridBagConstraints);
        this.add(controlPanel);
        JPanel jPanel = null;
        if (task.isPrimitive()) {
            jPanel = new JPanel();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(8, 8, 8, 8);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
        }
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        if (task.isPrimitive()) {
            this.orderingModel = new OrderingModel(basicFactModel, ((PrimitiveTask)task).getOrdering());
            this.orderingModel.addChangeListener(taskEditor);
            defaultTableColumnModel = new DefaultTableColumnModel();
            validatingCellRenderer = new ValidatingCellRenderer(this.orderingModel);
            defaultCellEditor = new OrderingCellEditor();
            tableColumn = new TableColumn(0, 12, validatingCellRenderer, defaultCellEditor);
            tableColumn.setHeaderValue(this.orderingModel.getColumnName(0));
            defaultTableColumnModel.addColumn(tableColumn);
            tableColumn = new TableColumn(1, 12, validatingCellRenderer, defaultCellEditor);
            tableColumn.setHeaderValue(this.orderingModel.getColumnName(1));
            defaultTableColumnModel.addColumn(tableColumn);
            this.orderingTable = new JTable(this.orderingModel, defaultTableColumnModel);
            this.orderingTable.getTableHeader().setReorderingAllowed(false);
            this.orderingTable.setColumnSelectionAllowed(false);
            jToolBar = new OrderingToolBar();
            titledBorder = BorderFactory.createTitledBorder("Preconditions Ordering Constraints");
            titledBorder.setTitlePosition(2);
            titledBorder.setTitleJustification(3);
            titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
            titledBorder.setTitleColor(Color.blue);
            jPanel.setBorder(titledBorder);
            gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            jPanel.setBackground(Color.lightGray);
            jScrollPane = new JScrollPane(this.orderingTable);
            jScrollPane.setBorder(new BevelBorder(1));
            jScrollPane.setPreferredSize(new Dimension(340, 150));
            this.orderingTable.setBackground(Color.white);
            this.orderingTable.setMinimumSize(new Dimension(400, 200));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 8, 0, 0);
            gridBagLayout.setConstraints(jToolBar, gridBagConstraints);
            jPanel.add(jToolBar);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(8, 8, 8, 8);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            jPanel.add(jScrollPane);
        }
        this.constraintsModel = new ConstraintsModel(basicFactModel, basicFactModel2, task.getConstraints());
        this.constraintsModel.addChangeListener(taskEditor);
        defaultCellEditor = new ExpressionCellEditor(this.constraintsModel);
        defaultCellEditor.addMouseListener(new SymMouseAction());
        validatingCellRenderer = new ValidatingCellRenderer(this.constraintsModel);
        defaultTableColumnModel = new DefaultTableColumnModel();
        tableColumn = new TableColumn(0, 12, validatingCellRenderer, defaultCellEditor);
        tableColumn.setHeaderValue(this.constraintsModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        this.constraintsTable = new JTable(this.constraintsModel, defaultTableColumnModel);
        this.constraintsTable.getTableHeader().setReorderingAllowed(false);
        this.constraintsTable.setColumnSelectionAllowed(false);
        jToolBar = new ConstraintsToolBar();
        titledBorder = BorderFactory.createTitledBorder("Task Applicability Constraints");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder);
        gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBackground(Color.lightGray);
        jScrollPane = new JScrollPane(this.constraintsTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(340, 150));
        this.constraintsTable.setBackground(Color.white);
        this.constraintsTable.setMinimumSize(new Dimension(400, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(jToolBar, gridBagConstraints);
        jPanel2.add(jToolBar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
    }

    protected boolean isRowSelected(JTable jTable) {
        int n = jTable.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return false;
        }
        return true;
    }

    protected void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    void save() {
        this.task.setConstraints(this.constraintsModel.getData());
        if (this.task.isPrimitive()) {
            ((PrimitiveTask)this.task).setOrdering(this.orderingModel.getData());
        }
    }

    class SymMouseAction
    extends MouseAdapter
    implements AttributeSelector {
        protected JTextComponent field = null;
        protected AttributeDialog dialog = null;
        protected AttributeTreeModel attributeTreeModel = new AttributeTreeModel();

        public SymMouseAction() {
            this.attributeTreeModel.setFactModels(ConstraintsPanel.this.precondsModel, ConstraintsPanel.this.postcondsModel);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.field = (JTextComponent)mouseEvent.getSource();
                if (this.dialog == null) {
                    this.dialog = new AttributeDialog((Frame)SwingUtilities.getRoot(this.field), this.attributeTreeModel);
                }
                this.dialog.setLocationRelativeTo(this.field);
                this.dialog.display(this);
            }
        }

        public void attributeSelected(String string) {
            try {
                Document document = this.field.getDocument();
                int n = document.getLength();
                AttributeSet attributeSet = document.getDefaultRootElement().getAttributes();
                document.insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    class OrderingCellEditor
    extends DefaultCellEditor {
        public OrderingCellEditor() {
            super(new JComboBox(){

                public void contentsChanged(ListDataEvent listDataEvent) {
                    this.selectedItemReminder = null;
                    super.contentsChanged(listDataEvent);
                }
            });
            this.setClickCountToStart(2);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComboBox jComboBox = (JComboBox)this.editorComponent;
            Fact[] factArray = ConstraintsPanel.this.precondsModel.getData();
            String[] stringArray = new String[factArray.length];
            int n3 = 0;
            while (n3 < factArray.length) {
                stringArray[n3] = factArray[n3].getId();
                ++n3;
            }
            if (jComboBox.getItemCount() != 0) {
                jComboBox.removeAllItems();
            }
            int n4 = 0;
            while (n4 < stringArray.length) {
                jComboBox.addItem(stringArray[n4]);
                ++n4;
            }
            jComboBox.setSelectedItem(object);
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    class ConstraintsToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin;
        protected JToggleButton helpBtn;
        protected JButton newBtn;
        protected JButton deleteBtn;

        public ConstraintsToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New");
            this.newBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void setEnabled(boolean bl) {
            this.newBtn.setEnabled(bl);
            this.deleteBtn.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                ConstraintsPanel.this.constraintsModel.addNewRow();
            } else if (object == this.deleteBtn) {
                if (!ConstraintsPanel.this.isRowSelected(ConstraintsPanel.this.constraintsTable)) {
                    return;
                }
                ConstraintsPanel.this.constraintsModel.removeRows(ConstraintsPanel.this.constraintsTable.getSelectedRows());
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Task Applicability Constraints Table");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class OrderingToolBar
    extends JToolBar
    implements ActionListener,
    OrderingSelector {
        protected HelpWindow helpWin;
        protected JToggleButton helpBtn;
        protected JButton newBtn;
        protected JButton deleteBtn;
        protected OrderingDialog dialog;

        public OrderingToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New");
            this.newBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
            this.dialog = new OrderingDialog((Frame)SwingUtilities.getRoot(this), "Select ordering", ConstraintsPanel.this.precondsModel);
        }

        public void setEnabled(boolean bl) {
            this.newBtn.setEnabled(bl);
            this.deleteBtn.setEnabled(bl);
        }

        public void orderingSelected(String string, String[] stringArray) {
            ConstraintsPanel.this.orderingModel.addNewRows(string, stringArray);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                this.dialog.setLocationRelativeTo(this.newBtn);
                this.dialog.display(this);
            } else if (object == this.deleteBtn) {
                if (!ConstraintsPanel.this.isRowSelected(ConstraintsPanel.this.orderingTable)) {
                    return;
                }
                ConstraintsPanel.this.orderingModel.removeRows(ConstraintsPanel.this.orderingTable.getSelectedRows());
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Preconditions Ordering Table");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }
}

