/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.task;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.Fact;
import zeus.concepts.ZeusParser;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.generator.event.RenameEvent;
import zeus.generator.event.RenameListener;
import zeus.generator.util.BasicFactModel;
import zeus.gui.editors.ValidatingModel;
import zeus.util.Misc;

public class ConstraintsModel
extends AbstractTableModel
implements ChangeListener,
ValidatingModel,
RenameListener {
    static final int CONSTRAINT = 0;
    protected static final String[] columnNames = new String[]{"Constraint"};
    protected EventListenerList changeListeners = new EventListenerList();
    protected Vector data = new Vector();
    protected Vector validityInfo = new Vector();
    protected BasicFactModel preconditionsModel;
    protected BasicFactModel postconditionsModel;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public ConstraintsModel(BasicFactModel basicFactModel, BasicFactModel basicFactModel2, LogicalFn[] logicalFnArray) {
        this.preconditionsModel = basicFactModel;
        this.postconditionsModel = basicFactModel2;
        basicFactModel.addChangeListener(this);
        basicFactModel2.addChangeListener(this);
        basicFactModel.addRenameListener(this);
        basicFactModel2.addRenameListener(this);
        this.reset(logicalFnArray);
    }

    public void reset(LogicalFn[] logicalFnArray) {
        int n = this.data.size();
        this.data.removeAllElements();
        this.validityInfo.removeAllElements();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        Vector vector = this.getConditions();
        int n2 = 0;
        while (n2 < logicalFnArray.length) {
            this.data.addElement(logicalFnArray[n2].toString());
            this.validityInfo.addElement(this.isValid(logicalFnArray[n2], vector));
            ++n2;
        }
        this.fireTableRowsInserted(0, logicalFnArray.length - 1);
    }

    public LogicalFn[] getData() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.data.size()) {
            if (this.validityInfo.elementAt(n).equals(Boolean.TRUE)) {
                vector.addElement(this.data.elementAt(n));
            }
            ++n;
        }
        LogicalFn[] logicalFnArray = new LogicalFn[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            logicalFnArray[n2] = (LogicalFn)ZeusParser.Expression((String)vector.elementAt(n2));
            ++n2;
        }
        return logicalFnArray;
    }

    public void removeRows(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.data.removeElementAt(nArray[n] - n);
            this.validityInfo.removeElementAt(nArray[n] - n);
            this.fireTableRowsDeleted(nArray[n] - n, nArray[n] - n);
            ++n;
        }
        this.fireTableStructureChanged();
        this.fireChanged();
    }

    public void addNewRow() {
        this.data.addElement("true");
        Vector vector = this.getConditions();
        this.validityInfo.addElement(this.isValid("true", vector));
        int n = this.data.size();
        this.fireTableRowsInserted(n - 1, n - 1);
        this.fireTableStructureChanged();
        this.fireChanged();
    }

    protected Vector getConditions() {
        Vector<String> vector = new Vector<String>();
        Fact[] factArray = this.preconditionsModel.getData();
        int n = 0;
        while (n < factArray.length) {
            vector.addElement(factArray[n].getId());
            ++n;
        }
        factArray = this.postconditionsModel.getData();
        int n2 = 0;
        while (n2 < factArray.length) {
            vector.addElement(factArray[n2].getId());
            ++n2;
        }
        return vector;
    }

    protected Boolean isValid(LogicalFn logicalFn, Vector vector) {
        Vector vector2 = logicalFn.variables();
        int n = 0;
        while (n < vector2.size()) {
            if (!vector.contains(vector2.elementAt(n).toString())) {
                return Boolean.FALSE;
            }
            ++n;
        }
        return Boolean.TRUE;
    }

    protected Boolean isValid(String string, Vector vector) {
        ValueFunction valueFunction = ZeusParser.Expression(string);
        if (valueFunction != null && valueFunction instanceof LogicalFn) {
            return this.isValid((LogicalFn)valueFunction, vector);
        }
        return new Boolean(false);
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isValidEntry(int n, int n2) {
        return this.validityInfo.elementAt(n).equals(Boolean.TRUE);
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.data.elementAt(n);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object.toString().equals("")) {
            return;
        }
        String string = (String)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                String string2 = (String)object;
                if (string2.equals(string)) {
                    return;
                }
                this.data.setElementAt(string2, n);
                Vector vector = this.getConditions();
                this.validityInfo.setElementAt(this.isValid(string2, vector), n);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.preconditionsModel || changeEvent.getSource() == this.postconditionsModel) {
            Vector vector = this.getConditions();
            int n = 0;
            while (n < this.data.size()) {
                String string = (String)this.data.elementAt(n);
                this.validityInfo.setElementAt(this.isValid(string, vector), n);
                ++n;
            }
            this.fireTableDataChanged();
        }
    }

    public void nameChanged(RenameEvent renameEvent) {
        String string = (String)renameEvent.getOriginal();
        String string2 = (String)renameEvent.getCurrent();
        int n = 0;
        while (n < this.data.size()) {
            String string3 = (String)this.data.elementAt(n);
            this.data.setElementAt(Misc.substitute(string3, string, string2), n);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ConstraintsModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ConstraintsModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? ConstraintsModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

