/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JTextArea;
import zeus.concepts.AbstractTask;
import zeus.concepts.Fact;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ReteKB;
import zeus.generator.GeneratorModel;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.TaskInfo;
import zeus.generator.code.Writer;
import zeus.util.SystemProps;

public class TaskWriter
extends Writer {
    public static final String CH = "_";

    public TaskWriter(GenerationPlan generationPlan, GeneratorModel generatorModel, String string, JTextArea jTextArea) {
        super(generationPlan, generatorModel, string, jTextArea);
    }

    public void write() {
        TaskInfo[] taskInfoArray = this.genplan.getSelectedTasks();
        if (taskInfoArray.length == 0) {
            return;
        }
        this.textArea.append("\n*** Task code generation started ***\n\n");
        int n = 0;
        while (n < taskInfoArray.length) {
            AbstractTask abstractTask = this.genmodel.getTask(taskInfoArray[n].id);
            String string = this.genmodel.getTaskName(taskInfoArray[n].id);
            this.textArea.append("Generating code for task " + string + "\n");
            if (!abstractTask.isValid()) {
                this.textArea.append("Task " + string + "is improperly specified\n");
            }
            try {
                switch (abstractTask.getType()) {
                    case 0: {
                        if (!taskInfoArray[n].task_external.equals("null")) {
                            this.writePrimitiveTask(string, taskInfoArray[n].task_external, (PrimitiveTask)abstractTask);
                            break;
                        }
                        this.writePrimitiveTask(string, (PrimitiveTask)abstractTask);
                        break;
                    }
                    case 2: {
                        if (!taskInfoArray[n].task_external.equals("null")) {
                            System.out.println("Externals ignored for Rulebased tasks...");
                            System.out.println("Continuing generation of rulebase task :" + string);
                            this.writeReteKB(string, (ReteKB)abstractTask);
                            break;
                        }
                        this.writeReteKB(string, (ReteKB)abstractTask);
                    }
                }
                taskInfoArray[n].status = "Saved";
                taskInfoArray[n].generate = false;
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            ++n;
        }
        this.textArea.append("\n*** Task code generation completed ***\n");
    }

    protected void writeReteKB(String string, ReteKB reteKB) throws IOException {
        PrintWriter printWriter = this.createFile(string + ".clp");
        printWriter.println("/*\n\tThis software was produced as a part of research\n\tactivities. It is not intended to be used as commercial\n\tor industrial software by any organisation. Except as\n\texplicitly stated, no guarantees are given as to its\n\treliability or trustworthiness if used for purposes other\n\tthan those for which it was originally intended.\n \n\t(c) British Telecommunications plc 1999.\n*/\n");
        String string2 = reteKB.getName();
        reteKB.setName(string);
        printWriter.println(reteKB.pprint());
        reteKB.setName(string2);
        printWriter.flush();
        printWriter.close();
    }

    protected void writePrimitiveTask(String string, PrimitiveTask primitiveTask) throws IOException {
        PrintWriter printWriter = this.createFile(string + ".java");
        printWriter.println("/*\n\tThis software was produced as a part of research\n\tactivities. It is not intended to be used as commercial\n\tor industrial software by any organisation. Except as\n\texplicitly stated, no guarantees are given as to its\n\treliability or trustworthiness if used for purposes other\n\tthan those for which it was originally intended.\n \n\t(c) British Telecommunications plc 1999.\n*/\n");
        printWriter.println("/*");
        printWriter.println("This stub file was automatically generated by ZeusAgentGenerator version " + SystemProps.getProperty("version.id"));
        printWriter.println("*/\n");
        printWriter.println("import java.util.*;");
        printWriter.println("import zeus.util.*;");
        printWriter.println("import zeus.concepts.*;");
        printWriter.println("import zeus.actors.TaskContext;");
        printWriter.println("import zeus.actors.ZeusTask;");
        printWriter.println();
        printWriter.println("public class " + string + " extends ZeusTask {");
        printWriter.println("   protected void exec() {");
        printWriter.println("      /*");
        printWriter.println("      Add the task execution code here. The following variables are defined:");
        printWriter.println("         protected Fact[][]  inputArgs; ");
        printWriter.println("         protected Fact[][]  outputArgs; ");
        printWriter.println("      Before exec() is called inputArgs will contain the input");
        printWriter.println("      Facts consumed by the task. After execution, set outputArgs to ");
        printWriter.println("      contain the output Facts produced by the task.");
        printWriter.println("      */");
        printWriter.println();
        printWriter.println("      // The Input Facts:");
        printWriter.println();
        Fact[] factArray = primitiveTask.getPreconditions();
        int n = 0;
        while (n < factArray.length) {
            printWriter.println("      Fact[] _" + factArray[n].ID() + " = inputArgs[" + n + "];\t// " + factArray[n].getType());
            ++n;
        }
        printWriter.println();
        printWriter.println("      // The Output Facts:");
        printWriter.println();
        Fact[] factArray2 = primitiveTask.getPostconditions();
        int n2 = 0;
        while (n2 < factArray2.length) {
            printWriter.println("      Fact[] _" + factArray2[n2].ID() + ";\t// " + factArray2[n2].getType());
            ++n2;
        }
        printWriter.println();
        printWriter.println("      /* USER CODE STARTS */");
        printWriter.println();
        printWriter.println("      System.out.println(\"-Expected Input-\");");
        printWriter.println("      for(int i = 0; i < expInputArgs.length; i++ )");
        printWriter.println("         System.out.println(expInputArgs[i].pprint());");
        printWriter.println();
        printWriter.println("      System.out.println(\"-Input-\");");
        printWriter.println("      for(int j = 0; j < inputArgs.length; j++) {");
        printWriter.println("         System.out.println(\"Input Fact[\"+j+\"]\");");
        printWriter.println("         for(int i = 0; i < inputArgs[j].length; i++)");
        printWriter.println("            System.out.println(inputArgs[j][i].pprint());");
        printWriter.println("      }");
        printWriter.println();
        printWriter.println("      System.out.println(\"-Expected Output-\");");
        printWriter.println("      for(int i = 0; i < expOutputArgs.length; i++ )");
        printWriter.println("         System.out.println(expOutputArgs[i].pprint());");
        printWriter.println();
        printWriter.println("      System.out.println(\"-Output-\");");
        int n3 = 0;
        while (n3 < factArray2.length) {
            printWriter.println("      _" + factArray2[n3].ID() + " = new Fact[1];");
            printWriter.println("      _" + factArray2[n3].ID() + "[0] = new Fact(Fact.FACT,expOutputArgs[" + n3 + "]);");
            printWriter.println("      System.out.println(_" + factArray2[n3].ID() + "[0].pprint());");
            ++n3;
        }
        printWriter.println();
        printWriter.println("      /* USER CODE ENDS */");
        printWriter.println("      outputArgs = new Fact[" + factArray2.length + "][];");
        int n4 = 0;
        while (n4 < factArray2.length) {
            printWriter.println("      outputArgs[" + n4 + "] = " + CH + factArray2[n4].ID() + ";");
            ++n4;
        }
        printWriter.println("   }");
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    protected void writePrimitiveTask(String string, String string2, PrimitiveTask primitiveTask) throws IOException {
        PrintWriter printWriter = this.createFile(string + ".java");
        printWriter.println("/*\n\tThis software was produced as a part of research\n\tactivities. It is not intended to be used as commercial\n\tor industrial software by any organisation. Except as\n\texplicitly stated, no guarantees are given as to its\n\treliability or trustworthiness if used for purposes other\n\tthan those for which it was originally intended.\n \n\t(c) British Telecommunications plc 1999.\n*/\n");
        printWriter.println("/*");
        printWriter.println("This stub file was automatically generated by ZeusAgentGenerator version " + SystemProps.getProperty("version.id"));
        printWriter.println("*/\n");
        printWriter.println(" /* Do not edit this class, it has a TaskExternal : " + string2);
        printWriter.println(" which it will call when it is executed. Add the code that you want ");
        printWriter.println(" to be executed when this task is run there instead. */");
        printWriter.println();
        printWriter.println("import java.util.*;");
        printWriter.println("import zeus.util.*;");
        printWriter.println("import zeus.concepts.*;");
        printWriter.println("import zeus.actors.ZeusTask;");
        printWriter.println("import zeus.actors.TaskContext;");
        printWriter.println("import zeus.actors.TaskExternal;");
        printWriter.println("import zeus.ontology.service.*;");
        printWriter.println();
        printWriter.println("public class " + string + " extends ZeusTask {\n");
        printWriter.println("   protected TaskExternal taskExternal;\n");
        printWriter.println("   protected void exec() {");
        printWriter.println();
        printWriter.println("      // The Input Facts:");
        printWriter.println();
        Fact[] factArray = primitiveTask.getPreconditions();
        int n = 0;
        while (n < factArray.length) {
            printWriter.println("      Fact[] _" + factArray[n].ID() + " = inputArgs[" + n + "];\t// " + factArray[n].getType());
            ++n;
        }
        printWriter.println();
        printWriter.println("      // The Output Facts:");
        printWriter.println();
        Fact[] factArray2 = primitiveTask.getPostconditions();
        int n2 = 0;
        while (n2 < factArray2.length) {
            printWriter.println("      Fact[] _" + factArray2[n2].ID() + ";\t// " + factArray2[n2].getType());
            ++n2;
        }
        printWriter.println("      System.out.println(\"-Expected Input-\");");
        printWriter.println("      for(int i = 0; i < expInputArgs.length; i++ )");
        printWriter.println("         System.out.println(expInputArgs[i].pprint());");
        printWriter.println();
        printWriter.println("      System.out.println(\"-Input-\");");
        printWriter.println("      for(int j = 0; j < inputArgs.length; j++) {");
        printWriter.println("         System.out.println(\"Input Fact[\"+j+\"]\");");
        printWriter.println("         for(int i = 0; i < inputArgs[j].length; i++)");
        printWriter.println("            System.out.println(inputArgs[j][i].pprint());");
        printWriter.println("      }");
        printWriter.println();
        printWriter.println("     // calling user defined zeus.concepts.TaskExternal");
        printWriter.println("    // first set the TaskContext object up ");
        printWriter.println("     TaskContext taskContext = new TaskContext(); ");
        printWriter.println("     taskContext.setAgentContext (this.context);");
        printWriter.println("     taskContext.setExpInputArgs (expInputArgs); ");
        printWriter.println("     taskContext.setInputArgs (inputArgs); ");
        printWriter.println("     taskContext.setExpOutputArgs (expOutputArgs); ");
        printWriter.println();
        printWriter.println("     outputArgs = new Fact [expOutputArgs.length][];");
        printWriter.println();
        printWriter.println("     for (int k=0; k<expOutputArgs.length; k++) {");
        printWriter.println("         outputArgs[k] = new Fact[1];");
        printWriter.println("         outputArgs[k][0] = new Fact(Fact.FACT, expOutputArgs[k]);");
        printWriter.println("     }");
        printWriter.println();
        printWriter.println("     taskContext.setOutputArgs (outputArgs); ");
        printWriter.println("     // now initialise the external object ");
        printWriter.println("     if(taskExternal == null) {");
        printWriter.println("       taskExternal = new " + string2 + "();");
        printWriter.println("     }");
        printWriter.println("     // now call the TaskExternal implementation specified for this task");
        printWriter.println("     taskExternal.exec(taskContext); ");
        printWriter.println();
        printWriter.println("     System.out.println(\"-Expected Output-\");");
        printWriter.println("     for(int i = 0; i < expOutputArgs.length; i++ )");
        printWriter.println("        System.out.println(expOutputArgs[i].pprint());");
        printWriter.println();
        printWriter.println("     outputArgs = taskContext.getOutputArgs();");
        printWriter.println();
        printWriter.println("     System.out.println(\"-Output-\");");
        printWriter.println("     for(int k = 0; k < outputArgs.length; k++ ) ");
        printWriter.println("         System.out.println(outputArgs[k][0].pprint());");
        printWriter.println("   }\n");
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }
}

