/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.util.Vector;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.NameserverInfo;
import zeus.generator.code.UtilityModel;

public class NameserverModel
extends UtilityModel {
    static final int NAME = 0;
    static final int HOST = 1;
    static final int IS_ROOT = 2;
    static final int TIME = 3;
    static final int SERVER_FILE = 4;
    static final int OUT_FILE = 5;
    static final int HAS_GUI = 6;
    static final int EXTERNAL = 7;
    protected static final String[] columnNames = new String[]{"Name", "Host", "Is root", "Time grain", "DNS file", "Address File", "Create GUI?", "External Program"};
    protected Vector data = new Vector();
    protected GenerationPlan genplan;

    public NameserverModel(GenerationPlan generationPlan) {
        this.genplan = generationPlan;
        generationPlan.addChangeListener(this);
        this.refresh();
    }

    public void addNewRow() {
        this.genplan.createNameserver();
    }

    public void removeRows(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            NameserverInfo nameserverInfo = (NameserverInfo)this.data.elementAt(nArray[n] - n);
            this.genplan.removeNameserver(nameserverInfo.id);
            ++n;
        }
    }

    protected void refresh() {
        this.data.removeAllElements();
        NameserverInfo[] nameserverInfoArray = this.genplan.getNameservers();
        int n = 0;
        while (n < nameserverInfoArray.length) {
            this.data.addElement(nameserverInfoArray[n]);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return columnNames.length - 2;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        NameserverInfo nameserverInfo = (NameserverInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
            case 3: {
                return nameserverInfo.is_root;
            }
            case 4: {
                return !nameserverInfo.is_root;
            }
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        NameserverInfo nameserverInfo = (NameserverInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return nameserverInfo.name;
            }
            case 1: {
                return nameserverInfo.host;
            }
            case 2: {
                return new Boolean(nameserverInfo.is_root);
            }
            case 6: {
                return new Boolean(nameserverInfo.has_gui);
            }
            case 7: {
                return nameserverInfo.zeus_external;
            }
            case 5: {
                return nameserverInfo.address_output_file;
            }
            case 3: {
                return nameserverInfo.time_grain;
            }
            case 4: {
                return nameserverInfo.dns_file;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        NameserverInfo nameserverInfo = (NameserverInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                nameserverInfo.name = this.updateString(nameserverInfo.name, object, false);
                break;
            }
            case 1: {
                nameserverInfo.host = this.updateString(nameserverInfo.host, object);
                break;
            }
            case 2: {
                nameserverInfo.is_root = this.updateBoolean(nameserverInfo.is_root, object);
                if (nameserverInfo.is_root) {
                    nameserverInfo.dns_file = null;
                    if (nameserverInfo.time_grain != null) break;
                    nameserverInfo.time_grain = NameserverInfo.DEFAULT_PERIOD;
                    break;
                }
                nameserverInfo.time_grain = null;
                break;
            }
            case 6: {
                nameserverInfo.has_gui = this.updateBoolean(nameserverInfo.has_gui, object);
                break;
            }
            case 7: {
                nameserverInfo.zeus_external = this.updateString(nameserverInfo.zeus_external, object);
                break;
            }
            case 5: {
                nameserverInfo.address_output_file = this.updateString(nameserverInfo.address_output_file, object);
                break;
            }
            case 3: {
                nameserverInfo.time_grain = this.updateString(nameserverInfo.time_grain, object);
                if (nameserverInfo.time_grain != null) break;
                nameserverInfo.time_grain = NameserverInfo.DEFAULT_PERIOD;
                break;
            }
            case 4: {
                nameserverInfo.dns_file = this.updateString(nameserverInfo.dns_file, object);
            }
        }
        if (this.changed) {
            this.genplan.setNameserver(nameserverInfo);
        }
    }
}

