/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import zeus.generator.code.GenerationPlan;

public class GenerationTableModel
extends AbstractTableModel
implements ChangeListener {
    static final int AGENT_FILTER = 1;
    static final int TASK_FILTER = 2;
    static final int UTILITY_FILTER = 3;
    protected static final String[] columnNames = new String[]{"Name", "Type", "Command Line"};
    protected Vector data = new Vector();
    protected boolean hideAgents = false;
    protected boolean hideTasks = false;
    protected boolean hideUtilities = false;
    protected GenerationPlan genplan;

    public GenerationTableModel(GenerationPlan generationPlan) {
        this.genplan = generationPlan;
        generationPlan.addChangeListener(this);
        this.refresh();
    }

    public void setFilter(int n) {
        if (n == 1) {
            this.hideAgents = !this.hideAgents;
        } else if (n == 2) {
            this.hideTasks = !this.hideTasks;
        } else if (n == 3) {
            this.hideUtilities = !this.hideUtilities;
        }
        this.refresh();
    }

    public void removeRows(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            String[] stringArray = (String[])this.data.elementAt(nArray[n] - n);
            this.genplan.removeEntry(stringArray[1], stringArray[3]);
            ++n;
        }
    }

    protected synchronized void refresh() {
        int n;
        String[][] stringArray;
        int n2 = this.data.size();
        this.data.removeAllElements();
        if (!this.hideUtilities) {
            stringArray = this.genplan.summarizeNameservers();
            n = 0;
            while (n < stringArray.length) {
                this.data.addElement(stringArray[n]);
                ++n;
            }
            stringArray = this.genplan.summarizeFacilitators();
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.data.addElement(stringArray[n3]);
                ++n3;
            }
            stringArray = this.genplan.summarizeVisualisers();
            int n4 = 0;
            while (n4 < stringArray.length) {
                this.data.addElement(stringArray[n4]);
                ++n4;
            }
            stringArray = this.genplan.summarizeDbProxys();
            int n5 = 0;
            while (n5 < stringArray.length) {
                this.data.addElement(stringArray[n5]);
                ++n5;
            }
        }
        if (!this.hideAgents) {
            stringArray = this.genplan.summarizeSelectedAgents();
            n = 0;
            while (n < stringArray.length) {
                this.data.addElement(stringArray[n]);
                ++n;
            }
        }
        if (!this.hideTasks) {
            stringArray = this.genplan.summarizeSelectedTasks();
            n = 0;
            while (n < stringArray.length) {
                this.data.addElement(stringArray[n]);
                ++n;
            }
        }
        if (n2 > 0) {
            this.fireTableRowsDeleted(0, n2 - 1);
        }
        if ((n = this.data.size()) > 0) {
            this.fireTableRowsInserted(0, n - 1);
        }
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            String[] stringArray = (String[])this.data.elementAt(n);
            return stringArray[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refresh();
    }
}

