/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import zeus.concepts.AbstractTask;
import zeus.concepts.AgentDescription;
import zeus.concepts.OntologyDb;
import zeus.generator.GeneratorModel;
import zeus.generator.code.AgentInfo;
import zeus.generator.code.DbProxyInfo;
import zeus.generator.code.FacilitatorInfo;
import zeus.generator.code.GenerationInfo;
import zeus.generator.code.NameserverInfo;
import zeus.generator.code.TaskInfo;
import zeus.generator.code.VisualiserInfo;
import zeus.generator.code.Writer;
import zeus.generator.event.AgentChangeEvent;
import zeus.generator.event.AgentListener;
import zeus.generator.event.TaskChangeEvent;
import zeus.generator.event.TaskListener;
import zeus.util.Misc;

public class GenerationPlan
implements AgentListener,
TaskListener,
ChangeListener {
    public static final String WINDOWS = "Windows";
    public static final String UNIX = "Unix";
    public static final String ZSH = "zsh";
    public static final String NONE = "no shell";
    public static final String SAVE_NEEDED = "Modified";
    public static final String NO_SAVE_NEEDED = "Saved";
    protected EventListenerList changeListeners = new EventListenerList();
    protected Hashtable agentTable = new Hashtable();
    protected Hashtable taskTable = new Hashtable();
    protected Hashtable nameserverTable = new Hashtable();
    protected Hashtable visualiserTable = new Hashtable();
    protected Hashtable facilitatorTable = new Hashtable();
    protected Hashtable dbProxyTable = new Hashtable();
    protected String directory = System.getProperty("user.dir");
    protected String platform = "Unix";
    protected String shell = "no shell";
    protected GeneratorModel genmodel;
    protected OntologyDb ontology;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public GenerationPlan(GeneratorModel generatorModel, OntologyDb ontologyDb) {
        this.genmodel = generatorModel;
        this.ontology = ontologyDb;
        generatorModel.addAgentListener(this);
        generatorModel.addTaskListener(this);
        ontologyDb.addChangeListener(this);
        this.reset();
    }

    public synchronized void setPlatform(String string) {
        if (!string.equals(UNIX) && !string.equals(WINDOWS)) {
            System.err.println("Unknown platform");
            return;
        }
        if (this.platform != null && this.platform.equals(string)) {
            return;
        }
        this.platform = string;
        this.recomputeOntologyFilePath();
        this.recomputeSavedState();
        this.fireChanged();
    }

    public void setShell(String string) {
        this.shell = string.equals(ZSH) ? string : NONE;
    }

    public String getShell() {
        return this.shell;
    }

    public synchronized String getPlatform() {
        return this.platform;
    }

    public synchronized void setDirectory(String string) {
        if (this.directory != null && this.directory.equals(string)) {
            return;
        }
        this.directory = string;
        this.recomputeOntologyFilePath();
        this.recomputeSavedState();
        this.fireChanged();
    }

    public synchronized String getDirectory() {
        return this.directory;
    }

    protected void recomputeSavedState() {
        Enumeration enumeration = this.agentTable.elements();
        while (enumeration.hasMoreElements()) {
            AgentInfo agentInfo = (AgentInfo)enumeration.nextElement();
            agentInfo.generate = true;
            agentInfo.status = SAVE_NEEDED;
        }
        enumeration = this.taskTable.elements();
        while (enumeration.hasMoreElements()) {
            TaskInfo taskInfo = (TaskInfo)enumeration.nextElement();
            taskInfo.generate = true;
            taskInfo.status = SAVE_NEEDED;
        }
    }

    protected void recomputeOntologyFilePath() {
        String string = this.getOntologyFilename();
        Enumeration enumeration = this.agentTable.elements();
        while (enumeration.hasMoreElements()) {
            AgentInfo agentInfo = (AgentInfo)enumeration.nextElement();
            agentInfo.ontology_file = string;
        }
        enumeration = this.facilitatorTable.elements();
        while (enumeration.hasMoreElements()) {
            FacilitatorInfo facilitatorInfo = (FacilitatorInfo)enumeration.nextElement();
            facilitatorInfo.ontology_file = string;
        }
        enumeration = this.visualiserTable.elements();
        while (enumeration.hasMoreElements()) {
            VisualiserInfo visualiserInfo = (VisualiserInfo)enumeration.nextElement();
            visualiserInfo.ontology_file = string;
        }
    }

    public synchronized AgentInfo[] getAgents() {
        AgentInfo[] agentInfoArray = new AgentInfo[this.agentTable.size()];
        Enumeration enumeration = this.agentTable.elements();
        int n = 0;
        while (n < agentInfoArray.length) {
            agentInfoArray[n] = (AgentInfo)enumeration.nextElement();
            ++n;
        }
        return agentInfoArray;
    }

    public synchronized void setAgent(AgentInfo agentInfo) {
        agentInfo.icon_file = this.genmodel.getAgentIcon(agentInfo.id);
        this.agentTable.put(agentInfo.id, agentInfo);
        this.fireChanged();
    }

    public synchronized void setAgentIcon(AgentInfo agentInfo) {
        this.genmodel.setAgentIcon(agentInfo.id, agentInfo.icon_file);
    }

    public synchronized TaskInfo[] getTasks() {
        TaskInfo[] taskInfoArray = new TaskInfo[this.taskTable.size()];
        Enumeration enumeration = this.taskTable.elements();
        int n = 0;
        while (n < taskInfoArray.length) {
            taskInfoArray[n] = (TaskInfo)enumeration.nextElement();
            ++n;
        }
        return taskInfoArray;
    }

    public synchronized void setTask(TaskInfo taskInfo) {
        this.taskTable.put(taskInfo.id, taskInfo);
        this.fireChanged();
    }

    public synchronized TaskInfo[] getSelectedTasks() {
        Enumeration enumeration = this.taskTable.elements();
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        while (enumeration.hasMoreElements()) {
            TaskInfo taskInfo = (TaskInfo)enumeration.nextElement();
            if (!taskInfo.generate) continue;
            vector.addElement(taskInfo);
        }
        TaskInfo[] taskInfoArray = new TaskInfo[vector.size()];
        int n = 0;
        while (n < taskInfoArray.length) {
            taskInfoArray[n] = (TaskInfo)vector.elementAt(n);
            ++n;
        }
        return taskInfoArray;
    }

    public synchronized AgentInfo[] getSelectedAgents() {
        Enumeration enumeration = this.agentTable.elements();
        Vector<AgentInfo> vector = new Vector<AgentInfo>();
        while (enumeration.hasMoreElements()) {
            AgentInfo agentInfo = (AgentInfo)enumeration.nextElement();
            if (!agentInfo.generate) continue;
            vector.addElement(agentInfo);
        }
        AgentInfo[] agentInfoArray = new AgentInfo[vector.size()];
        int n = 0;
        while (n < agentInfoArray.length) {
            agentInfoArray[n] = (AgentInfo)vector.elementAt(n);
            ++n;
        }
        return agentInfoArray;
    }

    public synchronized NameserverInfo[] getNameservers() {
        NameserverInfo[] nameserverInfoArray = new NameserverInfo[this.nameserverTable.size()];
        Enumeration enumeration = this.nameserverTable.elements();
        int n = 0;
        while (n < nameserverInfoArray.length) {
            nameserverInfoArray[n] = (NameserverInfo)enumeration.nextElement();
            ++n;
        }
        return nameserverInfoArray;
    }

    public synchronized void setNameserver(NameserverInfo nameserverInfo) {
        this.nameserverTable.put(nameserverInfo.id, nameserverInfo);
        this.fireChanged();
    }

    public synchronized void removeNameserver(String string) {
        this.nameserverTable.remove(string);
        this.fireChanged();
    }

    public synchronized void createNameserver() {
        NameserverInfo nameserverInfo = new NameserverInfo();
        this.nameserverTable.put(nameserverInfo.id, nameserverInfo);
        this.fireChanged();
    }

    public synchronized FacilitatorInfo[] getFacilitators() {
        FacilitatorInfo[] facilitatorInfoArray = new FacilitatorInfo[this.facilitatorTable.size()];
        Enumeration enumeration = this.facilitatorTable.elements();
        int n = 0;
        while (n < facilitatorInfoArray.length) {
            facilitatorInfoArray[n] = (FacilitatorInfo)enumeration.nextElement();
            ++n;
        }
        return facilitatorInfoArray;
    }

    public synchronized void setFacilitator(FacilitatorInfo facilitatorInfo) {
        this.facilitatorTable.put(facilitatorInfo.id, facilitatorInfo);
        this.fireChanged();
    }

    public synchronized void removeFacilitator(String string) {
        this.facilitatorTable.remove(string);
        this.fireChanged();
    }

    public synchronized void createFacilitator() {
        FacilitatorInfo facilitatorInfo = new FacilitatorInfo(this.getOntologyFilename());
        this.facilitatorTable.put(facilitatorInfo.id, facilitatorInfo);
        this.fireChanged();
    }

    public synchronized VisualiserInfo[] getVisualisers() {
        VisualiserInfo[] visualiserInfoArray = new VisualiserInfo[this.visualiserTable.size()];
        Enumeration enumeration = this.visualiserTable.elements();
        int n = 0;
        while (n < visualiserInfoArray.length) {
            visualiserInfoArray[n] = (VisualiserInfo)enumeration.nextElement();
            ++n;
        }
        return visualiserInfoArray;
    }

    public synchronized void setVisualiser(VisualiserInfo visualiserInfo) {
        this.visualiserTable.put(visualiserInfo.id, visualiserInfo);
        this.fireChanged();
    }

    public synchronized void removeVisualiser(String string) {
        this.visualiserTable.remove(string);
        this.fireChanged();
    }

    public synchronized void createVisualiser() {
        VisualiserInfo visualiserInfo = new VisualiserInfo(this.getOntologyFilename());
        this.visualiserTable.put(visualiserInfo.id, visualiserInfo);
        this.fireChanged();
    }

    public synchronized DbProxyInfo[] getDbProxys() {
        DbProxyInfo[] dbProxyInfoArray = new DbProxyInfo[this.dbProxyTable.size()];
        Enumeration enumeration = this.dbProxyTable.elements();
        int n = 0;
        while (n < dbProxyInfoArray.length) {
            dbProxyInfoArray[n] = (DbProxyInfo)enumeration.nextElement();
            ++n;
        }
        return dbProxyInfoArray;
    }

    public synchronized void setDbProxy(DbProxyInfo dbProxyInfo) {
        this.dbProxyTable.put(dbProxyInfo.id, dbProxyInfo);
        this.fireChanged();
    }

    public synchronized void removeDbProxy(String string) {
        this.dbProxyTable.remove(string);
        this.fireChanged();
    }

    public synchronized void createDbProxy() {
        DbProxyInfo dbProxyInfo = new DbProxyInfo();
        this.dbProxyTable.put(dbProxyInfo.id, dbProxyInfo);
        this.fireChanged();
    }

    public synchronized String[][] summarizeNameservers() {
        String[][] stringArray = new String[this.nameserverTable.size()][4];
        Enumeration enumeration = this.nameserverTable.elements();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((GenerationInfo)enumeration.nextElement()).summarize();
            ++n;
        }
        return stringArray;
    }

    public synchronized String[][] summarizeVisualisers() {
        String[][] stringArray = new String[this.visualiserTable.size()][4];
        Enumeration enumeration = this.visualiserTable.elements();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((GenerationInfo)enumeration.nextElement()).summarize();
            ++n;
        }
        return stringArray;
    }

    public synchronized String[][] summarizeFacilitators() {
        String[][] stringArray = new String[this.facilitatorTable.size()][4];
        Enumeration enumeration = this.facilitatorTable.elements();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((GenerationInfo)enumeration.nextElement()).summarize();
            ++n;
        }
        return stringArray;
    }

    public synchronized String[][] summarizeDbProxys() {
        String[][] stringArray = new String[this.dbProxyTable.size()][4];
        Enumeration enumeration = this.dbProxyTable.elements();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((GenerationInfo)enumeration.nextElement()).summarize();
            ++n;
        }
        return stringArray;
    }

    public synchronized String[][] summarizeSelectedTasks() {
        Enumeration enumeration = this.taskTable.elements();
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        while (enumeration.hasMoreElements()) {
            TaskInfo taskInfo = (TaskInfo)enumeration.nextElement();
            if (!taskInfo.generate) continue;
            vector.addElement(taskInfo);
        }
        String[][] stringArray = new String[vector.size()][4];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((TaskInfo)vector.elementAt(n)).summarize();
            ++n;
        }
        return stringArray;
    }

    public synchronized String[][] summarizeSelectedAgents() {
        Enumeration enumeration = this.agentTable.elements();
        Vector<AgentInfo> vector = new Vector<AgentInfo>();
        while (enumeration.hasMoreElements()) {
            AgentInfo agentInfo = (AgentInfo)enumeration.nextElement();
            if (!agentInfo.generate) continue;
            vector.addElement(agentInfo);
        }
        String[][] stringArray = new String[vector.size()][4];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((AgentInfo)vector.elementAt(n)).summarize();
            ++n;
        }
        return stringArray;
    }

    public synchronized String[][] summarizeTasks() {
        String[][] stringArray = new String[this.taskTable.size()][4];
        Enumeration enumeration = this.taskTable.elements();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((GenerationInfo)enumeration.nextElement()).summarize();
            ++n;
        }
        return stringArray;
    }

    public synchronized String[][] summarizeAgents() {
        String[][] stringArray = new String[this.agentTable.size()][4];
        Enumeration enumeration = this.agentTable.elements();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((GenerationInfo)enumeration.nextElement()).summarize();
            ++n;
        }
        return stringArray;
    }

    public synchronized void removeEntry(String string, String string2) {
        if (string.equals(GenerationInfo.NAMESERVER)) {
            this.removeNameserver(string2);
            return;
        }
        if (string.equals(GenerationInfo.VISUALISER)) {
            this.removeVisualiser(string2);
            return;
        }
        if (string.equals(GenerationInfo.FACILITATOR)) {
            this.removeFacilitator(string2);
            return;
        }
        if (string.equals(GenerationInfo.DBPROXY)) {
            this.removeDbProxy(string2);
            return;
        }
        if (string.equals(GenerationInfo.AGENT)) {
            AgentInfo agentInfo = (AgentInfo)this.agentTable.get(string2);
            agentInfo.generate = false;
            this.fireChanged();
        } else if (string.equals("Task")) {
            TaskInfo taskInfo = (TaskInfo)this.taskTable.get(string2);
            taskInfo.generate = false;
            this.fireChanged();
        }
    }

    public synchronized String getOntologyFilename() {
        String string = this.ontology.getFilename();
        string = Misc.relativePath(this.directory, string);
        if (this.platform.equals(WINDOWS)) {
            string = Writer.updateFilename(string, 1);
        } else if (this.platform.equals(UNIX)) {
            string = Writer.updateFilename(string, 0);
        }
        return string;
    }

    public synchronized void purge() {
        this.agentTable.clear();
        this.taskTable.clear();
        this.nameserverTable.clear();
        this.visualiserTable.clear();
        this.facilitatorTable.clear();
        this.dbProxyTable.clear();
        this.fireChanged();
    }

    public synchronized void reset() {
        this.purge();
        this.createNameserver();
        this.createFacilitator();
        this.createVisualiser();
        String string = this.getOntologyFilename();
        AgentDescription[] agentDescriptionArray = this.genmodel.getAgents();
        int n = 0;
        while (n < agentDescriptionArray.length) {
            AgentInfo agentInfo = new AgentInfo(agentDescriptionArray[n].getName(), this.genmodel.getAgentName(agentDescriptionArray[n].getName()), string);
            agentInfo.icon_file = this.genmodel.getAgentIcon(agentDescriptionArray[n].getName());
            this.agentTable.put(agentInfo.id, agentInfo);
            ++n;
        }
        AbstractTask[] abstractTaskArray = this.genmodel.getTasks();
        int n2 = 0;
        while (n2 < abstractTaskArray.length) {
            switch (abstractTaskArray[n2].getType()) {
                case 0: 
                case 2: {
                    TaskInfo taskInfo = new TaskInfo(abstractTaskArray[n2].getName(), this.genmodel.getTaskName(abstractTaskArray[n2].getName()));
                    this.taskTable.put(taskInfo.id, taskInfo);
                }
            }
            ++n2;
        }
        this.fireChanged();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.ontology) {
            this.recomputeOntologyFilePath();
            this.fireChanged();
        }
    }

    public void agentStateChanged(AgentChangeEvent agentChangeEvent) {
        AgentDescription agentDescription = agentChangeEvent.getAgent();
        int n = agentChangeEvent.getEventType();
        switch (n) {
            case 0: {
                AgentInfo agentInfo = new AgentInfo(agentDescription.getName(), this.genmodel.getAgentName(agentDescription.getName()), this.getOntologyFilename());
                agentInfo.icon_file = this.genmodel.getAgentIcon(agentDescription.getName());
                this.agentTable.put(agentInfo.id, agentInfo);
                break;
            }
            case 1: {
                AgentInfo agentInfo = (AgentInfo)this.agentTable.get(agentDescription.getName());
                agentInfo.name = this.genmodel.getAgentName(agentDescription.getName());
                agentInfo.icon_file = this.genmodel.getAgentIcon(agentDescription.getName());
                agentInfo.status = SAVE_NEEDED;
                agentInfo.generate = true;
                break;
            }
            case 2: {
                this.agentTable.remove(agentDescription.getName());
            }
        }
        this.fireChanged();
    }

    public void taskStateChanged(TaskChangeEvent taskChangeEvent) {
        AbstractTask abstractTask = taskChangeEvent.getTask();
        if (!abstractTask.isPrimitive() && !abstractTask.isBehaviour()) {
            return;
        }
        int n = taskChangeEvent.getEventType();
        switch (n) {
            case 0: {
                TaskInfo taskInfo = new TaskInfo(abstractTask.getName(), this.genmodel.getTaskName(abstractTask.getName()));
                this.taskTable.put(taskInfo.id, taskInfo);
                break;
            }
            case 1: {
                TaskInfo taskInfo = (TaskInfo)this.taskTable.get(abstractTask.getName());
                taskInfo.name = this.genmodel.getTaskName(abstractTask.getName());
                taskInfo.status = SAVE_NEEDED;
                taskInfo.generate = true;
                AgentDescription[] agentDescriptionArray = this.genmodel.getAgents();
                int n2 = 0;
                while (n2 < agentDescriptionArray.length) {
                    if (agentDescriptionArray[n2].containsTask(abstractTask.getName())) {
                        AgentInfo agentInfo = (AgentInfo)this.agentTable.get(agentDescriptionArray[n2].getName());
                        agentInfo.generate = true;
                        agentInfo.status = SAVE_NEEDED;
                    }
                    ++n2;
                }
                break;
            }
            case 2: {
                this.taskTable.remove(abstractTask.getName());
            }
        }
        this.fireChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = GenerationPlan.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = GenerationPlan.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? GenerationPlan.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

