/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.GenerationTableModel;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class GenerationPanel
extends JPanel
implements ActionListener,
ChangeListener,
FocusListener {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected JTable table;
    protected GenerationTableModel model;
    protected JTextField dirField;
    protected JRadioButton win;
    protected JRadioButton unix;
    protected JRadioButton zsh;
    protected JButton selectBtn;
    protected GenerationPlan genplan;
    protected JTextArea textArea;

    public GenerationPanel(GenerationPlan generationPlan) {
        this.genplan = generationPlan;
        generationPlan.addChangeListener(this);
        this.setBackground(Color.lightGray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.add(jPanel3);
        jPanel2.setBackground(Color.lightGray);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Generation Plan");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder);
        this.model = new GenerationTableModel(generationPlan);
        GenerationToolBar generationToolBar = new GenerationToolBar();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 24);
        tableColumn.setHeaderValue(this.model.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(this.model.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 24);
        tableColumn.setHeaderValue(this.model.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.model, defaultTableColumnModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(300, 160));
        this.table.setBackground(Color.white);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(generationToolBar, gridBagConstraints);
        jPanel2.add(generationToolBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        jPanel3.setBackground(Color.lightGray);
        titledBorder = BorderFactory.createTitledBorder("Generation Messages");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel3.setBorder(titledBorder);
        this.textArea = new JTextArea(12, 80);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setBackground(Color.white);
        jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(300, 160));
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel3.add(jScrollPane);
        jPanel.setBackground(Color.lightGray);
        BevelBorder bevelBorder = new BevelBorder(1);
        jPanel.setBorder(bevelBorder);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.dirField = new JTextField(20);
        this.dirField.addActionListener(this);
        this.dirField.addFocusListener(this);
        this.dirField.setText(generationPlan.getDirectory());
        String string = SystemProps.getProperty("gif.dir") + "generator" + System.getProperty("file.separator");
        this.selectBtn = new JButton("Choose Target Directory", new ImageIcon(string + "open.gif"));
        this.selectBtn.setToolTipText("Choose where source code will be written");
        this.selectBtn.addActionListener(this);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagLayout.setConstraints(this.selectBtn, gridBagConstraints);
        jPanel.add(this.selectBtn);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagLayout.setConstraints(this.dirField, gridBagConstraints);
        jPanel.add(this.dirField);
        JLabel jLabel = new JLabel("Create Scripts for ...", 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.win = new JRadioButton("Windows", false);
        this.unix = new JRadioButton("Unix", false);
        this.zsh = new JRadioButton("zsh", false);
        this.unix.setBackground(Color.lightGray);
        this.win.setBackground(Color.lightGray);
        this.zsh.setBackground(Color.lightGray);
        this.unix.addActionListener(this);
        this.win.addActionListener(this);
        this.zsh.addActionListener(this);
        if (generationPlan.getPlatform().equals("Windows")) {
            this.win.setSelected(true);
        } else {
            this.unix.setSelected(true);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.win);
        buttonGroup.add(this.unix);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagLayout.setConstraints(this.win, gridBagConstraints);
        jPanel.add(this.win);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagLayout.setConstraints(this.unix, gridBagConstraints);
        jPanel.add(this.unix);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagLayout.setConstraints(this.zsh, gridBagConstraints);
        jPanel.add(this.zsh);
    }

    protected void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    public void setWriteDir(String string) {
        this.dirField.setText(string);
    }

    public String getWriteDir() {
        return this.dirField.getText();
    }

    public boolean isWindowsPlatform() {
        return this.win.isSelected();
    }

    public boolean isUnixPlatform() {
        return this.unix.isSelected();
    }

    public boolean isZsh() {
        return this.zsh.isSelected();
    }

    protected String getDirectory() {
        String string = this.getWriteDir();
        FileDialog fileDialog = new FileDialog((Frame)SwingUtilities.getRoot(this), "Select (a file within) Target Directory", 0);
        fileDialog.setDirectory(string);
        fileDialog.pack();
        fileDialog.setVisible(true);
        return fileDialog.getDirectory();
    }

    protected JTextArea getTextArea() {
        return this.textArea;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.selectBtn) {
            String string = this.getDirectory();
            this.genplan.setDirectory(string);
            this.setWriteDir(string);
        } else if (object == this.dirField) {
            String string = this.getWriteDir();
            if (!string.equals(this.genplan.getDirectory())) {
                this.genplan.setDirectory(string);
            }
        } else if (object == this.unix) {
            if (!this.genplan.getPlatform().equals("Unix")) {
                this.genplan.setPlatform("Unix");
            }
        } else if (object == this.win) {
            if (!this.genplan.getPlatform().equals("Windows")) {
                this.genplan.setPlatform("Windows");
            }
        } else if (object == this.zsh) {
            if (!this.genplan.getShell().equals("zsh")) {
                this.genplan.setShell("zsh");
            } else {
                this.genplan.setShell("no shell");
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        String string;
        if (focusEvent.getSource() == this.dirField && !(string = this.getWriteDir()).equals(this.genplan.getDirectory())) {
            this.genplan.setDirectory(string);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.genplan) {
            String string;
            String string2;
            String string3 = this.getWriteDir();
            if (!string3.equals(string2 = this.genplan.getDirectory())) {
                this.setWriteDir(string2);
            }
            if ((string = this.genplan.getPlatform()).equals("Unix") && !this.unix.isSelected()) {
                this.unix.setSelected(true);
            } else if (string.equals("Windows") && !this.win.isSelected()) {
                this.win.setSelected(true);
            }
        }
    }

    protected class GenerationToolBar
    extends JToolBar
    implements ActionListener {
        protected JToggleButton agentBtn;
        protected JToggleButton taskBtn;
        protected JToggleButton utilityBtn;
        protected JButton deleteBtn;
        public JToggleButton helpBtn;
        protected HelpWindow helpWin;

        public GenerationToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.utilityBtn = new JToggleButton(new ImageIcon(string2 + "showutility.gif"), true);
            this.add(this.utilityBtn);
            this.utilityBtn.setToolTipText("Hide/Show Utility Agents");
            this.utilityBtn.setMargin(new Insets(0, 0, 0, 0));
            this.utilityBtn.addActionListener(this);
            this.agentBtn = new JToggleButton(new ImageIcon(string2 + "showagents.gif"), true);
            this.add(this.agentBtn);
            this.agentBtn.setToolTipText("Hide/Show Task Agents");
            this.agentBtn.setMargin(new Insets(0, 0, 0, 0));
            this.agentBtn.addActionListener(this);
            this.taskBtn = new JToggleButton(new ImageIcon(string2 + "showtasks.gif"), true);
            this.add(this.taskBtn);
            this.taskBtn.setToolTipText("Hide/Show Tasks");
            this.taskBtn.setMargin(new Insets(0, 0, 0, 0));
            this.taskBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete selected entry");
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.agentBtn) {
                GenerationPanel.this.model.setFilter(1);
            } else if (object == this.taskBtn) {
                GenerationPanel.this.model.setFilter(2);
            } else if (object == this.utilityBtn) {
                GenerationPanel.this.model.setFilter(3);
            } else if (object == this.deleteBtn) {
                if (GenerationPanel.this.table.getSelectedRow() == -1) {
                    GenerationPanel.this.errorMsg(0);
                    return;
                }
                GenerationPanel.this.model.removeRows(GenerationPanel.this.table.getSelectedRows());
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), this.getLocation(), "generator", "Generation Table");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }
}

