/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.util.Vector;
import zeus.generator.code.FacilitatorInfo;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.UtilityModel;

public class FacilitatorModel
extends UtilityModel {
    static final int NAME = 0;
    static final int HOST = 1;
    static final int SERVER_FILE = 2;
    static final int PERIOD = 3;
    static final int HAS_GUI = 4;
    static final int EXTERNAL = 5;
    protected static final String[] columnNames = new String[]{"Name", "Host", "DNS file", "Recycle period", "Create GUI?", "External Program"};
    protected Vector data = new Vector();
    protected GenerationPlan genplan;

    public FacilitatorModel(GenerationPlan generationPlan) {
        this.genplan = generationPlan;
        generationPlan.addChangeListener(this);
        this.refresh();
    }

    public void addNewRow() {
        this.genplan.createFacilitator();
    }

    public void removeRows(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            FacilitatorInfo facilitatorInfo = (FacilitatorInfo)this.data.elementAt(nArray[n] - n);
            this.genplan.removeFacilitator(facilitatorInfo.id);
            ++n;
        }
    }

    protected void refresh() {
        this.data.removeAllElements();
        FacilitatorInfo[] facilitatorInfoArray = this.genplan.getFacilitators();
        int n = 0;
        while (n < facilitatorInfoArray.length) {
            this.data.addElement(facilitatorInfoArray[n]);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return columnNames.length - 2;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        FacilitatorInfo facilitatorInfo = (FacilitatorInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return facilitatorInfo.name;
            }
            case 1: {
                return facilitatorInfo.host;
            }
            case 4: {
                return new Boolean(facilitatorInfo.has_gui);
            }
            case 5: {
                return facilitatorInfo.zeus_external;
            }
            case 3: {
                return facilitatorInfo.period;
            }
            case 2: {
                return facilitatorInfo.dns_file;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        FacilitatorInfo facilitatorInfo = (FacilitatorInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                facilitatorInfo.name = this.updateString(facilitatorInfo.name, object, false);
                break;
            }
            case 1: {
                facilitatorInfo.host = this.updateString(facilitatorInfo.host, object);
                break;
            }
            case 4: {
                facilitatorInfo.has_gui = this.updateBoolean(facilitatorInfo.has_gui, object);
                break;
            }
            case 5: {
                facilitatorInfo.zeus_external = this.updateString(facilitatorInfo.zeus_external, object);
                break;
            }
            case 3: {
                facilitatorInfo.period = this.updateString(facilitatorInfo.period, object);
                if (facilitatorInfo.period != null) break;
                facilitatorInfo.period = FacilitatorInfo.DEFAULT_PERIOD;
                break;
            }
            case 2: {
                facilitatorInfo.dns_file = this.updateString(facilitatorInfo.dns_file, object);
            }
        }
        if (this.changed) {
            this.genplan.setFacilitator(facilitatorInfo);
        }
    }
}

