/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.util.Vector;
import zeus.generator.code.DbProxyInfo;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.UtilityModel;

public class DbProxyModel
extends UtilityModel {
    static final int NAME = 0;
    static final int HOST = 1;
    static final int SERVER_FILE = 2;
    static final int PATH = 3;
    static final int HAS_GUI = 4;
    static final int EXTERNAL = 5;
    protected static final String[] columnNames = new String[]{"Name", "Host", "DNS file", "Proxy classpath", "Create GUI?", "External Program"};
    protected Vector data = new Vector();
    protected GenerationPlan genplan;

    public DbProxyModel(GenerationPlan generationPlan) {
        this.genplan = generationPlan;
        generationPlan.addChangeListener(this);
        this.refresh();
    }

    public void addNewRow() {
        this.genplan.createDbProxy();
    }

    public void removeRows(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            DbProxyInfo dbProxyInfo = (DbProxyInfo)this.data.elementAt(nArray[n] - n);
            this.genplan.removeDbProxy(dbProxyInfo.id);
            ++n;
        }
    }

    protected void refresh() {
        this.data.removeAllElements();
        DbProxyInfo[] dbProxyInfoArray = this.genplan.getDbProxys();
        int n = 0;
        while (n < dbProxyInfoArray.length) {
            this.data.addElement(dbProxyInfoArray[n]);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return columnNames.length - 2;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        DbProxyInfo dbProxyInfo = (DbProxyInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return dbProxyInfo.name;
            }
            case 1: {
                return dbProxyInfo.host;
            }
            case 4: {
                return new Boolean(dbProxyInfo.has_gui);
            }
            case 5: {
                return dbProxyInfo.zeus_external;
            }
            case 3: {
                return dbProxyInfo.path;
            }
            case 2: {
                return dbProxyInfo.dns_file;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        DbProxyInfo dbProxyInfo = (DbProxyInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                dbProxyInfo.name = this.updateString(dbProxyInfo.name, object, false);
                break;
            }
            case 1: {
                dbProxyInfo.host = this.updateString(dbProxyInfo.host, object);
                break;
            }
            case 4: {
                dbProxyInfo.has_gui = this.updateBoolean(dbProxyInfo.has_gui, object);
                break;
            }
            case 5: {
                dbProxyInfo.zeus_external = this.updateString(dbProxyInfo.zeus_external, object);
                break;
            }
            case 3: {
                dbProxyInfo.path = this.updateString(dbProxyInfo.path, object);
                break;
            }
            case 2: {
                dbProxyInfo.dns_file = this.updateString(dbProxyInfo.dns_file, object);
            }
        }
        if (this.changed) {
            this.genplan.setDbProxy(dbProxyInfo);
        }
    }
}

