/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import zeus.generator.code.GenerationInfo;
import zeus.generator.code.NameserverInfo;
import zeus.util.Misc;

public class DbProxyInfo
extends GenerationInfo {
    protected static int count = 0;
    public boolean has_gui = false;
    public String zeus_external = null;
    public String path = null;
    public String dns_file = NameserverInfo.DEFAULT_DNS;

    public DbProxyInfo() {
        this.name = GenerationInfo.DBPROXY + count++;
    }

    public DbProxyInfo(String string) {
        this.name = string;
    }

    public String[] summarize() {
        String[] stringArray = new String[4];
        stringArray[0] = this.name;
        stringArray[1] = GenerationInfo.DBPROXY;
        stringArray[3] = this.id;
        stringArray[2] = "java zeus.agents.DbProxy " + this.name + " -p " + this.path + " -s " + this.dns_file;
        if (this.has_gui) {
            stringArray[2] = stringArray[2] + " -gui zeus.agentviewer.BasicViewer";
        }
        if (this.zeus_external != null) {
            stringArray[2] = stringArray[2] + " -e " + this.zeus_external;
        }
        return stringArray;
    }

    public String isValid() {
        String string = "";
        if (this.path == null) {
            string = string + "DbProxy " + this.name + ": path not specified\n";
        }
        if (this.dns_file == null) {
            string = string + "DbProxy " + this.name + ": domain nameserver file not specified\n";
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public String toString() {
        String string = "";
        string = string + "(:name " + this.name;
        string = string + " :has_gui " + this.has_gui;
        if (this.host != null && !this.host.equals(GenerationInfo.LOCALHOST)) {
            string = string + " :host \"" + Misc.escape(this.host) + "\"";
        }
        if (this.zeus_external != null) {
            string = string + " :zeus_external \"" + Misc.escape(this.zeus_external) + "\"";
        }
        if (this.dns_file != null) {
            string = string + " :dns_file \"" + Misc.escape(this.dns_file) + "\"";
        }
        if (this.path != null) {
            string = string + " :path \"" + Misc.escape(this.path) + "\"";
        }
        string = string + ")";
        return string;
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string;
        String string3 = string;
        string3 = string3 + "(:name " + this.name + string2;
        string3 = string3 + " :has_gui " + this.has_gui + string2;
        if (this.host != null && !this.host.equals(GenerationInfo.LOCALHOST)) {
            string3 = string3 + " :host \"" + Misc.escape(this.host) + "\"" + string2;
        }
        if (this.zeus_external != null) {
            string3 = string3 + " :zeus_external \"" + Misc.escape(this.zeus_external) + "\"" + string2;
        }
        if (this.dns_file != null) {
            string3 = string3 + " :dns_file \"" + Misc.escape(this.dns_file) + "\"" + string2;
        }
        if (this.path != null) {
            string3 = string3 + " :path \"" + Misc.escape(this.path) + "\"" + string2;
        }
        string3 = string3 + ")";
        return string3;
    }
}

