/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import zeus.concepts.OntologyDb;
import zeus.generator.FileHandler;
import zeus.generator.GeneratorModel;
import zeus.generator.code.AgentPanel;
import zeus.generator.code.AgentWriter;
import zeus.generator.code.GenerationPanel;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.ScriptWriter;
import zeus.generator.code.TaskPanel;
import zeus.generator.code.TaskWriter;
import zeus.generator.code.UtilityPanel;
import zeus.gui.help.HelpWindow;
import zeus.util.GenSym;
import zeus.util.SystemProps;

public class CodeGenerator
extends JFrame {
    static final String CODE_GENERATOR = "Code Generator";
    protected JTabbedPane tabbedPane;
    protected GenerationPanel generationPanel;
    protected UtilityPanel utilityPanel;
    protected AgentPanel agentPanel;
    protected TaskPanel taskPanel;
    protected GeneratorModel genmodel;
    protected GenerationPlan genplan;
    protected boolean isSubFrame = false;
    protected AgentWriter agentWriter = null;
    protected TaskWriter taskWriter = null;
    protected ScriptWriter scriptWriter = null;

    public CodeGenerator(GeneratorModel generatorModel, GenerationPlan generationPlan, boolean bl) {
        this(generatorModel, generationPlan);
        this.isSubFrame = bl;
    }

    public CodeGenerator(GeneratorModel generatorModel, GenerationPlan generationPlan) {
        this.genmodel = generatorModel;
        this.genplan = generationPlan;
        this.setTitle(CODE_GENERATOR);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBackground(Color.gray);
        String string = SystemProps.getProperty("gif.dir") + "generator" + System.getProperty("file.separator");
        ImageIcon imageIcon = new ImageIcon(string + "stripe.gif");
        this.setIconImage(imageIcon.getImage());
        jPanel.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.generationPanel = new GenerationPanel(generationPlan);
        this.utilityPanel = new UtilityPanel(generationPlan);
        this.agentPanel = new AgentPanel(generationPlan);
        this.taskPanel = new TaskPanel(generationPlan);
        this.tabbedPane.addTab("Generation Plan", this.generationPanel);
        this.tabbedPane.addTab("Utility Agents", this.utilityPanel);
        this.tabbedPane.addTab("Task Agents", this.agentPanel);
        this.tabbedPane.addTab("Tasks", this.taskPanel);
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.setTabPlacement(3);
        jPanel.add((Component)this.tabbedPane, "Center");
        jPanel.add((Component)new ControlPanel(), "North");
        jPanel.setPreferredSize(new Dimension(800, 640));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CodeGenerator.this.cancel();
            }
        });
        this.pack();
    }

    protected void cancel() {
        this.setVisible(false);
        if (!this.isSubFrame) {
            System.exit(0);
        }
    }

    protected String createTargetDirectory() {
        File file;
        String string = this.genplan.getDirectory();
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.equals("")) {
            string = System.getProperty("user.dir");
        }
        if ((file = new File(string)).exists()) {
            string = file.isFile() ? file.getPath() : file.getAbsolutePath();
        } else if (!file.mkdirs()) {
            JOptionPane.showMessageDialog(this, "Cannot create directory\nCheck path name", "Error", 0);
            return null;
        }
        string = string + File.separator;
        return string;
    }

    protected void generateCode() {
        JTextArea jTextArea = this.generationPanel.getTextArea();
        jTextArea.setText("");
        String string = this.genmodel.ontology.getFilename();
        if (string == null) {
            jTextArea.append("You can not generate code until you have saved your ontology");
            return;
        }
        String string2 = this.createTargetDirectory();
        if (string2 == null || string2.equals("")) {
            jTextArea.append("You can not generate code until you have specified a target directory");
            return;
        }
        jTextArea.append("###### Code Generation Started ######\n\n");
        if (this.agentWriter == null) {
            this.agentWriter = new AgentWriter(this.genplan, this.genmodel, string2, jTextArea);
            this.taskWriter = new TaskWriter(this.genplan, this.genmodel, string2, jTextArea);
            this.scriptWriter = new ScriptWriter(this.genplan, this.genmodel, string2, jTextArea);
        }
        this.scriptWriter.write();
        this.agentWriter.write();
        this.taskWriter.write();
        jTextArea.append("\n###### Code Generation Completed ######\n");
    }

    protected static void usage() {
        System.err.println("Usage: java CodeGenerator -f <file> [-h] [-v]");
        System.exit(0);
    }

    protected static void version() {
        System.err.println("Zeus Code Generator version: " + SystemProps.getProperty("version.id"));
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-f") && ++n < stringArray.length) {
                string = stringArray[n];
            } else if (stringArray[n].equals("-h")) {
                CodeGenerator.usage();
            } else if (stringArray[n].equals("-v")) {
                CodeGenerator.version();
            } else {
                CodeGenerator.usage();
            }
            ++n;
        }
        if (string == null) {
            System.err.println("Error: No filename specified");
            CodeGenerator.usage();
        }
        GenSym genSym = new GenSym("AgentGenerator");
        OntologyDb ontologyDb = new OntologyDb(genSym);
        GeneratorModel generatorModel = new GeneratorModel(ontologyDb);
        GenerationPlan generationPlan = new GenerationPlan(generatorModel, ontologyDb);
        FileHandler fileHandler = new FileHandler(ontologyDb, generatorModel, generationPlan);
        CodeGenerator codeGenerator = new CodeGenerator(generatorModel, generationPlan);
        codeGenerator.setVisible(true);
        String string2 = System.getProperty("user.dir") + System.getProperty("file.separator");
        File file = new File(string2 + string);
        Frame frame = (Frame)SwingUtilities.getRoot(codeGenerator);
        Cursor cursor = frame.getCursor();
        frame.setCursor(new Cursor(3));
        int n2 = fileHandler.openFile(file);
        frame.setCursor(cursor);
        if ((n2 & 2) != 0) {
            JOptionPane.showMessageDialog(codeGenerator, fileHandler.getError(), "Error", 0);
            System.exit(0);
        } else if ((n2 & 1) != 0) {
            JOptionPane.showMessageDialog(codeGenerator, fileHandler.getWarning(), "Warning", 2);
        }
    }

    protected class ControlPanel
    extends JToolBar
    implements ActionListener {
        protected JButton generateBtn;
        protected JButton clearBtn;
        protected JButton cancelBtn;
        protected JToggleButton helpBtn;
        protected HelpWindow helpWin;

        public ControlPanel() {
            this.setBackground(Color.lightGray);
            this.setBorder(BorderFactory.createBevelBorder(0));
            this.setVisible(true);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.generateBtn = new JButton(new ImageIcon(string2 + "generate.gif"));
            this.generateBtn.addActionListener(this);
            this.generateBtn.setMargin(new Insets(0, 0, 0, 0));
            this.generateBtn.setToolTipText("Generate source code");
            this.add(this.generateBtn);
            this.addSeparator();
            this.clearBtn = new JButton(new ImageIcon(string2 + "clear-big.gif"));
            this.clearBtn.addActionListener(this);
            this.clearBtn.setMargin(new Insets(0, 0, 0, 0));
            this.clearBtn.setToolTipText("Clear code generation plan");
            this.add(this.clearBtn);
            this.addSeparator();
            this.cancelBtn = new JButton(new ImageIcon(string2 + "cancel.gif"));
            this.cancelBtn.addActionListener(this);
            this.cancelBtn.setMargin(new Insets(0, 0, 0, 0));
            this.cancelBtn.setToolTipText("Dismiss window");
            this.add(this.cancelBtn);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "info.gif"));
            this.helpBtn.addActionListener(this);
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.helpBtn.setToolTipText("Help about code generator");
            this.add(this.helpBtn);
            this.validate();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.generateBtn) {
                CodeGenerator.this.generateCode();
            } else if (object == this.clearBtn) {
                CodeGenerator.this.genplan.reset();
            } else if (object == this.cancelBtn) {
                CodeGenerator.this.cancel();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), this.getLocation(), "generator", CodeGenerator.CODE_GENERATOR);
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }
}

